package org.lsst.ccs.gconsole.plugins.demo;

import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.lsst.ccs.gconsole.ConsolePlugin;
import org.lsst.ccs.gconsole.Plugin;

/**
 * Demo plugin - Properties, Preferences, Menus.
 *
 * @author onoprien
 */
//@Plugin(name = "LSST CCS Plugin Demo",
//        description = "LSST CCS Plugin that demonstrates adding menu items and using plugin properties and preferences.")
public class PreferencesMenusPlugin extends ConsolePlugin {
    
    public enum Currency {USD("US Dollar"), EUR("Euro"), RUB("Rouble"), CLP("Peso");
        private final String hr;
        Currency(String humanReadableName) {
            hr = humanReadableName;
        }
        @Override
        public String toString() {
            return hr;
        }
    }

    /** Called by the framework when the plugin is loaded. */
    @Override
    public void initialize() {
        
        // Define plugin properties and preference dialog items.
        
        getServices().addProperty("oldEnough", true);
        getServices().addPreference(new String[] {"LSST", "Demo", "Pref"}, null, "${oldEnough} I am at least 21 years old.");
        
        getServices().addProperty("rangeMin", 13.5);
        getServices().addProperty("rangeMax", 100.);
        getServices().addProperty("currency", Currency.USD);
        getServices().addPreference(new String[] {"LSST", "Demo", "Pref"}, "Price range", "Min: ${rangeMin}  Max: ${rangeMax}");
        
        getServices().addProperty("quantity", 3);
        getServices().addPreference(new String[] {"LSST", "Demo", "Pref"}, null, "Quantity: ${quantity}");

        getServices().addProperty("name", "Jessica");
        getServices().addProperty("ms", 78);
        getServices().addProperty("home", "SLAC National Accelerator Laboratory");
        getServices().addPreference(new String[] {"LSST", "Demo", "Pref"}, "Addressee", "Name: ${name}  M/S: ${ms}");
        getServices().addPreference(new String[] {"LSST", "Demo", "Pref"}, "Addressee", "Home institution: ${home}");
        
        getServices().addPreference(new String[] {"LSST", "Demo", "Pref"}, "Price range", "Currency: ${currency}");
        
        // Add menu items
    
        Action act = new AbstractAction("Currency") {
            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("\nCurrency: "+ getServices().getProperty("currency"));
            }
        };
        getServices().addMenu(act, "Demo", "Preferences:1:2");
        
        act = new AbstractAction("Range") {
            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("\nMin: "+ getServices().getProperty("rangeMin") +"  Max: "+ getServices().getProperty("rangeMax"));
            }
        };
        getServices().addMenu(act, "Demo", "Preferences:1:1");
        
        act = new AbstractAction("Quantity") {
            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("\nQuantity: "+ getServices().getProperty("quantity"));
            }
        };
        getServices().addMenu(act, "Demo", "Preferences:1");
        
        act = new AbstractAction("Legal Age") {
            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("\nOld enough: "+ getServices().getProperty("oldEnough"));
            }
        };
        getServices().addMenu(act, "Demo", "Preferences");
        
        act = new AbstractAction("Name") {
            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("\nName: "+ getServices().getProperty("name"));
            }
        };
        getServices().addMenu(act, "Demo", "Preferences:2:2", "Addressee");
        
        act = new AbstractAction("Address") {
            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("\nAddress: M/S "+ getServices().getProperty("ms") +" at "+ getServices().getProperty("home"));
            }
        };
        getServices().addMenu(act, "Demo", "Preferences:2:1", "Addressee");
        
        act = new AbstractAction("Reset preferences") {
            @Override
            public void actionPerformed(ActionEvent e) {
                getServices().setProperty("oldEnough", null);
                getServices().setProperty("rangeMin", null);
                getServices().setProperty("rangeMax", null);
                getServices().setProperty("currency", null);
                getServices().setProperty("quantity", null);
                getServices().setProperty("name", null);
                getServices().setProperty("ms", null);
                getServices().setProperty("home", null);
            }
        };
        getServices().addMenu(act, "Demo");
               
    }
    
    /**
     * Called by the framework when plugin properties are modified.
     * 
     * @param source Source of notification.
     * @param changes For the changed properties, map of keys to their new values.
     */
    @Override
    public void propertiesChanged(Object source, Map<String, Object> changes) {
        System.out.println("\nProperties changed:");
        changes.forEach((key,value) -> System.out.println(key +" = "+ value));
    }
    
}
