package org.lsst.ccs.gconsole.plugins.console;

import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.freehep.jas.extensions.jconsole.JConsoleService;
import org.freehep.jas.extensions.jconsole.JLineConsole;
import org.freehep.jas.extensions.jconsole.JLineConsoleProvider;
import org.lsst.ccs.gconsole.ConsolePlugin;
import org.lsst.ccs.gconsole.Plugin;
import org.lsst.ccs.shell.JLineShell;
import org.lsst.ccs.subsystem.shell.ConsoleCommandShell;

/**
 * Plugin that creates and manages command consoles.
 */
@Plugin(name="LSST Console Plugin",
        description="LSST command console plugin.")
public class LsstConsolePlugin extends ConsolePlugin {
    
// -- Fields : -----------------------------------------------------------------

    private final String defaultConsoleName = "LSST Console";


// -- Life cycle : -------------------------------------------------------------
    
    @Override
    synchronized public void initialize() {
        getConsole().getLookup().add(this);
        Action newConsoleAction = new AbstractAction("LSST Console") {
            @Override
            public void actionPerformed(ActionEvent e) {
                createCommandConsole(defaultConsoleName);
            }
        };
        getServices().addMenu(newConsoleAction, "File", "New:-1:4");
    }

    @Override
    synchronized public void start() {
        JConsoleService cs = (JConsoleService) getConsole().getLookup().lookup(JConsoleService.class);
        if (cs == null) throw new IllegalStateException("JConsole service is not available");
        cs.addConsoleProvider(JLineConsole.class, new JLineConsoleProvider());
    }
    
    
// -- Handling consoles : ------------------------------------------------------

    synchronized private JLineConsole createCommandConsole(String name) {
        try {
            JConsoleService cs = (JConsoleService) getConsole().getLookup().lookup(JConsoleService.class);
            if (cs != null) {
                JLineConsole console = (JLineConsole) cs.createConsole(JLineConsole.class, name, null, null);
                JLineShell shell = ConsoleCommandShell.createJLineShell(getConsole().getMessagingAccess(), console.getConsoleReader());
                Thread t = new Thread("ConsoleInput-" + name) {
                    @Override
                    public void run() {
                        try {
                            shell.run();
                        } catch (IOException x) {
                            getConsole().error("Error in command shell", x);
                        } finally {
                        }
                    }
                };
                t.start();
                return console;
            }
        } catch (Exception x) {
            getConsole().error("Failed to start Console: " + name, x);
        }
        return null;
    }
    
}
