package org.lsst.ccs.gconsole.jas3;

import org.freehep.application.Application;
import org.freehep.application.studio.Plugin;
import org.freehep.application.studio.PluginFactory;
import org.freehep.application.studio.PluginInfo;
import org.freehep.application.studio.Studio;
import org.lsst.ccs.gconsole.ConsolePlugin;
import org.lsst.ccs.gconsole.ConsolePluginDescriptor;

/**
 * Factory that instantiates graphical console plugins using {@code org.freehep.application.studio.Plugin} as a handler.
 *
 * @author onoprien
 */
public class LsstPluginFactory implements PluginFactory {
    
    static private final Jas3Console agent = new Jas3Console();
    
    static {
        agent.start();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                agent.shutdown();
            } catch (Exception x) {}
        }));
        ((Studio)Application.getApplication()).getLookup().add(agent);
    }

    @Override
    public Plugin getInstance(Studio studio, PluginInfo pluginDescriptor, ClassLoader loader) throws Throwable {
        Class pluginClass = loader.loadClass(pluginDescriptor.getMainClass());
        if (Plugin.class.isAssignableFrom(pluginClass)) {
            return (Plugin) pluginClass.newInstance();
        } else {
            ConsolePlugin consolePlugin = (ConsolePlugin) pluginClass.newInstance();
            JasPlugin jasPlugin = new JasPlugin(consolePlugin);
            Jas3PluginServices provider = new Jas3PluginServices(agent, consolePlugin, new PluginDescriptor(pluginDescriptor), jasPlugin);
            synchronized (provider) {
                consolePlugin.setServicesProvider(provider);
            }
            return jasPlugin;
        }
    }

    static private class PluginDescriptor implements ConsolePluginDescriptor {

        private final String name;
        private final String version;
        private final String description;

        PluginDescriptor(String name, String version, String description) {
            this.name = name;
            this.version = version;
            this.description = description;
        }

        PluginDescriptor(PluginInfo info) {
            this.name = info.getName();
            this.version = info.getVersion();
            this.description = info.getDescription();
        }

        @Override
        public String getName() {
            return name;
        }

        @Override
        public String getVersion() {
            return version;
        }

        @Override
        public String getDescription() {
            return description;
        }

    }
    
    static private class JasPlugin extends Plugin {
        
        private final ConsolePlugin plugin;
        
        JasPlugin(ConsolePlugin consolePlugin) {
            plugin = consolePlugin;
        }

        @Override
        synchronized protected void init() throws Throwable {
        }

        @Override
        synchronized protected void postInit() {
            plugin.initialize();
        }

        @Override
        synchronized protected void applicationVisible() {
            plugin.start();
        }

        @Override
        synchronized protected void shutdown() {
            plugin.stop();
            plugin.shutdown();
        }
        
    }

}
