/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging;

import java.util.function.Predicate;
import org.lsst.ccs.bus.messages.BusMessage;

public abstract class BusMessageFilter
implements Predicate<BusMessage> {
    public static BusMessageFilter messageOrigin(String origin) {
        return new OriginBusMessageFilter(origin);
    }

    public static BusMessageFilter embeddedObjectClass(Class clazz) {
        return new EmbeddedObjectClassBusMessageFilter(clazz);
    }

    public static BusMessageFilter messageClass(Class clazz) {
        return new ClassBusMessageFilter(clazz);
    }

    public boolean accept(BusMessage busMessage) {
        return this.internalAccept(busMessage);
    }

    @Override
    public boolean test(BusMessage busMessage) {
        return this.accept(busMessage);
    }

    public BusMessageFilter or(BusMessageFilter filter) {
        BusMessageFilter f = filter;
        return new PredicateBasedMessageFilter(this.or(f), "(" + this.internalToString() + " || " + filter.internalToString() + ")");
    }

    public BusMessageFilter and(BusMessageFilter filter) {
        BusMessageFilter f = filter;
        return new PredicateBasedMessageFilter(this.and(f), "(" + this.internalToString() + " && " + filter.internalToString() + ")");
    }

    public BusMessageFilter negate() {
        Predicate<BusMessage> rawPred = m -> this.accept((BusMessage)m);
        return BusMessageFilter.fromPredicate(rawPred.negate());
    }

    public static BusMessageFilter fromPredicate(Predicate<BusMessage> p) {
        return new PredicateBasedMessageFilter(p, "predicate");
    }

    protected abstract boolean internalAccept(BusMessage var1);

    protected abstract String internalToString();

    public String toString() {
        String result = "(" + this.internalToString() + ")";
        return result;
    }

    private static class OriginBusMessageFilter
    extends BusMessageFilter {
        private final String origin;

        OriginBusMessageFilter(String origin) {
            this.origin = origin;
        }

        @Override
        public boolean internalAccept(BusMessage busMessage) {
            if (this.origin == null || "".equals(this.origin)) {
                return true;
            }
            return busMessage.getOriginAgentInfo().getName().equals(this.origin);
        }

        @Override
        protected String internalToString() {
            return " origin = " + this.origin + " ";
        }
    }

    private static class EmbeddedObjectClassBusMessageFilter
    extends BusMessageFilter {
        private final Class clazz;

        EmbeddedObjectClassBusMessageFilter(Class clazz) {
            this.clazz = clazz;
        }

        EmbeddedObjectClassBusMessageFilter(String clazz) {
            try {
                this.clazz = Class.forName(clazz);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Could not properly initialize BusMessage class filter", e);
            }
        }

        @Override
        public boolean internalAccept(BusMessage busMessage) {
            return busMessage.getClassName().equals(this.clazz.getName());
        }

        @Override
        protected String internalToString() {
            return " embedded class instanceof " + this.clazz.getCanonicalName() + " ";
        }
    }

    private static class ClassBusMessageFilter
    extends BusMessageFilter {
        private final Class clazz;

        ClassBusMessageFilter(Class clazz) {
            this.clazz = clazz;
        }

        ClassBusMessageFilter(String clazz) {
            try {
                this.clazz = Class.forName(clazz);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Could not properly initialize BusMessage class filter", e);
            }
        }

        @Override
        public boolean internalAccept(BusMessage busMessage) {
            return this.clazz.isInstance(busMessage);
        }

        @Override
        protected String internalToString() {
            return " class instanceof " + this.clazz.getCanonicalName() + " ";
        }
    }

    private static class PredicateBasedMessageFilter
    extends BusMessageFilter {
        Predicate<BusMessage> pred;
        String st;

        PredicateBasedMessageFilter(Predicate<BusMessage> p, String s) {
            this.pred = p;
            this.st = s;
        }

        @Override
        protected String internalToString() {
            return this.st;
        }

        @Override
        protected boolean internalAccept(BusMessage busMessage) {
            return this.pred.test(busMessage);
        }
    }
}

