/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.framework;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.ConfigurationServiceException;
import org.lsst.ccs.framework.Signal;
import org.lsst.ccs.utilities.structs.TreeBranch;
import org.lsst.ccs.utilities.structs.ViewValue;

public interface Configurable {
    public void setEnvironment(Environment var1);

    public Environment getEnvironment();

    default public Subsystem getSubsystem() {
        Optional<Subsystem> opt = this.getEnvironment().getSubsystem();
        if (opt.isPresent()) {
            return opt.get();
        }
        return null;
    }

    default public void init() {
    }

    default public void start() {
    }

    default public void postStart() throws HardwareException {
    }

    default public void shutdownNow() {
    }

    default public String getName() {
        Environment env = this.getEnvironment();
        if (env != null) {
            return this.getEnvironment().getNameOfComponent();
        }
        return null;
    }

    default public Object getComponentByName(String name) {
        return this.getEnvironment().getComponentByName(name);
    }

    default public <T> LinkedHashMap<String, T> getChildren(Class<T> clazz) {
        return this.getEnvironment().getChildren(clazz);
    }

    default public Object getParentObject() {
        return this.getEnvironment().getParent().getValue();
    }

    default public Map.Entry<String, Object> getParent() {
        return this.getEnvironment().getParent();
    }

    @Command(description="engineering mode change of parameter value", type=Command.CommandType.CONFIGURATION)
    default public void change(@Argument(name="parameterName", description="Configuration parameter name") String parameterName, @Argument(name="value", description="Configuration parameter value") Object value) throws Exception {
        this.getEnvironment().change(parameterName, value);
    }

    @Command(description="submit a potential change for a parameter", type=Command.CommandType.CONFIGURATION)
    default public void submitChange(@Argument(name="parameterName", description="Configuration parameter name") String parameterName, @Argument(name="value", description="Configuration parameter value") Object value) {
        this.getEnvironment().submitChange(parameterName, value);
    }

    @Command(description="submit potential changes for parameters", type=Command.CommandType.CONFIGURATION)
    default public void submitChanges(Map<String, Object> values) {
        try {
            for (Map.Entry<String, Object> parameter : values.entrySet()) {
                this.submitChange(parameter.getKey(), parameter.getValue());
            }
        }
        catch (Exception ex) {
            this.getEnvironment().dropBulkChange();
            throw ex;
        }
    }

    @Command(description="displays the current values of the parameters that belong to the given categories", type=Command.CommandType.CONFIGURATION)
    default public Map<String, String> printConfigurableParameters(String ... categories) {
        Map<String, String> res = this.getEnvironment().printConfigurableParameters(categories);
        return new TreeMap<String, String>(res);
    }

    @Command(description="prints the current state of the submitted changes", type=Command.CommandType.CONFIGURATION)
    default public Map<String, String> getSubmittedChanges() {
        Map<String, String> res = this.getEnvironment().getSubmittedChanges();
        return new TreeMap<String, String>(res);
    }

    @Command(description="drops the submitted changes for this component", type=Command.CommandType.CONFIGURATION)
    default public void dropSubmittedChanges() {
        this.getEnvironment().dropBulkChange();
    }

    default public void validateBulkChange(Map<String, Object> parametersView) {
    }

    default public Map<String, Object> setBulkParameter(Map<String, Object> parametersView) {
        return parametersView;
    }

    @Deprecated
    default public ViewValue getCheckedValueFromConfiguration(String parameterName, Object value) throws Exception {
        ViewValue data = this.getEnvironment().getCheckedValueFromConfiguration(parameterName, value);
        return data;
    }

    default public Boolean isParameterConfigurable(String parameterName) {
        return this.getEnvironment().isParameterConfigurable(parameterName);
    }

    default public void notifyChangeWithoutPreliminaryChecks(String parameterName, Object value) throws Exception {
        this.getEnvironment().notifyChangeWithoutPreliminaryChecks(parameterName, value);
    }

    default public void notifyChange(String parameterName, String value) throws Exception {
        this.getEnvironment().notifyChange(parameterName, value);
    }

    public static interface Environment {
        public void change(String var1, Object var2) throws Exception;

        public void submitChange(String var1, Object var2);

        public void saveAllChanges() throws ConfigurationServiceException;

        public void saveChangesForCategories(String ... var1) throws ConfigurationServiceException;

        public void saveChangesForCategoriesAs(String ... var1) throws ConfigurationServiceException;

        public void dropAllChanges() throws Exception;

        public void dropChangesForCategories(String ... var1) throws Exception;

        @Deprecated
        public ViewValue getCheckedValueFromConfiguration(String var1, Object var2) throws Exception;

        public Boolean isParameterConfigurable(String var1);

        public void notifyChangeWithoutPreliminaryChecks(String var1, Object var2) throws Exception;

        public void notifyChange(String var1, String var2) throws Exception;

        public Object getComponentByName(String var1);

        public <T> LinkedHashMap<String, T> getChildren(Class<T> var1);

        public Map.Entry<String, Object> getParent();

        public String getNameOfComponent();

        public Optional<Subsystem> getSubsystem();

        public void dropBulkChange();

        public TreeBranch<String> getComponentTree();

        public void sendSignal(Signal var1);

        public Map<String, String> printConfigurableParameters(String[] var1);

        public Map<String, String> getSubmittedChanges();
    }
}

