/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.startup;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.config.ConfigurableSubsystem;
import org.lsst.ccs.config.ConfigurationProxy;
import org.lsst.ccs.description.ComponentLookupService;
import org.lsst.ccs.framework.Configurable;
import org.lsst.ccs.framework.ConfigurationServiceException;
import org.lsst.ccs.framework.Signal;
import org.lsst.ccs.framework.SignalHandler;
import org.lsst.ccs.utilities.conv.TypeConversionException;
import org.lsst.ccs.utilities.structs.TreeBranch;
import org.lsst.ccs.utilities.structs.ViewValue;

public class ConfigurationEnvironment
implements Configurable.Environment {
    private final String name;
    private final ConfigurationProxy configurationProxy;
    private final ComponentLookupService lookupService;
    private final ConfigurableSubsystem subsystem;

    public ConfigurationEnvironment(String name, ConfigurationProxy configurationProxy, ComponentLookupService lookupService, ConfigurableSubsystem s) {
        this.name = name;
        this.configurationProxy = Objects.requireNonNull(configurationProxy);
        this.lookupService = Objects.requireNonNull(lookupService);
        this.subsystem = Objects.requireNonNull(s);
    }

    public void change(String parameterName, Object value) throws Exception {
        if (!this.isInEngineeringMode()) {
            throw new IllegalStateException("Configuration actions are accepted only in engineering mode");
        }
        this.getConfigurableSubsystem().change(this.name, parameterName, value);
    }

    public void submitChange(String parameterName, Object value) {
        if (!this.isInEngineeringMode()) {
            throw new IllegalStateException("Configuration actions are accepted only in engineering mode");
        }
        try {
            this.getConfigurableSubsystem().submitChange(this.name, parameterName, value);
        }
        catch (TypeConversionException ex) {
            throw new IllegalArgumentException(ex.getMessage(), ex);
        }
    }

    public void saveAllChanges() throws ConfigurationServiceException {
        if (!this.isInEngineeringMode()) {
            throw new IllegalStateException("Configuration actions are accepted only in engineering mode");
        }
        this.getConfigurableSubsystem().saveAllChanges();
    }

    public void saveChangesForCategories(String ... categories) throws ConfigurationServiceException {
        if (!this.isInEngineeringMode()) {
            throw new IllegalStateException("Configuration actions are accepted only in engineering mode");
        }
        this.getConfigurableSubsystem().saveChangesForCategories(categories);
    }

    public void saveChangesForCategoriesAs(String ... taggedCategories) throws ConfigurationServiceException {
        if (!this.isInEngineeringMode()) {
            throw new IllegalStateException("Configuration actions are accepted only in engineering mode");
        }
        this.getConfigurableSubsystem().saveChangesForCategoriesAs(taggedCategories);
    }

    public void dropAllChanges() throws Exception {
        if (!this.isInEngineeringMode()) {
            throw new IllegalStateException("Configuration actions are accepted only in engineering mode");
        }
        this.getConfigurableSubsystem().dropAllChanges();
    }

    public void dropChangesForCategories(String ... categories) throws Exception {
        if (!this.isInEngineeringMode()) {
            throw new IllegalStateException("Configuration actions are accepted only in engineering mode");
        }
        this.getConfigurableSubsystem().dropChangesForCategories(categories);
    }

    private boolean isInEngineeringMode() {
        return this.getSubsystem().get().isInEngineeringMode();
    }

    @Deprecated
    public ViewValue getCheckedValueFromConfiguration(String parameterName, Object value) throws Exception {
        if (!this.isParameterConfigurable(parameterName).booleanValue()) {
            throw new IllegalArgumentException("incoherent parameter name for " + parameterName + "-> " + this.getNameOfComponent());
        }
        return new ViewValue(parameterName, (Object)parameterName);
    }

    public Boolean isParameterConfigurable(String parameterName) {
        return this.configurationProxy.isParameterConfigurable(this.name, parameterName);
    }

    public void notifyChangeWithoutPreliminaryChecks(String parameterName, Object value) throws Exception {
        this.configurationProxy.notifyUncheckedParameterChange(this.name, parameterName, value);
    }

    public void notifyChange(String parameterName, String value) throws Exception {
        this.configurationProxy.notifyParameterChange(this.name, parameterName, value);
    }

    public Object getComponentByName(String name) {
        return this.lookupService.getComponentByName(name);
    }

    public <T> LinkedHashMap<String, T> getChildren(Class<T> classFilter) {
        Objects.requireNonNull(classFilter);
        return this.lookupService.getChildren(this.name, classFilter);
    }

    public Map.Entry<String, Object> getParent() {
        return this.lookupService.getParent(this.name);
    }

    public String getNameOfComponent() {
        return this.name;
    }

    public Optional<Subsystem> getSubsystem() {
        return Optional.of(this.subsystem);
    }

    private ConfigurableSubsystem getConfigurableSubsystem() {
        return (ConfigurableSubsystem)this.getSubsystem().get();
    }

    public void dropBulkChange() {
        this.getConfigurableSubsystem().dropSubmittedChangesForComponent(this.name);
    }

    public TreeBranch<String> getComponentTree() {
        ArrayList otree = new ArrayList(1);
        otree.add(null);
        this.lookupService.proceduralNodeWalk(this.name, node -> otree.add(0, new TreeBranch((TreeBranch)otree.remove(0), (Serializable)((Object)node.getName()))), node -> {
            TreeBranch parent = ((TreeBranch)otree.get(0)).getRealParent();
            if (parent != null) {
                otree.remove(0);
                otree.add(parent);
            }
        });
        return (TreeBranch)otree.get(0);
    }

    public void sendSignal(Signal signal) {
        this.lookupService.treeWalk(this.name, SignalHandler.class, sh -> sh.signal(signal), null);
    }

    public Map printConfigurableParameters(String[] categories) {
        return this.configurationProxy.getCurrentValuesForComponent(this.name, new HashSet<String>(Arrays.asList(categories)));
    }

    public Map<String, String> getSubmittedChanges() {
        return this.getConfigurableSubsystem().getSubmittedChangesForComponent(this.name);
    }
}

