/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application.studio;

import java.awt.Component;
import java.awt.Container;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import org.freehep.application.studio.Studio;

public abstract class Plugin {
    public static final Object GROUP_PROPERTY = new Object();
    public static final Object PLUGIN_PROPERTY = new Object();
    private Studio app;

    protected void init() throws Throwable {
    }

    protected void postInit() {
    }

    protected void applicationVisible() {
    }

    public boolean canBeShutDown() {
        return false;
    }

    protected void shutdown() {
    }

    void stop() {
        this.shutdown();
        this.app = null;
    }

    void setContext(Studio app) throws Throwable {
        this.app = app;
        this.init();
    }

    public Studio getApplication() {
        return this.app;
    }

    protected void addMenu(JMenuItem item, long location) {
        JMenuBar bar = this.app.getMenuBar();
        String loc = String.valueOf(location);
        Plugin.addMenu(bar, loc, item);
    }

    private static void addMenu(Container parent, String loc, JMenuItem item) {
        int l = loc.length() % 3;
        if (l == 0) {
            l = 3;
        }
        int ll = Integer.parseInt(loc.substring(0, l));
        Component[] c = parent instanceof JMenu ? ((JMenu)parent).getPopupMenu().getComponents() : parent.getComponents();
        for (int i = 0; i < c.length; ++i) {
            JComponent child;
            Object location;
            Component comp = c[i];
            if (!(comp instanceof JComponent) || !((location = (child = (JComponent)comp).getClientProperty("Location")) instanceof Integer)) continue;
            int locat = (Integer)location;
            if (locat == ll) {
                String remainder = loc.substring(l);
                if (remainder.length() > 0 && child instanceof Container) {
                    Plugin.addMenu((Container)comp, remainder, item);
                    return;
                }
                throw new RuntimeException("Invalid location for addMenu");
            }
            if (locat <= ll) continue;
            parent.add((Component)item, i);
            item.putClientProperty("Location", new Integer(ll));
            return;
        }
        parent.add(item);
        item.putClientProperty("Location", new Integer(ll));
    }

    public void addMenu(Action action, String plugin, String ... locations) {
        int i;
        if (locations.length == 0) {
            throw new IllegalArgumentException("At least top level menu should be specified.");
        }
        JMenuBar bar = this.app.getMenuBar();
        int pos = locations[0].indexOf(58);
        if (pos != -1) {
            String s = locations[0].substring(0, pos);
            try {
                i = Integer.parseInt(s);
                locations[0] = locations[0].substring(i + 1);
            }
            catch (IndexOutOfBoundsException | NumberFormatException x) {
                pos = -1;
            }
        }
        Location[] locs = new Location[locations.length];
        block11: for (i = 0; i < locs.length; ++i) {
            Location loc;
            String[] tokens = locations[i].split(":");
            locs[i] = loc = new Location();
            loc.name = tokens[0];
            switch (tokens.length) {
                case 1: {
                    loc.group = 0;
                    loc.position = 0;
                    continue block11;
                }
                case 2: {
                    loc.group = 0;
                    loc.position = Integer.parseInt(tokens[1]);
                    continue block11;
                }
                case 3: {
                    loc.group = Integer.parseInt(tokens[1]);
                    loc.position = Integer.parseInt(tokens[2]);
                    continue block11;
                }
                default: {
                    throw new IllegalArgumentException("Illegal location string: " + locations[i]);
                }
            }
        }
        JMenu menu = null;
        try {
            menu = (JMenu)Plugin.findMenu(bar, locs[0].name);
        }
        catch (ClassCastException tokens) {
            // empty catch block
        }
        if (menu == null) {
            menu = new JMenu(locs[0].name);
            if (pos == -1) {
                bar.add(menu);
            } else {
                menu.putClientProperty("Location", pos);
                Component[] cc = bar.getComponents();
                boolean notDone = true;
                for (int i2 = 0; i2 < cc.length; ++i2) {
                    try {
                        int itemPos;
                        JMenu item = (JMenu)cc[i2];
                        Object o = item.getClientProperty("Location");
                        int n = itemPos = o == null ? 0 : (Integer)o;
                        if (itemPos <= pos) continue;
                        bar.add((Component)menu, i2);
                        notDone = false;
                        break;
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                }
                if (notDone) {
                    bar.add(menu);
                }
            }
        }
        Plugin.addMenu(action, plugin, menu, locs, 1);
    }

    private static void addMenu(Action action, String plugin, JMenu parent, Location[] locations, int level) {
        boolean finalLevel = level == locations.length;
        String name = finalLevel ? action.toString() : locations[level].name;
        JMenuItem levelItem = Plugin.findMenu(parent, name);
        Location loc = locations[level - 1];
        if (levelItem == null) {
            if (finalLevel) {
                levelItem = new JMenuItem(action);
            } else {
                levelItem = new JMenu(name);
                Plugin.addMenu(action, plugin, (JMenu)levelItem, locations, level + 1);
            }
            levelItem.putClientProperty("Location", loc.position);
            levelItem.putClientProperty(GROUP_PROPERTY, loc.group);
            levelItem.putClientProperty(PLUGIN_PROPERTY, plugin);
            Plugin.positionMenu(parent, levelItem, plugin, loc.group, loc.position);
        } else {
            if (finalLevel) {
                throw new IllegalArgumentException("Duplicate menu item: " + name);
            }
            Plugin.addMenu(action, plugin, (JMenu)levelItem, locations, level + 1);
        }
    }

    private static JMenuItem findMenu(JComponent parent, String name) {
        Component[] components;
        for (Component e : components = parent instanceof JMenu ? ((JMenu)parent).getPopupMenu().getComponents() : parent.getComponents()) {
            try {
                JMenuItem menu = (JMenuItem)e;
                if (!name.equals(menu.getText())) continue;
                return menu;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return null;
    }

    private static void positionMenu(JMenu parent, JMenuItem child, String plugin, int group, int position) {
        int pos = 0;
        int gr = 0;
        String plug = null;
        int index = -1;
        Component[] components = parent.getMenuComponents();
        int n = components.length;
        for (int i = 0; i < n; ++i) {
            try {
                JMenuItem item = (JMenuItem)components[i];
                Object o = item.getClientProperty("Location");
                int itemPos = o == null ? 0 : (Integer)o;
                o = item.getClientProperty(GROUP_PROPERTY);
                int itemGroup = o == null ? 0 : (Integer)o;
                String itemPlug = (String)item.getClientProperty(PLUGIN_PROPERTY);
                if (Math.abs(itemGroup) > Math.abs(group) || itemGroup == group && (itemGroup <= 0 || plugin.equals(itemPlug)) && itemPos > position) {
                    if (index == -1) {
                        parent.insert(child, 0);
                        if (itemGroup == group) break;
                        parent.insertSeparator(1);
                        break;
                    }
                    if (itemGroup == group) {
                        parent.insert(child, i);
                        break;
                    }
                    if (gr == group) {
                        parent.insert(child, index + 1);
                        break;
                    }
                    parent.insert(child, i);
                    parent.insertSeparator(i + 1);
                    break;
                }
                pos = itemPos;
                gr = itemGroup;
                plug = itemPlug;
                index = i;
                continue;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (index == n - 1) {
            if (n == 0 || gr == group && (gr <= 0 || plugin.equals(plug))) {
                parent.add(child);
            } else {
                parent.addSeparator();
                parent.add(child);
            }
        }
    }

    private class Location {
        String name;
        int group;
        int position;

        private Location() {
        }
    }
}

