/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;

public class SplashScreen
extends JWindow {
    private JProgressBar progress;

    public SplashScreen(Icon coolPicture, String initialMessage, String title) {
        JPanel panelForBorder = new JPanel(new BorderLayout());
        panelForBorder.setBackground(Color.white);
        panelForBorder.setLayout(new BorderLayout());
        panelForBorder.add((Component)new JLabel(coolPicture), "Center");
        if (title != null) {
            panelForBorder.add((Component)new JLabel(title, 0), "North");
        }
        this.progress = new JProgressBar(0, 100);
        this.progress.setStringPainted(true);
        this.progress.setString(initialMessage);
        panelForBorder.add((Component)this.progress, "South");
        panelForBorder.setBorder(new BevelBorder(0));
        this.getContentPane().add(panelForBorder);
    }

    @Override
    public void setVisible(boolean show) {
        if (show) {
            this.pack();
            Dimension WindowSize = this.getSize();
            Dimension ScreenSize = Toolkit.getDefaultToolkit().getScreenSize();
            this.setBounds((ScreenSize.width - WindowSize.width) / 2, (ScreenSize.height - WindowSize.height) / 2, WindowSize.width, WindowSize.height);
        }
        super.setVisible(show);
    }

    public void showStatus(String message, int percent) {
        if (this.isVisible()) {
            SwingUtilities.invokeLater(new UpdateStatus(message, percent));
        }
    }

    public void close() {
        if (this.isVisible()) {
            SwingUtilities.invokeLater(new CloseSplashScreen());
        }
    }

    private class CloseSplashScreen
    implements Runnable {
        private CloseSplashScreen() {
        }

        @Override
        public void run() {
            SplashScreen.this.setVisible(false);
            SplashScreen.this.dispose();
        }
    }

    private class UpdateStatus
    implements Runnable {
        private String message;
        private int value;

        public UpdateStatus(String status, int pc) {
            this.message = status;
            this.value = pc;
        }

        @Override
        public void run() {
            SplashScreen.this.progress.setValue(this.value);
            SplashScreen.this.progress.setString(this.message);
        }
    }
}

