/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.console;

import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.messages.LogMessage;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.messaging.LogAggregator;
import org.lsst.ccs.messaging.LogMessageListener;
import org.lsst.ccs.messaging.StatusMessageListener;

public class LogTracer
extends Subsystem
implements LogMessageListener {
    private static final StatusMessageListener statusListener = new StatusMessageListener(){

        public void onStatusMessage(StatusMessage s) {
            System.out.println(s);
        }
    };

    public static void main(String[] args) {
        LogTracer t = new LogTracer();
        if (args.length > 0) {
            t.getMessagingAccess().addStatusMessageListener(statusListener);
        }
        t.start();
    }

    public LogTracer() {
        super("logtracer", AgentInfo.AgentType.LISTENER);
        LogAggregator la = new LogAggregator();
        this.getMessagingAccess().addLogMessageListener((LogMessageListener)la);
        la.stream().forEach(m -> System.out.printf("%-15s : %s", m.getOriginAgentInfo().getName(), m.getFormattedDetails()));
    }

    public void onLogMessage(LogMessage logEvent) {
        System.out.println("Log from " + logEvent.getOriginAgentInfo().getName() + ":" + logEvent);
    }
}

