/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.trending;

import hep.aida.IAnnotation;
import hep.aida.IDataPoint;
import hep.aida.IDataPointSet;
import java.util.EnumSet;
import org.freehep.jas.services.PlotPage;
import org.freehep.jas.services.PlotRegion;
import org.lsst.ccs.gconsole.plugins.trending.AuxData;
import org.lsst.ccs.gconsole.plugins.trending.DataChannelHandler;
import org.lsst.ccs.gconsole.plugins.trending.PlotData;
import org.lsst.ccs.gconsole.plugins.trending.timeselection.TimeWindow;

public final class Plot
implements IDataPointSet {
    private PlotData data;
    private double low = -1.0;
    private double high = -1.0;
    private final TimeWindow timeWindow;
    private final DataChannelHandler channel;
    private PlotPage page;
    private PlotRegion region;
    private volatile PlotData spareData;
    private double spareLow = -1.0;
    private double spareHigh = -1.0;
    private volatile long timestamp;
    private EnumSet<AuxData.Type> isVisible = EnumSet.noneOf(AuxData.Type.class);

    public Plot(PlotData data, TimeWindow timeWindow, DataChannelHandler channel) {
        this(data, timeWindow, channel, null, null);
    }

    public Plot(PlotData data, TimeWindow timeWindow, DataChannelHandler channel, PlotPage page, PlotRegion region) {
        this.data = data;
        this.timeWindow = timeWindow;
        this.channel = channel;
        this.page = page;
        this.region = region;
        this.timestamp = System.currentTimeMillis();
    }

    public long getTimeStamp() {
        return this.timestamp;
    }

    public TimeWindow getTimeWindow() {
        return this.timeWindow;
    }

    public DataChannelHandler getChannel() {
        return this.channel;
    }

    public PlotPage getPage() {
        return this.page;
    }

    public void setPage(PlotPage page) {
        this.page = page;
    }

    public PlotRegion getRegion() {
        return this.region;
    }

    public void setRegion(PlotRegion region) {
        this.region = region;
    }

    public void setTimeRange(long begin, long end) {
        this.low = begin;
        this.high = end;
    }

    public double getGranularity() {
        int n = this.size();
        if (n < 2) {
            return (this.upperExtent(0) - this.lowerExtent(0)) / 100.0;
        }
        return (this.upperExtent(0) - this.lowerExtent(0)) / (double)n;
    }

    public boolean isVisible(AuxData.Type what) {
        return this.isVisible.contains((Object)what);
    }

    public void setVisible(AuxData.Type what, boolean visible) {
        if (visible) {
            this.isVisible.add(what);
        } else {
            this.isVisible.remove((Object)what);
        }
    }

    public void setVisible(Plot other) {
        this.isVisible = other.isVisible.clone();
    }

    public PlotData getData() {
        return this.data;
    }

    public boolean isRefreshReady() {
        return this.spareData != null;
    }

    public synchronized boolean commitRefresh() {
        if (this.spareData == null || this.data == this.spareData) {
            return false;
        }
        this.data = this.spareData;
        this.low = this.spareLow;
        this.high = this.spareHigh;
        this.spareData = null;
        this.spareLow = -1.0;
        this.spareHigh = -1.0;
        return true;
    }

    public void refresh(PlotData data) {
        this.refresh(data, -1L, -1L);
    }

    public synchronized void refresh(PlotData data, long begin, long end) {
        this.spareData = data;
        this.spareLow = begin;
        this.spareHigh = end;
        this.timestamp = System.currentTimeMillis();
    }

    public boolean refresh() {
        return this.channel.refresh(this);
    }

    public IAnnotation annotation() {
        return this.data.get().annotation();
    }

    public String title() {
        return this.channel.getPath();
    }

    public void setTitle(String string) throws IllegalArgumentException {
        this.data.get().setTitle(string);
    }

    public int dimension() {
        return this.data.get().dimension();
    }

    public void clear() {
        this.data.get().clear();
    }

    public int size() {
        return this.data.get().size();
    }

    public IDataPoint point(int i) {
        return this.data.get().point(i);
    }

    public void setCoordinate(int i, double[] doubles, double[] doubles1) throws IllegalArgumentException {
        this.data.get().setCoordinate(i, doubles, doubles1);
    }

    public void setCoordinate(int i, double[] doubles, double[] doubles1, double[] doubles2) throws IllegalArgumentException {
        this.data.get().setCoordinate(i, doubles, doubles1, doubles2);
    }

    public IDataPoint addPoint() throws RuntimeException {
        return this.data.get().addPoint();
    }

    public void addPoint(IDataPoint idp) throws IllegalArgumentException {
        this.data.get().addPoint(idp);
    }

    public void removePoint(int i) throws IllegalArgumentException {
        this.data.get().removePoint(i);
    }

    public double lowerExtent(int i) throws IllegalArgumentException {
        return i == 0 && this.low > 0.0 ? this.low : this.data.get().lowerExtent(i);
    }

    public double upperExtent(int i) throws IllegalArgumentException {
        return i == 0 && this.high > 0.0 ? this.high : this.data.get().upperExtent(i);
    }

    public void scale(double d) throws IllegalArgumentException {
        this.data.get().scale(d);
    }

    public void scaleValues(double d) throws IllegalArgumentException {
        this.data.get().scaleValues(d);
    }

    public void scaleErrors(double d) throws IllegalArgumentException {
        this.data.get().scaleErrors(d);
    }
}

