/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.tracer;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.bus.messages.CommandAck;
import org.lsst.ccs.bus.messages.CommandNack;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.CommandResult;
import org.lsst.ccs.bus.messages.LogMessage;
import org.lsst.ccs.bus.messages.StatusHeartBeat;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.gconsole.plugins.tracer.FilteredMessage;
import org.lsst.ccs.gconsole.plugins.tracer.MessageFilter;

class StandardFormatter
implements MessageFilter {
    private final SimpleDateFormat dtFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    StandardFormatter() {
    }

    @Override
    public String getDescription() {
        return "<html>Accepts all messages.<p>Formats output as<br>[Date Time] [Origin]: [Message]<br>The message depends on the type of the bus message.";
    }

    @Override
    public String getName() {
        return "Format/Standard";
    }

    @Override
    public FilteredMessage test(FilteredMessage filteredMessage) {
        BusMessage bm = filteredMessage.getBusMessage();
        if (filteredMessage.getMessage() != null) {
            return filteredMessage;
        }
        if (bm instanceof LogMessage) {
            LogMessage lm = (LogMessage)bm;
            filteredMessage.setMessage(lm.getFormattedDetails());
            return filteredMessage;
        }
        Date date = new Date(bm.getTimeStamp());
        StringBuilder sb = new StringBuilder(this.dtFormat.format(date));
        sb.append(" ").append(bm.getOriginAgentInfo().getName()).append(": ");
        if (bm instanceof StatusHeartBeat) {
            StatusHeartBeat sm = (StatusHeartBeat)bm;
            sb.append(" Heart Beat.").append(" State: ").append(sm.getState());
        } else if (bm instanceof StatusMessage) {
            StatusMessage sm = (StatusMessage)bm;
            sb.append(sm.getClassName()).append(" State: ").append(sm.getState());
        } else if (bm instanceof CommandRequest) {
            CommandRequest cr = (CommandRequest)bm;
            sb.append("Command ").append(cr.getBasicCommand().getCommand()).append(" to ").append(cr.getDestination()).append(".");
        } else if (bm instanceof CommandNack) {
            CommandNack cn = (CommandNack)bm;
            sb.append("Command not accepted. Reason: ").append(cn.getReason());
        } else if (bm instanceof CommandAck) {
            sb.append("Command not accepted.");
        } else if (bm instanceof CommandResult) {
            CommandResult cr = (CommandResult)bm;
            if (cr.wasSuccessful()) {
                sb.append("Command executed.");
            } else {
                sb.append("Command failed.");
            }
        } else {
            sb.append(bm);
        }
        filteredMessage.setMessage(sb.toString());
        return filteredMessage;
    }
}

