/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.tracer;

import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.freehep.util.FreeHEPLookup;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.gconsole.plugins.tracer.AlertSelector;
import org.lsst.ccs.gconsole.plugins.tracer.CommandBusSelector;
import org.lsst.ccs.gconsole.plugins.tracer.FilteredMessage;
import org.lsst.ccs.gconsole.plugins.tracer.HeartBeatSelector;
import org.lsst.ccs.gconsole.plugins.tracer.LogBusSelector;
import org.lsst.ccs.gconsole.plugins.tracer.LsstTracerPlugin;
import org.lsst.ccs.gconsole.plugins.tracer.MessageFilter;
import org.lsst.ccs.gconsole.plugins.tracer.MessageFilterAdapter;
import org.lsst.ccs.gconsole.plugins.tracer.MessageFilterFactory;
import org.lsst.ccs.gconsole.plugins.tracer.StandardFormatter;
import org.lsst.ccs.gconsole.plugins.tracer.StatusBusSelector;
import org.lsst.ccs.gconsole.plugins.tracer.TracerFilter;
import org.lsst.ccs.gconsole.plugins.tracer.UserFilter;
import org.lsst.ccs.messaging.BusMessageFilter;
import org.openide.util.Lookup;
import org.openide.util.LookupListener;

public class FilterRegistry {
    static final String BUILTIN = "BuiltIn/";
    static final String LOCAL = "Local/";
    static final String USER = "User/";
    private final LsstTracerPlugin plugin;
    private final Map<String, MessageFilterFactory> filters = new ConcurrentHashMap<String, MessageFilterFactory>(4, 0.75f, 1);
    private Lookup.Result result1;
    private Lookup.Result result2;

    FilterRegistry(LsstTracerPlugin plugin) {
        this.plugin = plugin;
    }

    void init() {
        this.addFactory(new StandardFormatter(), BUILTIN);
        this.addFactory(new HeartBeatSelector(false), BUILTIN);
        this.addFactory(new CommandBusSelector(), BUILTIN);
        this.addFactory(new LogBusSelector(), BUILTIN);
        this.addFactory(new StatusBusSelector(), BUILTIN);
        this.addFactory(new AlertSelector(), BUILTIN);
        FreeHEPLookup lookup = this.plugin.getConsole().getLookup();
        LookupListener listener = e -> this.updateLocalFilters();
        Lookup.Template template = new Lookup.Template(MessageFilterFactory.class);
        this.result1 = lookup.lookup(template);
        this.result1.addLookupListener(listener);
        template = new Lookup.Template(BusMessageFilter.class);
        this.result2 = lookup.lookup(template);
        this.result2.addLookupListener(listener);
        this.updateLocalFilters();
        this.addUserFilters(this.getUserFiltersFile());
    }

    public MessageFilter getFilter(String name) {
        MessageFilterFactory factory = this.filters.get(name);
        if (factory == null) {
            throw new IllegalArgumentException("Unrecognized filter: " + name);
        }
        try {
            MessageFilter filter = factory.get();
            if (filter == null) {
                throw new IllegalArgumentException("Unable to retrieve filter: " + name);
            }
            return filter;
        }
        catch (Exception x) {
            throw new IllegalArgumentException("Unable to retrieve filter: " + name, x);
        }
    }

    public void saveFilter(UserFilter filter) throws IOException {
        try {
            Element filtersElement;
            Element filterElement;
            Document document;
            File inputFile = this.getUserFiltersFile();
            SAXReader reader = new SAXReader();
            try {
                document = reader.read(inputFile);
            }
            catch (DocumentException x) {
                document = DocumentHelper.createDocument();
                document.addElement("filters");
            }
            String name = filter.getName();
            if (name.startsWith(USER)) {
                name = name.substring(USER.length(), name.length());
            }
            if ((filterElement = (Element)(filtersElement = (Element)document.selectSingleNode("/filters")).selectSingleNode("filter[@name='" + name + "']")) != null) {
                filtersElement.remove(filterElement);
            }
            filterElement = filtersElement.addElement("filter");
            filterElement.addAttribute("name", name);
            String description = filter.getDescription();
            if (description != null) {
                filterElement.addElement("description").addText(description);
            }
            Element stepsElement = filterElement.addElement("steps");
            int nSteps = filter.filters.length;
            for (int step = 0; step < nSteps; ++step) {
                FilteredMessage.Flag action;
                TracerFilter tf = filter.filters[step];
                Element stepElement = stepsElement.addElement("step");
                if (filter.or[step]) {
                    stepElement.addElement("or");
                }
                stepElement.addElement("mode").addText(tf.getMode().name());
                if (tf.isInverted()) {
                    stepElement.addElement("invert");
                }
                if (tf.isFormatting()) {
                    stepElement.addElement("format");
                }
                stepElement.addElement("target").addText(tf.getTarget().name());
                stepElement.addElement("method").addText(tf.getMethod().name());
                stepElement.addElement("code").addText(tf.getCode());
                Color color = tf.getColor();
                if (color != null) {
                    stepElement.addElement("color").addText(FilterRegistry.encode(color));
                }
                if ((action = tf.getAction()) == null) continue;
                stepElement.addElement("action").addText(action.name());
            }
            OutputFormat format = OutputFormat.createPrettyPrint();
            if (!inputFile.exists()) {
                inputFile.getParentFile().mkdirs();
            }
            XMLWriter writer = new XMLWriter((OutputStream)new FileOutputStream(inputFile), format);
            writer.write(document);
            this.addFactory(new UserFilterFactory(name, description), null);
        }
        catch (IOException | ClassCastException | IllegalArgumentException | IndexOutOfBoundsException | NullPointerException x) {
            throw new IOException("Unable to save filter " + filter.getName(), x);
        }
    }

    public void deleteFilter(String name) throws IOException {
        if (!name.startsWith(USER)) {
            return;
        }
        this.filters.remove(name);
        name = name.substring(USER.length(), name.length());
        try {
            File inputFile = this.getUserFiltersFile();
            SAXReader reader = new SAXReader();
            Document document = reader.read(inputFile);
            Element filtersElement = (Element)document.selectSingleNode("/filters");
            Element filterElement = (Element)filtersElement.selectSingleNode("filter[@name='" + name + "']");
            if (filterElement != null) {
                filtersElement.remove(filterElement);
                OutputFormat format = OutputFormat.createPrettyPrint();
                XMLWriter writer = new XMLWriter((OutputStream)new FileOutputStream(inputFile), format);
                writer.write(document);
            }
        }
        catch (IOException | ClassCastException | IllegalArgumentException | NullPointerException | DocumentException x) {
            throw new IOException("Unable to delete filter User/" + name, x);
        }
    }

    public Map<String, String> availableFilters() {
        TreeMap<String, String> out = new TreeMap<String, String>();
        this.filters.forEach((name, factory) -> out.put((String)name, factory.getDescription()));
        return out;
    }

    void addFactory(MessageFilterFactory factory, String category) {
        if (category != null) {
            factory = new CategorizedFilter(factory, category);
        }
        this.filters.put(factory.getName(), factory);
    }

    private UserFilter openFilter(String shortName) {
        try {
            File inputFile = this.getUserFiltersFile();
            SAXReader reader = new SAXReader();
            Document document = reader.read(inputFile);
            Node filterNode = document.selectSingleNode("/filters/filter[@name='" + shortName + "']");
            List stepNodes = filterNode.selectNodes("steps/step");
            int nSteps = stepNodes.size();
            TracerFilter[] steps = new TracerFilter[nSteps];
            boolean[] ors = new boolean[nSteps];
            for (int step = 0; step < nSteps; ++step) {
                Node stepNode = (Node)stepNodes.get(step);
                ors[step] = stepNode.selectSingleNode("or") != null;
                String s = stepNode.selectSingleNode("mode").getText().trim();
                TracerFilter.Mode mode = TracerFilter.Mode.valueOf(s);
                boolean invert = stepNode.selectSingleNode("invert") != null;
                boolean format = stepNode.selectSingleNode("format") != null;
                s = stepNode.selectSingleNode("target").getText().trim();
                TracerFilter.Target target = TracerFilter.Target.valueOf(s);
                s = stepNode.selectSingleNode("method").getText().trim();
                TracerFilter.Method method = TracerFilter.Method.valueOf(s);
                String code = stepNode.selectSingleNode("code").getText();
                Node node = stepNode.selectSingleNode("color");
                Color color = null;
                if (node != null && !(s = node.getText().trim()).isEmpty()) {
                    color = Color.decode("#" + s);
                }
                node = stepNode.selectSingleNode("action");
                FilteredMessage.Flag action = null;
                if (node != null && !(s = node.getText().trim()).isEmpty()) {
                    action = FilteredMessage.Flag.valueOf(s);
                }
                steps[step] = new TracerFilter(mode, invert, format, target, method, code, color, action, this);
            }
            return new UserFilter(USER + shortName, steps, ors);
        }
        catch (ClassCastException | IllegalArgumentException | IndexOutOfBoundsException | NullPointerException | DocumentException x) {
            throw new IllegalArgumentException("Unable to read filter " + shortName + " from storage", x);
        }
    }

    private void updateLocalFilters() {
        this.filters.entrySet().removeIf(e -> ((String)e.getKey()).startsWith(LOCAL));
        Collection c = this.result1.allInstances();
        c.forEach(o -> this.addFactory((MessageFilterFactory)o, LOCAL));
        c = this.result2.allItems();
        c.forEach(o -> {
            Lookup.Item item = (Lookup.Item)o;
            BusMessageFilter bmf = (BusMessageFilter)item.getInstance();
            this.addFactory(new MessageFilterAdapter(LOCAL + item.getId(), item.getDisplayName(), (Predicate<BusMessage>)bmf), null);
        });
    }

    private File getUserFiltersFile() {
        String consoleHome = this.plugin.getConsole().getProperty("lsst.console.home").toString();
        if (consoleHome == null) {
            return null;
        }
        return new File(consoleHome + "/tracer/filters.xml");
    }

    private void addUserFilters(File file) {
        if (file == null) {
            return;
        }
        try {
            SAXReader reader = new SAXReader();
            Document document = reader.read(file);
            List nodes = document.selectNodes("/filters/filter");
            nodes.forEach(node -> {
                String name = node.valueOf("@name");
                Node descNode = node.selectSingleNode("description");
                String description = descNode == null ? null : descNode.getText().trim();
                this.addFactory(new UserFilterFactory(name, description), null);
            });
        }
        catch (NullPointerException | DocumentException throwable) {
            // empty catch block
        }
    }

    static final String encode(Color color) {
        return String.format("%06x", color.getRGB() & 0xFFFFFF);
    }

    private class CategorizedFilter
    implements MessageFilter {
        private final MessageFilterFactory delegate;
        private final String prefix;

        private CategorizedFilter(MessageFilterFactory factory, String category) {
            this.delegate = factory;
            this.prefix = category;
        }

        @Override
        public String getName() {
            return this.prefix + this.delegate.getName();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public MessageFilter get() {
            return new CategorizedFilter(this.delegate.get(), this.prefix);
        }

        @Override
        public FilteredMessage test(FilteredMessage filteredMessage) {
            return ((MessageFilter)this.delegate).test(filteredMessage);
        }
    }

    private class UserFilterFactory
    implements MessageFilterFactory {
        private final String name;
        private final String desc;

        private UserFilterFactory(String shortName, String description) {
            this.name = shortName;
            this.desc = description;
        }

        @Override
        public String getName() {
            return FilterRegistry.USER + this.name;
        }

        @Override
        public String getDescription() {
            return this.desc;
        }

        @Override
        public MessageFilter get() {
            return FilterRegistry.this.openFilter(this.name);
        }
    }
}

