/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.demo;

import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.AbstractAction;
import org.lsst.ccs.gconsole.ConsolePlugin;

public class PreferencesMenusPlugin
extends ConsolePlugin {
    @Override
    public void initialize() {
        this.getServices().addProperty("oldEnough", true);
        this.getServices().addPreference(new String[]{"LSST", "Demo", "Pref"}, null, "${oldEnough} I am at least 21 years old.");
        this.getServices().addProperty("rangeMin", 13.5);
        this.getServices().addProperty("rangeMax", 100.0);
        this.getServices().addProperty("currency", (Object)Currency.USD);
        this.getServices().addPreference(new String[]{"LSST", "Demo", "Pref"}, "Price range", "Min: ${rangeMin}  Max: ${rangeMax}");
        this.getServices().addProperty("quantity", 3);
        this.getServices().addPreference(new String[]{"LSST", "Demo", "Pref"}, null, "Quantity: ${quantity}");
        this.getServices().addProperty("name", "Jessica");
        this.getServices().addProperty("ms", 78);
        this.getServices().addProperty("home", "SLAC National Accelerator Laboratory");
        this.getServices().addPreference(new String[]{"LSST", "Demo", "Pref"}, "Addressee", "Name: ${name}  M/S: ${ms}");
        this.getServices().addPreference(new String[]{"LSST", "Demo", "Pref"}, "Addressee", "Home institution: ${home}");
        this.getServices().addPreference(new String[]{"LSST", "Demo", "Pref"}, "Price range", "Currency: ${currency}");
        AbstractAction act = new AbstractAction("Currency"){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("\nCurrency: " + PreferencesMenusPlugin.this.getServices().getProperty("currency"));
            }
        };
        this.getServices().addMenu(act, "Demo", "Preferences:1:2");
        act = new AbstractAction("Range"){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("\nMin: " + PreferencesMenusPlugin.this.getServices().getProperty("rangeMin") + "  Max: " + PreferencesMenusPlugin.this.getServices().getProperty("rangeMax"));
            }
        };
        this.getServices().addMenu(act, "Demo", "Preferences:1:1");
        act = new AbstractAction("Quantity"){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("\nQuantity: " + PreferencesMenusPlugin.this.getServices().getProperty("quantity"));
            }
        };
        this.getServices().addMenu(act, "Demo", "Preferences:1");
        act = new AbstractAction("Legal Age"){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("\nOld enough: " + PreferencesMenusPlugin.this.getServices().getProperty("oldEnough"));
            }
        };
        this.getServices().addMenu(act, "Demo", "Preferences");
        act = new AbstractAction("Name"){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("\nName: " + PreferencesMenusPlugin.this.getServices().getProperty("name"));
            }
        };
        this.getServices().addMenu(act, "Demo", "Preferences:2:2", "Addressee");
        act = new AbstractAction("Address"){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("\nAddress: M/S " + PreferencesMenusPlugin.this.getServices().getProperty("ms") + " at " + PreferencesMenusPlugin.this.getServices().getProperty("home"));
            }
        };
        this.getServices().addMenu(act, "Demo", "Preferences:2:1", "Addressee");
        act = new AbstractAction("Reset preferences"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencesMenusPlugin.this.getServices().setProperty("oldEnough", null);
                PreferencesMenusPlugin.this.getServices().setProperty("rangeMin", null);
                PreferencesMenusPlugin.this.getServices().setProperty("rangeMax", null);
                PreferencesMenusPlugin.this.getServices().setProperty("currency", null);
                PreferencesMenusPlugin.this.getServices().setProperty("quantity", null);
                PreferencesMenusPlugin.this.getServices().setProperty("name", null);
                PreferencesMenusPlugin.this.getServices().setProperty("ms", null);
                PreferencesMenusPlugin.this.getServices().setProperty("home", null);
            }
        };
        this.getServices().addMenu(act, "Demo");
    }

    @Override
    public void propertiesChanged(Object source, Map<String, Object> changes) {
        System.out.println("\nProperties changed:");
        changes.forEach((key, value) -> System.out.println(key + " = " + value));
    }

    public static enum Currency {
        USD("US Dollar"),
        EUR("Euro"),
        RUB("Rouble"),
        CLP("Peso");

        private final String hr;

        private Currency(String humanReadableName) {
            this.hr = humanReadableName;
        }

        public String toString() {
            return this.hr;
        }
    }
}

