/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.alert;

import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.bus.messages.CommandAck;
import org.lsst.ccs.bus.messages.CommandNack;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.CommandResult;
import org.lsst.ccs.bus.messages.StatusClearedAlert;
import org.lsst.ccs.bus.messages.StatusRaisedAlert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.gconsole.ConsolePlugin;
import org.lsst.ccs.gconsole.Plugin;
import org.lsst.ccs.gconsole.plugins.alert.AlertHandler;
import org.lsst.ccs.gconsole.plugins.alert.AlertViewer;
import org.lsst.ccs.gconsole.plugins.tracer.LsstTracerPlugin;
import org.lsst.ccs.gconsole.plugins.tracer.Tracer;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.CommandOriginator;

@Plugin(name="LSST Alert Notification Plugin", description="LSST CCS alert notification service.")
public class LsstAlertPlugin
extends ConsolePlugin {
    private static final String OPT_AUTO_START_VIEWER = "autoStartViewer";
    private static final String OPT_AUTO_START_TRACER = "autoStartTracer";
    private static final String OPT_SHOW_TESTER = "showTester";
    static final String OPT_HISTORY = "history";
    static final String OPT_MUTE = "mute";
    static final String OPT_TOFRONT = "toFront";
    private AlertHandler alertHandler;
    private AlertViewer viewer;
    private Action viewerAction;
    private JFrame emitter;

    @Override
    public synchronized void initialize() {
        this.getServices().addProperty(OPT_AUTO_START_VIEWER, false);
        this.getServices().addPreference(new String[]{"LSST", "Alerts"}, "Startup", "${autoStartViewer} Start viewer on console sturtup.");
        this.getServices().addProperty(OPT_AUTO_START_TRACER, false);
        this.getServices().addPreference(new String[]{"LSST", "Alerts"}, "Startup", "${autoStartTracer} Start tracer on console sturtup.");
        this.getServices().addProperty(OPT_SHOW_TESTER, false);
        this.getServices().addPreference(new String[]{"LSST", "Alerts"}, null, "${showTester} Show tester controls.");
        this.getServices().addProperty(OPT_HISTORY, false);
        this.getServices().addProperty(OPT_MUTE, false);
        this.getServices().addProperty(OPT_TOFRONT, true);
        this.viewerAction = new AbstractAction("Viewer"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LsstAlertPlugin.this.onNewAlertViewer();
            }
        };
        this.getServices().addMenu(this.viewerAction, "File", "New:-1:2", "LSST Alerts:1");
        AbstractAction act = new AbstractAction("Tracer"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LsstAlertPlugin.this.onNewAlertTracer();
            }
        };
        this.getServices().addMenu(act, "File", "New", "LSST Alerts:2");
        if (((Boolean)this.getServices().getProperty(OPT_SHOW_TESTER)).booleanValue()) {
            act = new AbstractAction("Tester"){

                @Override
                public void actionPerformed(ActionEvent ee) {
                    this.setEnabled(false);
                    SwingUtilities.invokeLater(() -> {
                        Box treeButtonsPanel = Box.createHorizontalBox();
                        JButton emitAlert = new JButton("Bus Alarm");
                        emitAlert.addActionListener(e -> {
                            AlertState level;
                            String command = JOptionPane.showInputDialog(LsstAlertPlugin.this.getConsole().getWindow(), "Enter ID:A|W|N:description", "ID:A:description");
                            String[] tokens = command.split(":");
                            AlertState alertState = tokens[1].equalsIgnoreCase("A") ? AlertState.ALARM : (level = tokens[1].equalsIgnoreCase("W") ? AlertState.WARNING : AlertState.NOMINAL);
                            if (level == AlertState.NOMINAL) {
                                if (tokens[0].isEmpty()) {
                                    LsstAlertPlugin.this.getConsole().clearAllAlerts();
                                } else {
                                    LsstAlertPlugin.this.getConsole().clearAlerts(new String[]{tokens[0]});
                                }
                            } else {
                                LsstAlertPlugin.this.getConsole().raiseAlert(new Alert(tokens[0], tokens[2]), level);
                            }
                        });
                        treeButtonsPanel.add(emitAlert);
                        emitAlert = new JButton("Local Alarm");
                        emitAlert.addActionListener(e -> {
                            String command = JOptionPane.showInputDialog(LsstAlertPlugin.this.emitter, "Enter Source:ID:A|W|N:description", "Source:ID:W:description");
                            String[] tokens = command.split(":");
                            AlertState level = tokens[2].equalsIgnoreCase("A") ? AlertState.ALARM : (tokens[2].equalsIgnoreCase("W") ? AlertState.WARNING : AlertState.NOMINAL);
                            LsstAlertPlugin.this.alertHandler.submitAlert(tokens[0], new Alert(tokens[1], tokens[3]), level);
                        });
                        treeButtonsPanel.add(emitAlert);
                        LsstAlertPlugin.this.emitter = new JFrame("Alert emitter");
                        LsstAlertPlugin.this.emitter.add(treeButtonsPanel);
                        LsstAlertPlugin.this.emitter.pack();
                        LsstAlertPlugin.this.emitter.setVisible(true);
                    });
                }
            };
            this.getServices().addMenu(act, "File", "New", "LSST Alerts:1:1");
        }
        this.alertHandler = new AlertHandler(this);
        this.getConsole().getLookup().add(this.alertHandler);
    }

    @Override
    public synchronized void start() {
        if (((Boolean)this.getServices().getProperty(OPT_AUTO_START_VIEWER)).booleanValue()) {
            this.onNewAlertViewer();
        }
        if (((Boolean)this.getServices().getProperty(OPT_AUTO_START_TRACER)).booleanValue()) {
            this.onNewAlertTracer();
        }
    }

    @Override
    public synchronized void shutdown() {
        if (this.alertHandler != null) {
            this.getConsole().getLookup().remove(this.alertHandler);
            this.alertHandler = null;
        }
    }

    public void onNewAlertViewer() {
        if (this.viewer == null) {
            this.viewer = new AlertViewer(this);
            this.alertHandler.addListener(this.viewer);
            this.viewerAction.setEnabled(false);
        }
    }

    public void stopAlertViewer() {
        this.alertHandler.removeListener(this.viewer);
        this.viewer = null;
        this.viewerAction.setEnabled(true);
    }

    public void onNewAlertTracer() {
        LsstTracerPlugin tracerPlugin = (LsstTracerPlugin)this.getConsole().getLookup().lookup(LsstTracerPlugin.class);
        Tracer tracer = tracerPlugin.createTracer("Alerts", "BuiltIn/Alerts");
        tracer.setFilter(filteredMessage -> {
            BusMessage bm = filteredMessage.getBusMessage();
            if (bm instanceof StatusRaisedAlert) {
                StatusRaisedAlert am = (StatusRaisedAlert)bm;
                Alert alert = am.getRaisedAlert();
                String id = alert.getAlertId();
                StringBuilder sb = new StringBuilder();
                sb.append(AlertViewer.formatTimeStamp(am.getTimeStamp())).append(" : ");
                sb.append(am.getRaisedAlertSummary().getRaisedAlert(id).getLatestAlertState());
                sb.append(" from ").append(am.getOriginAgentInfo().getName()).append(".\n");
                sb.append("ID: ").append(id).append(".  Description:\n");
                sb.append(alert.getDescription()).append("\n");
                filteredMessage.setMessage(sb.toString());
                return filteredMessage;
            }
            if (bm instanceof StatusClearedAlert) {
                StatusClearedAlert am = (StatusClearedAlert)bm;
                StringBuilder sb = new StringBuilder();
                sb.append(AlertViewer.formatTimeStamp(am.getTimeStamp())).append(" : ");
                sb.append(am.getOriginAgentInfo().getName()).append(" cleared alerts ");
                for (String id : am.getClearAlertIds()) {
                    sb.append(id).append(", ");
                }
                sb.delete(sb.length() - 2, sb.length()).append(".\n");
                filteredMessage.setMessage(sb.toString());
                return filteredMessage;
            }
            return null;
        });
    }

    public void clearAlarms(Map<String, String[]> alarms) {
        AgentMessagingLayer messenger = this.getConsole().getMessagingAccess();
        CommandOriginator originator = new CommandOriginator(){

            public void processAck(CommandAck ack) {
            }

            public void processResult(CommandResult result) {
            }

            public void processNack(CommandNack nack) {
            }
        };
        alarms.forEach((source, ids) -> {
            CommandRequest request = ids == null ? new CommandRequest(source, "clearAllAlerts") : new CommandRequest(source, "clearAlerts", new Object[]{ids});
            messenger.sendCommandRequest(request, originator);
        });
    }
}

