/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.alert;

import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.lsst.ccs.RaisedAlertBookkeeper;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.RaisedAlertSummary;
import org.lsst.ccs.bus.messages.CommandAck;
import org.lsst.ccs.bus.messages.CommandNack;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.CommandResult;
import org.lsst.ccs.bus.messages.StatusAlert;
import org.lsst.ccs.bus.messages.StatusClearedAlert;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusRaisedAlert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.gconsole.plugins.alert.AlertEvent;
import org.lsst.ccs.gconsole.plugins.alert.AlertListener;
import org.lsst.ccs.gconsole.plugins.alert.AlertService;
import org.lsst.ccs.gconsole.plugins.alert.LsstAlertPlugin;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.CommandOriginator;
import org.lsst.ccs.messaging.StatusMessageListener;

public class AlertHandler
implements AlertService,
StatusMessageListener,
CommandOriginator {
    private final LsstAlertPlugin plugin;
    private final CopyOnWriteArrayList<AlertListener> listeners = new CopyOnWriteArrayList();
    private final HashMap<String, Instant> source2time = new HashMap();
    private final ConcurrentHashMap<String, RaisedAlertSummary> source2summary = new ConcurrentHashMap();

    public AlertHandler(LsstAlertPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public synchronized void submitAlert(String source, Alert alert, AlertState level) {
        RaisedAlertSummary oldSummary = this.source2summary.get(source = source == null || source.isEmpty() ? "Local" : "Local : " + source);
        if (oldSummary == null) {
            if (level == AlertState.NOMINAL) {
                return;
            }
            oldSummary = new RaisedAlertBookkeeper();
            this.source2summary.put(source, oldSummary);
        }
        String id = alert.getAlertId();
        try {
            RaisedAlertBookkeeper keeper = (RaisedAlertBookkeeper)oldSummary;
            if (level == AlertState.NOMINAL) {
                keeper.clearAlert(id);
                String[] ids = new String[]{id};
                this.fireAlertEvent(new AlertEvent(source, ids, (RaisedAlertSummary)keeper));
            } else {
                keeper.raiseAlert(alert, level, System.currentTimeMillis());
                this.fireAlertEvent(new AlertEvent(source, alert, (RaisedAlertSummary)keeper));
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStatusMessage(StatusMessage msg) {
        if (msg instanceof StatusAlert) {
            String source = msg.getOriginAgentInfo().getName();
            StatusAlert message = (StatusAlert)msg;
            Instant timeStamp = this.getTimeStamp(message);
            AlertHandler alertHandler = this;
            synchronized (alertHandler) {
                Instant latest = this.source2time.merge(source, timeStamp, (s, t) -> timeStamp.isAfter((Instant)t) ? timeStamp : t);
                if (latest.equals(timeStamp)) {
                    RaisedAlertSummary summary = message.getRaisedAlertSummary();
                    this.source2summary.put(source, summary);
                    if (message instanceof StatusRaisedAlert) {
                        Alert alert = ((StatusRaisedAlert)message).getRaisedAlert();
                        this.fireAlertEvent(new AlertEvent(source, alert, summary));
                    } else if (message instanceof StatusClearedAlert) {
                        String[] ids = ((StatusClearedAlert)message).getClearAlertIds();
                        this.fireAlertEvent(new AlertEvent(source, ids, summary));
                    }
                }
            }
        }
    }

    public void processAck(CommandAck ack) {
    }

    public void processNack(CommandNack nack) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processResult(CommandResult result) {
        Object o = result.getResult();
        if (o instanceof RaisedAlertSummary) {
            String source = result.getOriginAgentInfo().getName();
            Instant timeStamp = this.getTimeStamp(result);
            AlertHandler alertHandler = this;
            synchronized (alertHandler) {
                Instant latest = this.source2time.merge(source, timeStamp, (s, t) -> timeStamp.isAfter((Instant)t) ? timeStamp : t);
                if (latest.equals(timeStamp)) {
                    RaisedAlertSummary summary = (RaisedAlertSummary)o;
                    this.source2summary.put(source, summary);
                    this.fireAlertEvent(new AlertEvent(source, new String[0], summary));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(AlertListener listener) {
        CopyOnWriteArrayList<AlertListener> copyOnWriteArrayList = this.listeners;
        synchronized (copyOnWriteArrayList) {
            boolean ok = this.listeners.addIfAbsent(listener);
            if (!ok) {
                throw new IllegalArgumentException("The listener is already registered");
            }
            if (this.listeners.size() == 1) {
                AgentMessagingLayer messenger = this.plugin.getConsole().getMessagingAccess();
                messenger.addStatusMessageListener((StatusMessageListener)this);
                List agents = messenger.getAgentPresenceManager().listConnectedAgents();
                for (AgentInfo agent : agents) {
                    try {
                        CommandRequest req = new CommandRequest(agent.getName(), "getRaisedAlertSummary");
                        messenger.sendCommandRequest(req, (CommandOriginator)this);
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(AlertListener listener) {
        CopyOnWriteArrayList<AlertListener> copyOnWriteArrayList = this.listeners;
        synchronized (copyOnWriteArrayList) {
            this.listeners.remove(listener);
            if (this.listeners.isEmpty()) {
                this.plugin.getConsole().getMessagingAccess().removeStatusMessageListener((StatusMessageListener)this);
            }
        }
    }

    private void fireAlertEvent(AlertEvent event) {
        this.listeners.forEach(listener -> listener.onAlert(event));
    }

    @Override
    public RaisedAlertSummary getSummary(String source) {
        return this.source2summary.get(source);
    }

    private Instant getTimeStamp(StatusAlert message) {
        return Instant.ofEpochMilli(message.getTimeStamp());
    }

    private Instant getTimeStamp(CommandResult result) {
        return Instant.ofEpochMilli(result.getTimeStamp());
    }
}

