/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.jas3;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.lsst.ccs.gconsole.Console;

public class PropertyHandler {
    private final HashMap<String, Object> defaultProperties = new HashMap();
    private final Properties prop;
    private final CopyOnWriteArrayList<Listener> listeners = new CopyOnWriteArrayList();

    PropertyHandler(Properties properties) {
        this.prop = properties;
    }

    public synchronized void addProperty(String key, Object defaultValue) {
        if (key == null || defaultValue == null) {
            throw new IllegalArgumentException("Argiments cannot be null.");
        }
        Type type = PropertyHandler.getType(defaultValue);
        Object oldDefault = this.defaultProperties.get(key);
        try {
            this.get(key, defaultValue);
        }
        catch (IllegalArgumentException x) {
            throw new IllegalArgumentException("The key is already used to store a value of incompatible type.", x);
        }
        if (oldDefault != null && !PropertyHandler.getType(oldDefault).equals((Object)type)) {
            throw new IllegalArgumentException("The key is already associated with a property of a different type.");
        }
        this.defaultProperties.put(key, defaultValue);
    }

    public synchronized Object removeProperty(String key) {
        Object value = null;
        Object defaultValue = this.defaultProperties.remove(key);
        if (defaultValue != null) {
            try {
                value = this.get(key, defaultValue);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.prop.remove(key);
        }
        return value;
    }

    public synchronized Object getProperty(String key) {
        Object defaultValue = this.defaultProperties.get(key);
        return this.get(key, defaultValue);
    }

    public synchronized Object setProperty(String key, Object value) {
        Object old = this.set(key, value);
        if (value == null && old != null) {
            value = this.defaultProperties.get(key);
            if (!old.equals(value)) {
                this.notifyListeners(null, key, value);
            }
        } else if (value != null && !value.equals(old)) {
            this.notifyListeners(null, key, value);
        }
        return old;
    }

    public synchronized void setProperties(Map<String, Object> keyValueMap) {
        HashMap<String, Object> changes = new HashMap<String, Object>(keyValueMap.size() * 2);
        keyValueMap.forEach((key, value) -> {
            Object old = this.set((String)key, value);
            if (value == null && old != null) {
                value = this.defaultProperties.get(key);
                if (!old.equals(value)) {
                    changes.put((String)key, value);
                }
            } else if (value != null && !value.equals(old)) {
                changes.put((String)key, value);
            }
        });
        this.notifyListeners(null, changes);
    }

    public void addPropertyListener(Console.PropertyListener listener, String filter) {
        Pattern p;
        if (filter == null) {
            p = null;
        } else {
            try {
                p = Pattern.compile(filter);
            }
            catch (PatternSyntaxException x) {
                throw new IllegalArgumentException("Illegal regular expression in property listener filter.", x);
            }
        }
        this.listeners.add(new Listener(listener, p));
    }

    public boolean removePropertyListener(Console.PropertyListener listener) {
        return this.listeners.remove(new Listener(listener, null));
    }

    private Object set(String key, Object value) {
        Type type = PropertyHandler.getType(value);
        Object defaultValue = this.defaultProperties.get(key);
        Object previousValue = this.get(key, defaultValue);
        if (value == null || value.equals(defaultValue)) {
            this.prop.remove(key);
        } else {
            Type defaultType;
            if (defaultValue != null && (defaultType = PropertyHandler.getType(defaultValue)) != type) {
                throw new IllegalArgumentException("The key is associated with a property of a different type.");
            }
            switch (type) {
                case ENUM: {
                    Enum enumValue = (Enum)value;
                    String s = enumValue.getClass().getName() + "." + enumValue.name();
                    this.prop.setProperty(key, s);
                    break;
                }
                default: {
                    this.prop.setProperty(key, value.toString());
                }
            }
        }
        return previousValue;
    }

    private void notifyListeners(Object source, String key, Object value) {
        this.listeners.forEach(listener -> listener.notify(source, key, value));
    }

    private void notifyListeners(Object source, Map<String, Object> changes) {
        this.listeners.forEach(listener -> listener.notify(source, changes));
    }

    static Type getType(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return Type.BOOLEAN;
        }
        if (value instanceof String) {
            return Type.STRING;
        }
        if (value instanceof Integer) {
            return Type.INTEGER;
        }
        if (value instanceof Double) {
            return Type.DOUBLE;
        }
        if (value instanceof Long) {
            return Type.LONG;
        }
        if (value instanceof Enum) {
            return Type.ENUM;
        }
        throw new IllegalArgumentException("Unsupported property type: " + value.getClass().getName());
    }

    private Object get(String key, Object defaultValue) {
        String s = this.prop.getProperty(key);
        if (defaultValue == null) {
            return s;
        }
        if (s == null) {
            return defaultValue;
        }
        Type type = PropertyHandler.getType(defaultValue);
        switch (type) {
            case BOOLEAN: {
                return Boolean.valueOf(s);
            }
            case INTEGER: {
                return Integer.valueOf(s);
            }
            case LONG: {
                return Long.valueOf(s);
            }
            case DOUBLE: {
                return Double.valueOf(s);
            }
            case STRING: {
                return s;
            }
            case ENUM: {
                try {
                    int i = s.lastIndexOf(46);
                    String className = s.substring(0, i);
                    String instanceName = s.substring(i + 1);
                    Class<?> clazz = this.getClass().getClassLoader().loadClass(className);
                    return Enum.valueOf(clazz, instanceName);
                }
                catch (ClassNotFoundException | IllegalArgumentException | IndexOutOfBoundsException | NullPointerException x) {
                    throw new IllegalArgumentException("String '" + s + "' cannot be converted to enum.", x);
                }
            }
        }
        throw new AssertionError((Object)("Unknown property type: " + (Object)((Object)type)));
    }

    private static class Listener {
        Console.PropertyListener listener;
        Pattern pattern;

        Listener(Console.PropertyListener listener, Pattern pattern) {
            this.listener = listener;
            this.pattern = pattern;
        }

        void notify(Object source, Map<String, Object> changes) {
            HashMap relevantChanges = new HashMap();
            changes.forEach((key, value) -> {
                if (this.pattern.matcher((CharSequence)key).matches()) {
                    relevantChanges.put(key, value);
                }
            });
            if (!relevantChanges.isEmpty()) {
                this.listener.propertiesChanged(source, Collections.unmodifiableMap(relevantChanges));
            }
        }

        void notify(Object source, String key, Object value) {
            if (this.pattern.matcher(key).matches()) {
                this.listener.propertiesChanged(source, Collections.singletonMap(key, value));
            }
        }

        public boolean equals(Object obj) {
            if (obj instanceof Listener) {
                return ((Listener)obj).listener == this.listener;
            }
            return false;
        }
    }

    static enum Type {
        BOOLEAN,
        INTEGER,
        LONG,
        DOUBLE,
        STRING,
        ENUM;

    }
}

