/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.jas3;

import org.freehep.application.Application;
import org.freehep.application.studio.Plugin;
import org.freehep.application.studio.PluginFactory;
import org.freehep.application.studio.PluginInfo;
import org.freehep.application.studio.Studio;
import org.lsst.ccs.gconsole.ConsolePlugin;
import org.lsst.ccs.gconsole.ConsolePluginDescriptor;
import org.lsst.ccs.gconsole.jas3.Jas3Console;
import org.lsst.ccs.gconsole.jas3.Jas3PluginServices;

public class LsstPluginFactory
implements PluginFactory {
    private static final Jas3Console agent = new Jas3Console();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Plugin getInstance(Studio studio, PluginInfo pluginDescriptor, ClassLoader loader) throws Throwable {
        Jas3PluginServices provider;
        Class<?> pluginClass = loader.loadClass(pluginDescriptor.getMainClass());
        if (Plugin.class.isAssignableFrom(pluginClass)) {
            return (Plugin)pluginClass.newInstance();
        }
        ConsolePlugin consolePlugin = (ConsolePlugin)pluginClass.newInstance();
        JasPlugin jasPlugin = new JasPlugin(consolePlugin);
        Jas3PluginServices jas3PluginServices = provider = new Jas3PluginServices(agent, consolePlugin, new PluginDescriptor(pluginDescriptor), jasPlugin);
        synchronized (jas3PluginServices) {
            consolePlugin.setServicesProvider(provider);
        }
        return jasPlugin;
    }

    static {
        agent.start();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                agent.shutdown();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }));
        ((Studio)Application.getApplication()).getLookup().add((Object)agent);
    }

    private static class JasPlugin
    extends Plugin {
        private final ConsolePlugin plugin;

        JasPlugin(ConsolePlugin consolePlugin) {
            this.plugin = consolePlugin;
        }

        protected synchronized void init() throws Throwable {
        }

        protected synchronized void postInit() {
            this.plugin.initialize();
        }

        protected synchronized void applicationVisible() {
            this.plugin.start();
        }

        protected synchronized void shutdown() {
            this.plugin.stop();
            this.plugin.shutdown();
        }
    }

    private static class PluginDescriptor
    implements ConsolePluginDescriptor {
        private final String name;
        private final String version;
        private final String description;

        PluginDescriptor(String name, String version, String description) {
            this.name = name;
            this.version = version;
            this.description = description;
        }

        PluginDescriptor(PluginInfo info) {
            this.name = info.getName();
            this.version = info.getVersion();
            this.description = info.getDescription();
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getVersion() {
            return this.version;
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }
}

