/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.trending;

import hep.aida.IAxisStyle;
import hep.aida.IBaseHistogram;
import hep.aida.IDataStyle;
import hep.aida.IPlotterStyle;
import hep.aida.ref.plotter.PlotterFactory;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.freehep.jas.plugin.plotter.DefaultRegion;
import org.freehep.jas.services.PlotFactory;
import org.freehep.jas.services.PlotPage;
import org.freehep.jas.services.PlotRegion;
import org.freehep.jas.services.Plotter;
import org.freehep.swing.popup.HasPopupItems;
import org.lsst.ccs.gconsole.plugins.trending.AuxData;
import org.lsst.ccs.gconsole.plugins.trending.DataChannelHandler;
import org.lsst.ccs.gconsole.plugins.trending.LsstTrendingPlugin;
import org.lsst.ccs.gconsole.plugins.trending.Plot;
import org.lsst.ccs.gconsole.plugins.trending.timeselection.TimeWindow;

public class PlotMaker {
    private final LsstTrendingPlugin plugin;
    private final PlotterFactory plotterStyleFactory;
    private final EnumMap<AuxData.Type, IPlotterStyle> auxStyles;
    private PlotFactory plotFactory;
    private ThreadPoolExecutor executor;
    private final int DATA_FETCHER_MAX_THREADS = 3;
    private final int DATA_FETCHER_KEEP_ALIVE = 120;

    PlotMaker(LsstTrendingPlugin trendingPlugin) {
        this.plugin = trendingPlugin;
        this.plotterStyleFactory = new PlotterFactory();
        this.auxStyles = new EnumMap(AuxData.Type.class);
        IPlotterStyle style = this.plotterStyleFactory.createPlotterStyle();
        IDataStyle dataStyle = style.dataStyle();
        dataStyle.showInLegendBox(false);
        dataStyle.showInStatisticsBox(false);
        dataStyle.outlineStyle().setParameter("color", "red");
        dataStyle.outlineStyle().setLineType("dashed");
        dataStyle.markerStyle().setVisible(false);
        this.auxStyles.put(AuxData.Type.ALARM, style);
        style = this.plotterStyleFactory.createPlotterStyle();
        dataStyle = style.dataStyle();
        dataStyle.showInLegendBox(false);
        dataStyle.showInStatisticsBox(false);
        dataStyle.outlineStyle().setParameter("color", "orange");
        dataStyle.outlineStyle().setLineType("dashed");
        dataStyle.markerStyle().setVisible(false);
        this.auxStyles.put(AuxData.Type.WARNING, style);
        ThreadFactory tFactory = new ThreadFactory(){
            ThreadFactory delegate = Executors.defaultThreadFactory();
            int id = 0;

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = this.delegate.newThread(r);
                thread.setName("Trending Data Fetcher " + this.id++);
                return thread;
            }
        };
        this.executor = new ThreadPoolExecutor(3, 3, 120L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), tFactory);
        this.executor.allowCoreThreadTimeOut(true);
    }

    public void plot(DataChannelHandler channel, TimeWindow timeWindow, boolean useExistingPlot, boolean newPage, boolean newPlot, boolean overlay) {
        if (channel == null) {
            return;
        }
        if (this.plotFactory == null) {
            this.plotFactory = (PlotFactory)this.plugin.getApplication().getLookup().lookup(PlotFactory.class);
            if (this.plotFactory == null) {
                this.plugin.getApplication().error("No plot factory available");
            }
        }
        if (timeWindow == null && (timeWindow = this.plugin.getTimeWindowSelector().getSelectedTimeWindow()) == null) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            TimeWindow tw = timeWindow;
            this.executor.execute(() -> this.plot(channel, tw, useExistingPlot, newPage, newPlot, overlay));
            return;
        }
        PlotRegion region = null;
        PlotPage page = null;
        Plot existingPlot = null;
        if (useExistingPlot && (existingPlot = channel.findPlot(timeWindow)) != null) {
            page = existingPlot.getPage();
            region = existingPlot.getRegion();
        }
        if (page == null) {
            if (!newPage) {
                page = this.plotFactory.currentPage();
            }
            if (page == null) {
                page = this.plotFactory.createPage(channel.getPath());
                if (page == null) {
                    this.plugin.getApplication().error("Unable to create a plot page");
                    return;
                }
                page.createRegions(1, 1);
                region = page.currentRegion();
            }
        }
        if (region == null) {
            if (newPlot) {
                int n = page.numberOfRegions();
                for (int i = 0; i < n; ++i) {
                    PlotRegion r = page.region(i);
                    if (r.currentPlot() != null) continue;
                    region = r;
                    break;
                }
            } else {
                region = page.currentRegion();
            }
            if (region == null) {
                region = page.addRegion();
            }
        }
        Plot plot = channel.makePlot(timeWindow);
        plot.setVisible(AuxData.Type.ALARM, this.plugin.getPreferences().drawAlarm());
        plot.setVisible(AuxData.Type.WARNING, this.plugin.getPreferences().drawAlarm());
        plot.setPage(page);
        plot.setRegion(region);
        if (existingPlot != null) {
            plot.setVisible(existingPlot);
        }
        page.setCurrentRegion(region);
        page.showPage();
        this.plotData(Collections.singletonList(plot), page, region, overlay);
    }

    public void refresh(DataChannelHandler channel, TimeWindow timeWindow) {
        PlotMaker.getRegions(channel).forEach(region -> this.refresh((PlotRegion)region, timeWindow, new Options[0]));
    }

    public void refresh(PlotPage page, TimeWindow timeWindow) {
        int n = page.numberOfRegions();
        try {
            for (int i = 0; i < n; ++i) {
                this.refresh(page.region(i), timeWindow, new Options[0]);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void refresh(PlotRegion region, TimeWindow timeWindow, Options ... options) {
        EnumSet<Options> opt;
        try {
            if (((JComponent)region).getTopLevelAncestor() == null) {
                return;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        PlotPage page = null;
        Plotter plotter = region.currentPlot();
        if (plotter == null) {
            return;
        }
        EnumSet<Options> enumSet = opt = options.length == 0 ? EnumSet.noneOf(Options.class) : EnumSet.copyOf(Arrays.asList(options));
        if (SwingUtilities.isEventDispatchThread()) {
            boolean refreshReady;
            boolean bl = refreshReady = timeWindow == null;
            if (refreshReady) {
                boolean bl2 = refreshReady = opt.contains((Object)Options.REFRESH_NONE) || plotter.getData().stream().filter(po -> po instanceof Plot).allMatch(po -> {
                    Plot plot = (Plot)po;
                    return plot.isRefreshReady() || !opt.contains((Object)Options.REFRESH_ALL) && plot.getTimeWindow().isFixed();
                });
            }
            if (!refreshReady) {
                this.executor.execute(() -> this.refresh(region, timeWindow, options));
                return;
            }
        }
        boolean replot = opt.contains((Object)Options.FORCE_REPLOT);
        ArrayList<Object> data = new ArrayList<Object>(plotter.getData().size());
        for (Object plottedObject : plotter.getData()) {
            if (plottedObject instanceof Plot) {
                Plot plot = (Plot)plottedObject;
                page = plot.getPage();
                TimeWindow tw = plot.getTimeWindow();
                if (timeWindow == null) {
                    if (!(opt.contains((Object)Options.REFRESH_NONE) || !opt.contains((Object)Options.REFRESH_ALL) && tw.isFixed())) {
                        replot = true;
                        if (!plot.isRefreshReady()) {
                            plot.refresh();
                        }
                        plot.commitRefresh();
                    }
                } else {
                    replot = true;
                    Plot oldPlot = plot;
                    plot = oldPlot.getChannel().makePlot(timeWindow);
                    plot.setVisible(oldPlot);
                    plot.setRegion(region);
                }
                data.add(plot);
                continue;
            }
            if (plottedObject instanceof AuxData) continue;
            data.add(plottedObject);
        }
        if (replot && page != null) {
            this.plotData(data, page, region, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void plotData(List<Object> data, PlotPage page, PlotRegion region, boolean overlay) {
        boolean commonExtent;
        if (!SwingUtilities.isEventDispatchThread()) {
            List<Object> dataFinal = data;
            boolean overlayFinal = overlay;
            SwingUtilities.invokeLater(() -> this.plotData(dataFinal, page, region, overlayFinal));
            return;
        }
        if (data.isEmpty()) {
            return;
        }
        try {
            if (((JComponent)region).getTopLevelAncestor() == null) {
                return;
            }
        }
        catch (ClassCastException dataFinal) {
            // empty catch block
        }
        Plotter plotter = region.currentPlot();
        if (plotter == null) {
            plotter = this.plotFactory.createPlotterFor(IBaseHistogram.class);
            overlay = false;
        } else if (!overlay) {
            Plotter overlayFinal = plotter;
            synchronized (overlayFinal) {
                plotter.clear();
            }
        } else {
            ArrayList<Object> oldData = this.hideAuxData(plotter);
            if (oldData != null) {
                oldData.addAll(data);
                data = oldData;
                overlay = false;
            }
        }
        IPlotterStyle style = this.plotterStyleFactory.createPlotterStyle();
        IAxisStyle xAxisStyle = style.xAxisStyle();
        xAxisStyle.setParameter("type", "date");
        boolean bl = commonExtent = data.size() > 1 && !overlay;
        if (commonExtent) {
            long tLow = Long.MAX_VALUE;
            long tHigh = 0L;
            for (Object datum : data) {
                try {
                    Plot pd;
                    Plot plot = pd = (Plot)datum;
                    synchronized (plot) {
                        tLow = Math.min(tLow, (long)pd.lowerExtent(0));
                        tHigh = Math.max(tHigh, (long)pd.upperExtent(0));
                    }
                    xAxisStyle.setParameter("lowerLimit", String.valueOf(tLow / 1000L));
                    xAxisStyle.setParameter("upperLimit", String.valueOf(tHigh / 1000L));
                }
                catch (ClassCastException classCastException) {}
            }
        }
        EnumMap<AuxData.Type, Boolean> stateAux = null;
        if (!overlay && data.size() == 1 && data.get(0) instanceof Plot) {
            stateAux = new EnumMap<AuxData.Type, Boolean>(AuxData.Type.class);
        }
        Plotter plotter2 = plotter;
        synchronized (plotter2) {
            int i = 0;
            while (true) {
                block31: {
                    int n;
                    AuxData.Type[] typeArray;
                    Plot plot;
                    block32: {
                        block29: {
                            Object datum;
                            block30: {
                                if (i >= data.size()) break block29;
                                datum = data.get(i);
                                if (!(datum instanceof Plot)) break block30;
                                plot = (Plot)datum;
                                plot.setPage(page);
                                plot.setRegion(region);
                                plot.getChannel().addPlotData(plot);
                                if (!commonExtent) {
                                    xAxisStyle.setParameter("lowerLimit", String.valueOf(plot.lowerExtent(0) / 1000.0));
                                    xAxisStyle.setParameter("upperLimit", String.valueOf(plot.upperExtent(0) / 1000.0));
                                }
                                plotter.plot((Object)plot, i == 0 && !overlay ? 0 : 1, (Object)style, "");
                                if (stateAux == null) break block31;
                                typeArray = AuxData.Type.values();
                                n = typeArray.length;
                                break block32;
                            }
                            plotter.plot(datum, i == 0 && !overlay ? 0 : 1, (Object)style, "");
                            break block31;
                        }
                        // MONITOREXIT @DISABLED, blocks:[7, 13] lbl81 : MonitorExitStatement: MONITOREXIT : var10_24
                        try {
                            DefaultRegion reg = (DefaultRegion)region;
                            reg.removePopupItems(null, it -> it instanceof Popup);
                            reg.addPopupItems((HasPopupItems)new Popup(region, stateAux));
                        }
                        catch (ClassCastException classCastException) {
                            // empty catch block
                        }
                        region.showPlot(plotter);
                        return;
                    }
                    for (int j = 0; j < n; ++j) {
                        AuxData.Type type = typeArray[j];
                        if (!plot.getData().isAvailable(type)) continue;
                        if (plot.isVisible(type)) {
                            IPlotterStyle auxStyle = this.auxStyles.get((Object)type);
                            if (auxStyle == null) {
                                auxStyle = this.plotterStyleFactory.createPlotterStyle();
                            }
                            auxStyle.setAxisStyleX(xAxisStyle);
                            for (AuxData auxData : plot.getData().get(type)) {
                                plotter.plot((Object)auxData, 1, (Object)auxStyle, "");
                            }
                            stateAux.put(type, true);
                            continue;
                        }
                        stateAux.put(type, false);
                    }
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<Object> hideAuxData(Plotter plotter) {
        Plotter plotter2 = plotter;
        synchronized (plotter2) {
            List data = plotter.getData();
            Predicate<Object> isNotAux = object -> !(object instanceof AuxData);
            boolean doNotReplot = data.stream().allMatch(isNotAux);
            if (doNotReplot) {
                return null;
            }
            ArrayList out = data.stream().filter(isNotAux).collect(Collectors.toCollection(ArrayList::new));
            plotter.clear();
            return out;
        }
    }

    static List<PlotRegion> getRegions(DataChannelHandler channel) {
        return channel.getPlots().stream().map(Plot::getRegion).collect(Collectors.toList());
    }

    static Plot getPlot(PlotRegion region) {
        Plotter plotter = region.currentPlot();
        if (plotter == null) {
            return null;
        }
        for (Object po : PlotMaker.getPlotterData(plotter)) {
            if (!(po instanceof Plot)) continue;
            return (Plot)po;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<Object> getPlotterData(Plotter plotter) {
        Plotter plotter2 = plotter;
        synchronized (plotter2) {
            return new ArrayList<Object>(plotter.getData());
        }
    }

    private class Popup
    implements HasPopupItems {
        private EnumMap<AuxData.Type, Boolean> state;
        private final PlotRegion region;

        Popup(PlotRegion region) {
            this.region = region;
        }

        Popup(PlotRegion region, EnumMap<AuxData.Type, Boolean> state) {
            this.region = region;
            this.state = state == null || state.isEmpty() ? null : state;
        }

        public JPopupMenu modifyPopupMenu(JPopupMenu menu, Component componentt, Point point) {
            if (this.state == null) {
                return menu;
            }
            menu.insert(new JSeparator(), 0);
            JMenu extraMenu = new JMenu("Show extras");
            for (Map.Entry<AuxData.Type, Boolean> e : this.state.entrySet()) {
                if (e.getValue() == null) continue;
                JCheckBoxMenuItem item = new JCheckBoxMenuItem(e.getKey().getLabel(), e.getValue());
                item.addActionListener(evt -> {
                    Plot plot = PlotMaker.getPlot(this.region);
                    if (plot != null) {
                        plot.setVisible((AuxData.Type)((Object)((Object)e.getKey())), item.getState());
                        PlotMaker.this.refresh(this.region, null, Options.REFRESH_NONE, Options.FORCE_REPLOT);
                    }
                });
                extraMenu.add(item);
            }
            menu.insert(extraMenu, 0);
            return menu;
        }

        void set(AuxData.Type type, Boolean visible) {
            if (this.state == null) {
                this.state = new EnumMap(AuxData.Type.class);
            }
            this.state.put(type, visible);
        }
    }

    public static enum Options {
        REFRESH_ALL,
        REFRESH_NONE,
        FORCE_REPLOT;

    }
}

