/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.tracer;

import java.io.IOException;
import java.net.URL;
import org.freehep.application.mdi.PageListener;
import org.freehep.application.studio.Studio;
import org.freehep.jas.extensions.jconsole.JConsoleProvider;
import org.freehep.jas.extensions.jconsole.JConsoleService;
import org.freehep.jas.extensions.jconsole.JLineConsole;
import org.freehep.jas.extensions.jconsole.JLineConsoleProvider;
import org.freehep.jas.plugin.console.Console;
import org.freehep.jas.plugin.console.ConsoleService;
import org.freehep.swing.popup.HasPopupItems;
import org.freehep.util.FreeHEPLookup;
import org.freehep.util.commanddispatcher.CommandGroup;
import org.freehep.util.commanddispatcher.CommandProcessor;
import org.freehep.xml.menus.XMLMenuBuilder;
import org.lsst.ccs.gconsole.jas3.LsstPlugin;
import org.lsst.ccs.gconsole.plugins.tracer.FilterRegistry;
import org.lsst.ccs.gconsole.plugins.tracer.MessageFilter;
import org.lsst.ccs.gconsole.plugins.tracer.Tracer;
import org.lsst.ccs.gconsole.plugins.tracer.TracerWriter;
import org.xml.sax.SAXException;

public class LsstTracerPlugin
extends LsstPlugin {
    private final String defaultTracerName = "LSST Tracer";
    private final FilterRegistry filterRegistry = new FilterRegistry(this);

    public void init() throws SAXException, IOException {
        Studio studio = this.getApplication();
        FreeHEPLookup lookup = studio.getLookup();
        lookup.add((Object)this);
        studio.getCommandTargetManager().add((CommandGroup)new TracerCommands());
        XMLMenuBuilder builder = studio.getXMLMenuBuilder();
        URL xml = ((Object)((Object)this)).getClass().getResource("LsstTracerPlugin.menus");
        builder.build(xml);
    }

    public void postInit() {
        super.postInit();
        JConsoleService cs = (JConsoleService)this.getApplication().getLookup().lookup(JConsoleService.class);
        if (cs == null) {
            throw new IllegalStateException("JConsole service is not available");
        }
        cs.addConsoleProvider(JLineConsole.class, (JConsoleProvider)new JLineConsoleProvider());
        this.filterRegistry.init();
    }

    public FilterRegistry getFilterRegistry() {
        return this.filterRegistry;
    }

    public Tracer createTracer(String name) {
        return this.createTracer(name, (MessageFilter)null);
    }

    public Tracer createTracer(String name, String filterName) {
        return this.createTracer(name, this.filterRegistry.getFilter(filterName));
    }

    public Tracer createTracer(String name, MessageFilter filter) {
        FreeHEPLookup lookup = this.getApplication().getLookup();
        ConsoleService cs = (ConsoleService)lookup.lookup(ConsoleService.class);
        Tracer tracer = null;
        if (cs != null) {
            tracer = new Tracer(this, filter);
            Console console = cs.createConsole(name, null, (HasPopupItems)tracer);
            TracerWriter pw = new TracerWriter(console);
            cs.getPageContextForConsole(console).addPageListener((PageListener)tracer);
            tracer.start(pw);
        }
        return tracer;
    }

    public class TracerCommands
    extends CommandProcessor {
        public void onLsstTracer() {
            LsstTracerPlugin.this.createTracer("LSST Tracer");
        }
    }
}

