/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.tracer;

import jas.util.Application;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.freehep.swing.JComboBoxWithDisabledItems;
import org.lsst.ccs.gconsole.plugins.tracer.FilterChooser;
import org.lsst.ccs.gconsole.plugins.tracer.FilterRegistry;
import org.lsst.ccs.gconsole.plugins.tracer.FilteredMessage;
import org.lsst.ccs.gconsole.plugins.tracer.LsstTracerPlugin;
import org.lsst.ccs.gconsole.plugins.tracer.MessageFilter;
import org.lsst.ccs.gconsole.plugins.tracer.TracerFilter;
import org.lsst.ccs.gconsole.plugins.tracer.UserFilter;
import org.openide.awt.ColorComboBox;

public class FilterEditor
extends JDialog {
    private final int VSPACE = 5;
    private final int HSPACE = 5;
    private final int C_OR = 0;
    private final int C_MODE = 1;
    private final int C_INVERT = 2;
    private final int C_FORMAT = 3;
    private final int C_TARGET = 4;
    private final int C_METHOD = 5;
    private final int C_CODE = 6;
    private final int C_COLOR = 7;
    private final int C_FLAG = 8;
    private final int C_VALID = 9;
    private final String[] columnNames = new String[]{"OR", "Mode", "Invert", "Format", "Target", "Method", "Definition", "Color", "Flag"};
    private final Class[] columnClasses = new Class[]{Boolean.class, TracerFilter.Mode.class, Boolean.class, Boolean.class, TracerFilter.Target.class, TracerFilter.Method.class, String.class, Color.class, FilteredMessage.Flag.class};
    private final Predicate<String> isValidName = Pattern.compile("[\\w-\\. /]+").asPredicate();
    private JTable table;
    private Model model;
    private JButton insertButton;
    private JButton removeButton;
    private JButton upButton;
    private JButton downButton;
    private JButton saveButton;
    private JButton saveAsButton;
    private JButton okButton;
    private UserFilter out;
    private String name;
    private final LsstTracerPlugin plugin;

    private FilterEditor(Component parent, MessageFilter filter, LsstTracerPlugin plugin) {
        super(FilterEditor.getWindow(parent), "Unnamed Filter", Dialog.ModalityType.APPLICATION_MODAL);
        this.plugin = plugin;
        this.setDefaultCloseOperation(2);
        if (filter != null && filter instanceof UserFilter) {
            this.name = filter.getName();
            if (this.name != null) {
                this.setTitle(this.name);
            }
        }
        this.setPreferredSize(new Dimension(800, 600));
        this.model = new Model(filter);
        this.table = new Table(this.model);
        this.table.setFillsViewportHeight(true);
        this.table.setSelectionMode(1);
        this.table.getSelectionModel().addListSelectionListener(e -> {
            int first = this.table.getSelectedRow();
            int count = this.table.getSelectedRowCount();
            this.insertButton.setEnabled(count > 0);
            this.removeButton.setEnabled(count > 0);
            this.upButton.setEnabled(first > 0);
            this.downButton.setEnabled(count > 0 && first + count < this.table.getRowCount());
        });
        this.add((Component)new JScrollPane(this.table), "Center");
        JComboBox<Enum> combo = new JComboBox<Enum>();
        for (TracerFilter.Mode state : TracerFilter.Mode.values()) {
            combo.addItem(state);
        }
        DefaultCellEditor editor = new DefaultCellEditor(combo);
        editor.setClickCountToStart(2);
        this.table.getColumnModel().getColumn(1).setCellEditor(editor);
        JCheckBox cb = new JCheckBox();
        cb.setMaximumSize(cb.getMinimumSize());
        cb.setPreferredSize(cb.getMinimumSize());
        editor = new DefaultCellEditor(cb);
        this.table.getColumnModel().getColumn(2).setCellEditor(editor);
        combo = new JComboBox();
        for (TracerFilter.Target target : TracerFilter.Target.values()) {
            combo.addItem(target);
        }
        editor = new DefaultCellEditor(combo);
        editor.setClickCountToStart(2);
        this.table.getColumnModel().getColumn(4).setCellEditor(editor);
        this.table.getColumnModel().getColumn(5).setCellEditor(new MethodEditor());
        this.table.getColumnModel().getColumn(6).setCellRenderer(new CodeRenderer());
        this.table.getColumnModel().getColumn(6).setCellEditor(new CodeEditor());
        this.table.getColumnModel().getColumn(7).setCellRenderer(new ColorRenderer());
        this.table.getColumnModel().getColumn(7).setCellEditor(new ColorEditor());
        combo = new JComboBox();
        for (Enum enum_ : FilteredMessage.Flag.values()) {
            combo.addItem(enum_);
        }
        editor = new DefaultCellEditor(combo);
        editor.setClickCountToStart(2);
        this.table.getColumnModel().getColumn(8).setCellEditor(editor);
        Box controls = Box.createHorizontalBox();
        controls.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)controls, "North");
        JButton button = new JButton("Add");
        button.setToolTipText("Add filter");
        button.addActionListener(e -> {
            TableCellEditor ce = this.table.getCellEditor();
            if (ce == null || ce.stopCellEditing()) {
                this.model.insertRow(this.model.getRowCount());
            }
        });
        controls.add(button);
        controls.add(Box.createHorizontalStrut(5));
        this.insertButton = new JButton("Insert");
        this.insertButton.setToolTipText("Insert filter");
        this.insertButton.setEnabled(false);
        this.insertButton.addActionListener(e -> {
            TableCellEditor ce = this.table.getCellEditor();
            if (ce == null || ce.stopCellEditing()) {
                int i = this.table.getSelectedRow();
                this.model.insertRow(i < 0 ? 0 : i);
            }
        });
        controls.add(this.insertButton);
        controls.add(Box.createHorizontalStrut(5));
        this.removeButton = new JButton("Remove");
        this.removeButton.setToolTipText("Remove selected filter");
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(e -> {
            TableCellEditor ce = this.table.getCellEditor();
            if (ce == null || ce.stopCellEditing()) {
                this.model.removeRows(this.table.getSelectedRows());
            }
        });
        controls.add(this.removeButton);
        controls.add(Box.createHorizontalGlue());
        controls.add(Box.createHorizontalStrut(10));
        this.upButton = new JButton(" Up ");
        this.upButton.setToolTipText("Move selected filter up in sequence");
        this.upButton.setEnabled(false);
        this.upButton.addActionListener(e -> this.move(-1));
        controls.add(this.upButton);
        controls.add(Box.createHorizontalStrut(5));
        this.downButton = new JButton("Down");
        this.downButton.setToolTipText("Move selected filter down in sequence");
        this.downButton.setEnabled(false);
        this.downButton.addActionListener(e -> this.move(1));
        controls.add(this.downButton);
        controls = Box.createHorizontalBox();
        controls.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)controls, "South");
        this.saveButton = new JButton("Save");
        this.saveButton.setEnabled(this.name != null);
        this.saveButton.addActionListener(e -> {
            try {
                UserFilter f = this.model.makeFilter();
                if (f == null) {
                    plugin.getApplication().error("Unable to save filter " + this.name);
                }
                plugin.getFilterRegistry().saveFilter(f);
            }
            catch (IOException | IllegalStateException x) {
                plugin.getApplication().error("Unable to save filter " + this.name, (Throwable)x);
            }
        });
        controls.add(this.saveButton);
        controls.add(Box.createHorizontalStrut(5));
        this.saveAsButton = new JButton("Save As...");
        this.saveAsButton.addActionListener(e -> {
            String oldName = this.name;
            try {
                String newName = JOptionPane.showInputDialog(this, "Enter filter name, using\n(\"/\", \"-\", \"_\", \".\", \" \", and alphanumeric symbols.", "Filter name:", 3);
                if (newName == null) {
                    return;
                }
                if (!this.isValidName.test(newName = newName.trim())) {
                    plugin.getApplication().error("Illegal filter name: " + newName);
                    return;
                }
                this.name = newName;
                UserFilter f = this.model.makeFilter();
                if (f == null) {
                    plugin.getApplication().error("Unable to save filter " + this.name);
                }
                plugin.getFilterRegistry().saveFilter(f);
                this.setTitle(this.name);
                this.saveButton.setEnabled(true);
            }
            catch (IOException | IllegalStateException x) {
                plugin.getApplication().error("Unable to save filter " + this.name, (Throwable)x);
                this.name = oldName;
            }
        });
        controls.add(this.saveAsButton);
        controls.add(Box.createHorizontalStrut(10));
        controls.add(Box.createHorizontalGlue());
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(e -> {
            this.out = this.model.makeFilter();
            if (this.out != null) {
                this.setVisible(false);
            }
        });
        controls.add(this.okButton);
        controls.add(Box.createHorizontalStrut(5));
        button = new JButton("Cancel");
        button.addActionListener(e -> this.setVisible(false));
        controls.add(button);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(150);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(150);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(150);
        this.table.getColumnModel().getColumn(4).setPreferredWidth(170);
        this.table.getColumnModel().getColumn(5).setPreferredWidth(170);
        this.table.getColumnModel().getColumn(6).setPreferredWidth(800);
        this.table.getColumnModel().getColumn(7).setPreferredWidth(170);
        this.table.getColumnModel().getColumn(8).setPreferredWidth(170);
        this.table.clearSelection();
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    public static UserFilter showDialog(Component parent, MessageFilter filter, LsstTracerPlugin plugin) {
        FilterEditor editor = new FilterEditor(parent, filter, plugin);
        editor.setVisible(true);
        UserFilter out = editor.getFilter();
        editor.dispose();
        return out;
    }

    public static Window getWindow(Component parent) {
        try {
            Container out = parent == null ? Application.getApplication().getTopLevelAncestor() : ((JComponent)parent).getTopLevelAncestor();
            return (Window)out;
        }
        catch (ClassCastException x) {
            return null;
        }
    }

    public UserFilter getFilter() {
        return this.out;
    }

    private void move(int dir) {
        int begNext;
        TableCellEditor ce = this.table.getCellEditor();
        if (ce != null && !ce.stopCellEditing()) {
            return;
        }
        int begSel = this.table.getSelectedRow();
        int k = this.table.getSelectedRowCount();
        if (k == 0) {
            return;
        }
        int endSel = begSel + k - 1;
        int n = this.table.getRowCount();
        boolean isOrFragment = true;
        for (int i = 0; i < k; ++i) {
            isOrFragment = isOrFragment && this.isOR(begSel + i);
        }
        int n2 = begNext = dir > 0 ? endSel + 1 : begSel - 1;
        if (begNext < 0 || begNext >= n) {
            return;
        }
        boolean bl = isOrFragment = isOrFragment && this.isOR(begNext);
        if (isOrFragment) {
            if (dir > 0) {
                this.model.move(begSel, endSel, begNext, begNext);
                this.table.getSelectionModel().setSelectionInterval(begSel + 1, endSel + 1);
            } else {
                this.model.move(begNext, begNext, begSel, endSel);
                this.table.getSelectionModel().setSelectionInterval(begSel - 1, endSel - 1);
            }
        } else {
            if (this.isOR(begSel)) {
                while (begSel > 0 && this.isOR(begSel - 1)) {
                    --begSel;
                }
            }
            if (this.isOR(endSel)) {
                while (endSel + 1 < n && this.isOR(endSel + 1)) {
                    ++endSel;
                }
            }
            int n3 = begNext = dir > 0 ? endSel + 1 : begSel - 1;
            if (begNext < 0 || begNext >= n) {
                return;
            }
            int endNext = begNext;
            if (this.isOR(endNext)) {
                int bound;
                int n4 = bound = dir > 0 ? n : -1;
                while (endNext + dir != bound && this.isOR(endNext + dir)) {
                    endNext += dir;
                }
            }
            k = endNext - begNext + 1;
            if (dir > 0) {
                this.model.move(begSel, endSel, begNext, endNext);
                this.table.getSelectionModel().setSelectionInterval(begSel + k, endSel + k);
            } else {
                this.model.move(endNext, begNext, begSel, endSel);
                this.table.getSelectionModel().setSelectionInterval(begSel - k, endSel - k);
            }
        }
    }

    private boolean isOR(int rowIndex) {
        return (Boolean)this.model.getValueAt(rowIndex, 0);
    }

    private void validateTable() {
        boolean allValid = true;
        for (int i = 0; i < this.model.data.length && (allValid = ((Boolean)this.model.data[i][9]).booleanValue()); ++i) {
        }
        this.okButton.setEnabled(allValid);
        this.saveButton.setEnabled(allValid && this.name != null);
        this.saveAsButton.setEnabled(allValid);
    }

    private class CodeEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private String code = "";
        private TracerFilter.Target target;
        private TracerFilter.Method method;
        private final CodeRenderer button = new CodeRenderer();

        CodeEditor() {
            this.button.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() > 1) {
                        String s = null;
                        StringPanel targetPanel = CodeEditor.this.getTargetPanel();
                        StringPanel patternPanel = CodeEditor.this.getPatternPanel();
                        if (targetPanel == null) {
                            if (CodeEditor.this.method == TracerFilter.Method.FILTER) {
                                s = FilterChooser.showDialog(CodeEditor.this.button, FilterEditor.this.plugin.getFilterRegistry());
                            } else {
                                int ok = JOptionPane.showConfirmDialog(CodeEditor.this.button, patternPanel, "Filter definition", 2, -1);
                                if (ok == 0) {
                                    s = patternPanel.get();
                                }
                            }
                        } else {
                            String p;
                            Box box = Box.createVerticalBox();
                            box.add(targetPanel);
                            box.add(Box.createRigidArea(new Dimension(0, 10)));
                            box.add(patternPanel);
                            box.add(Box.createRigidArea(new Dimension(5, 5)));
                            int ok = JOptionPane.showConfirmDialog(CodeEditor.this.button, box, "Filter definition", 2, -1);
                            if (ok == 0 && (s = targetPanel.get()) != null && (p = (String)patternPanel.get()) != null) {
                                s = s + "<=>" + p;
                            }
                        }
                        if (s != null) {
                            CodeEditor.this.code = s.toString();
                        }
                        CodeEditor.this.fireEditingStopped();
                    }
                }
            });
        }

        @Override
        public String getCellEditorValue() {
            return this.code;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.code = (String)value;
            this.target = (TracerFilter.Target)((Object)((FilterEditor)FilterEditor.this).model.data[row][4]);
            this.method = (TracerFilter.Method)((Object)((FilterEditor)FilterEditor.this).model.data[row][5]);
            return this.button.getTableCellRendererComponent(table, value, true, true, row, column);
        }

        private StringPanel getTargetPanel() {
            switch (this.target) {
                case TEMPLATE: {
                    return new TextFieldPanel("Enter template:", this.code.split("<=>")[0]);
                }
            }
            return null;
        }

        private StringPanel getPatternPanel() {
            int i = this.code.indexOf("<=>");
            String pattern = i == -1 ? this.code : this.code.substring(i + "<=>".length());
            switch (this.method) {
                case REGEX: {
                    return new TextFieldPanel("Enter regular expression:", pattern);
                }
                case WILDCARD: {
                    return new TextFieldPanel("Enter wildcard:", pattern);
                }
                case CONTAINS: 
                case EQUALS: {
                    return new TextFieldPanel("Enter pattern string:", pattern);
                }
                case CLASS: {
                    return new TextFieldPanel("Enter full class name:", pattern);
                }
                case FILTER: {
                    return new FilterNamePanel();
                }
            }
            return null;
        }

        private class FilterNamePanel
        extends StringPanel {
            JButton button;
            String result;

            FilterNamePanel() {
                this.setLayout(new BoxLayout(this, 1));
                this.button = new JButton("Choose filter");
                this.button.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.button.getMaximumSize().height));
                this.button.setAlignmentX(0.0f);
                this.button.addActionListener(e -> {
                    String s = FilterChooser.showDialog(this.button, FilterEditor.this.plugin.getFilterRegistry());
                    if (s != null) {
                        this.result = s;
                    }
                });
                this.add(this.button);
            }

            @Override
            public String get() {
                return this.result;
            }
        }

        private class TextFieldPanel
        extends StringPanel {
            JTextField field;

            TextFieldPanel(String message, String value) {
                this.setLayout(new BoxLayout(this, 1));
                JLabel label = new JLabel(message);
                label.setAlignmentX(0.0f);
                this.add(label);
                this.add(Box.createRigidArea(new Dimension(0, 5)));
                this.field = new JTextField(40);
                this.field.setAlignmentX(0.0f);
                if (value != null) {
                    this.field.setText(value);
                }
                this.add(this.field);
            }

            @Override
            public String get() {
                return this.field.getText();
            }
        }

        private abstract class StringPanel
        extends JPanel
        implements Supplier<String> {
            StringPanel() {
                this.setLayout(new BoxLayout(this, 1));
                this.setAlignmentX(0.0f);
            }
        }
    }

    private class CodeRenderer
    extends JLabel
    implements TableCellRenderer {
        Border unselectedBorder;
        Border selectedBorder;

        CodeRenderer() {
            this.setOpaque(false);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                if (this.selectedBorder == null) {
                    this.selectedBorder = BorderFactory.createMatteBorder(2, 3, 2, 3, table.getSelectionBackground());
                }
                this.setBorder(this.selectedBorder);
            } else {
                if (this.unselectedBorder == null) {
                    this.unselectedBorder = BorderFactory.createMatteBorder(2, 3, 2, 3, table.getBackground());
                }
                this.setBorder(this.unselectedBorder);
            }
            if (value == null) {
                this.setText("");
            } else {
                String code = (String)value;
                this.setForeground((Boolean)((FilterEditor)FilterEditor.this).model.data[row][9] != false ? Color.BLACK : Color.RED);
                this.setText(code);
            }
            return this;
        }
    }

    private class ColorEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private final ColorComboBox combo = new ColorComboBox(new Color[]{null, Color.RED, Color.GREEN, Color.BLUE, Color.BLACK}, new String[]{"None", "Red", "Green", "Blue", "Black"}, true);

        ColorEditor() {
        }

        @Override
        public Color getCellEditorValue() {
            return this.combo.getSelectedColor();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.combo.setSelectedColor((Color)value);
            return this.combo;
        }
    }

    private class ColorRenderer
    extends JLabel
    implements TableCellRenderer {
        Border unselectedBorder = null;
        Border selectedBorder = null;

        private ColorRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                if (this.selectedBorder == null) {
                    this.selectedBorder = BorderFactory.createMatteBorder(2, 3, 2, 3, table.getSelectionBackground());
                }
                this.setBorder(this.selectedBorder);
            } else {
                if (this.unselectedBorder == null) {
                    this.unselectedBorder = BorderFactory.createMatteBorder(2, 3, 2, 3, table.getBackground());
                }
                this.setBorder(this.unselectedBorder);
            }
            if (value != null) {
                this.setOpaque(true);
                this.setBackground((Color)value);
                this.setText("    ");
            } else {
                this.setOpaque(false);
                this.setText("None");
            }
            return this;
        }
    }

    private class MethodEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private final JComboBoxWithDisabledItems<TracerFilter.Method> combo = new JComboBoxWithDisabledItems();

        MethodEditor() {
            for (TracerFilter.Method m : TracerFilter.Method.values()) {
                this.combo.addItem((Object)m);
            }
        }

        @Override
        public Object getCellEditorValue() {
            return this.combo.getSelectedItem();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            EnumSet<TracerFilter.Method> tabu;
            TracerFilter.Target target = (TracerFilter.Target)((Object)table.getValueAt(row, 4));
            switch (target) {
                case OBJECT: {
                    tabu = EnumSet.noneOf(TracerFilter.Method.class);
                    break;
                }
                default: {
                    tabu = EnumSet.of(TracerFilter.Method.CLASS);
                }
            }
            this.combo.setDisabled(tabu);
            this.combo.setSelectedItem((Object)((TracerFilter.Method)((Object)value)));
            return this.combo;
        }
    }

    private class Table
    extends JTable {
        Table(TableModel model) {
            super(model);
        }

        @Override
        protected JTableHeader createDefaultTableHeader() {
            return new JTableHeader(this.columnModel){

                @Override
                public String getToolTipText(MouseEvent e) {
                    int index = this.columnModel.getColumnIndexAtX(e.getPoint().x);
                    int realIndex = this.columnModel.getColumn(index).getModelIndex();
                    return Table.this.getToolTip(realIndex);
                }
            };
        }

        String getToolTip(int column) {
            switch (column) {
                case 0: {
                    return "Check if this filter is a part of an OR group";
                }
                case 1: {
                    StringBuilder sb = new StringBuilder("<html><h3>Mode:</h3><dl>");
                    for (TracerFilter.Mode mode : TracerFilter.Mode.values()) {
                        sb.append("<dt>").append((Object)mode).append("</dt><dd>").append(mode.getToolTip()).append("</dd>");
                    }
                    return sb.append("</dl></html>").toString();
                }
                case 2: {
                    return "Check if this filter acceptance criteria should be inverted";
                }
                case 3: {
                    return "<html>Check if the target string produced by this filter should be saved and passed to subsequent filters</html>";
                }
                case 4: {
                    StringBuilder sb = new StringBuilder("<html><b>Target to which this filter should be applied:</b><dl>");
                    for (TracerFilter.Target target : TracerFilter.Target.values()) {
                        sb.append("<dt>").append((Object)target).append("</dt><dd>").append(target.getToolTip()).append("</dd>");
                    }
                    return sb.append("</dl></html>").toString();
                }
                case 5: {
                    StringBuilder sb = new StringBuilder("<html>Method that determines how the filter definition string is<br> interpreted to decide whether the target satisfies the filter.<dl>");
                    for (TracerFilter.Method method : TracerFilter.Method.values()) {
                        sb.append("<dt>").append((Object)method).append("</dt><dd>").append(method.getToolTip()).append("</dd>");
                    }
                    return sb.append("</dl></html>").toString();
                }
                case 6: {
                    return "Filter definition string";
                }
                case 7: {
                    return "Color to be assigned to messages that satisfy this filter.";
                }
                case 8: {
                    return "Flag to be added to messages that satisfy this filter.";
                }
            }
            return null;
        }
    }

    private class Model
    extends AbstractTableModel {
        Object[][] data;

        Model(MessageFilter filter) {
            if (filter == null) {
                this.data = new Object[1][];
                this.data[0] = this.makeRow(null);
            } else if (filter instanceof UserFilter) {
                UserFilter filterChain = (UserFilter)filter;
                this.data = new Object[filterChain.filters.length][];
                for (int i = 0; i < filterChain.filters.length; ++i) {
                    this.data[i] = this.makeRow(filterChain.filters[i]);
                    this.data[i][0] = filterChain.or[i];
                }
            } else {
                this.data = new Object[1][];
                this.data[0] = this.makeRow(filter);
            }
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return FilterEditor.this.columnClasses[columnIndex];
        }

        @Override
        public String getColumnName(int column) {
            return FilterEditor.this.columnNames[column];
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public int getColumnCount() {
            return FilterEditor.this.columnNames.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.data[rowIndex][columnIndex];
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            this.data[rowIndex][columnIndex] = aValue;
            if (columnIndex == 4 || columnIndex == 5 || columnIndex == 6) {
                boolean wasValid = (Boolean)this.data[rowIndex][9];
                try {
                    this.makeFilter(rowIndex);
                    this.data[rowIndex][9] = true;
                }
                catch (IllegalArgumentException x) {
                    this.data[rowIndex][9] = false;
                }
                if (wasValid != (Boolean)this.data[rowIndex][9]) {
                    this.fireTableRowsUpdated(rowIndex, rowIndex);
                    FilterEditor.this.validateTable();
                }
            }
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        void insertRow(int i) {
            Object[] row = this.makeRow(null);
            int n = this.data.length;
            Object[][] newData = new Object[n + 1][];
            System.arraycopy(this.data, 0, newData, 0, i);
            newData[i] = row;
            if (i != n) {
                System.arraycopy(this.data, i, newData, i + 1, n - i);
            }
            this.data = newData;
            this.fireTableRowsInserted(i, i);
        }

        void removeRows(int[] rows) {
            if (rows.length == 0) {
                return;
            }
            int n = this.data.length;
            Object[][] newData = new Object[n - rows.length][];
            Arrays.sort(rows);
            int s = 0;
            int t = 0;
            for (int r : rows) {
                int k = r - s;
                System.arraycopy(this.data, s, newData, t, k);
                s = r + 1;
                t += k;
            }
            if (s < n) {
                System.arraycopy(this.data, s, newData, t, n - s);
            }
            this.data = newData;
            this.fireTableRowsDeleted(rows[0], rows[rows.length - 1]);
            FilterEditor.this.validateTable();
        }

        private Object[] makeRow(MessageFilter filter) {
            if (filter == null) {
                return new Object[]{false, TracerFilter.Mode.ON, false, false, TracerFilter.Target.OBJECT, TracerFilter.Method.CONTAINS, "", null, null, true};
            }
            if (filter instanceof TracerFilter) {
                TracerFilter f = (TracerFilter)filter;
                Object[] row = new Object[FilterEditor.this.columnNames.length + 1];
                row[0] = false;
                row[1] = f.getMode();
                row[2] = f.isInverted();
                row[3] = f.isFormatting();
                row[4] = f.getTarget();
                row[5] = f.getMethod();
                row[6] = f.getCode();
                row[7] = f.getColor();
                row[8] = f.getAction();
                row[9] = true;
                return row;
            }
            String name = filter.getName();
            if (name == null) {
                name = "";
            }
            return new Object[]{false, TracerFilter.Mode.ON, false, false, TracerFilter.Target.OBJECT, TracerFilter.Method.FILTER, name, null, null, true};
        }

        private void move(int b1, int e1, int b2, int e2) {
            Object[][] newData = new Object[this.data.length][];
            System.arraycopy(this.data, 0, newData, 0, b1);
            int i = b1;
            int k = e2 - b2 + 1;
            System.arraycopy(this.data, b2, newData, i, k);
            i += k;
            k = e1 - b1 + 1;
            System.arraycopy(this.data, b1, newData, i, k);
            System.arraycopy(this.data, e2 + 1, newData, e2 + 1, this.data.length - 1 - e2);
            this.data = newData;
            this.fireTableRowsUpdated(b1, e2);
        }

        private UserFilter makeFilter() {
            int nSteps = this.data.length;
            if (nSteps == 0) {
                return null;
            }
            TracerFilter[] steps = new TracerFilter[nSteps];
            boolean[] ors = new boolean[nSteps];
            FilterRegistry registry = FilterEditor.this.plugin.getFilterRegistry();
            for (int i = 0; i < nSteps; ++i) {
                Object[] step = this.data[i];
                ors[i] = (Boolean)step[0];
                steps[i] = new TracerFilter((TracerFilter.Mode)((Object)step[1]), (Boolean)step[2], (Boolean)step[3], (TracerFilter.Target)((Object)step[4]), (TracerFilter.Method)((Object)step[5]), (String)step[6], (Color)step[7], (FilteredMessage.Flag)((Object)step[8]), registry);
            }
            return new UserFilter(FilterEditor.this.name, steps, ors);
        }

        private TracerFilter makeFilter(int row) {
            Object[] step = this.data[row];
            return new TracerFilter((TracerFilter.Mode)((Object)step[1]), (Boolean)step[2], (Boolean)step[3], (TracerFilter.Target)((Object)step[4]), (TracerFilter.Method)((Object)step[5]), (String)step[6], (Color)step[7], (FilteredMessage.Flag)((Object)step[8]), FilterEditor.this.plugin.getFilterRegistry());
        }
    }
}

