package org.lsst.ccs.gconsole.plugins.plots;

import hep.aida.IManagedObject;
import hep.aida.ref.tree.Tree;
import hep.aida.util.XMLUtils;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;
import org.freehep.application.studio.Studio;
import org.freehep.jas.extension.aida.AIDAPlugin;
import org.freehep.jas.plugin.tree.FTree;
import org.freehep.jas.plugin.tree.FTreeNode;
import org.freehep.jas.plugin.tree.FTreeNodeAddedNotification;
import org.freehep.jas.plugin.tree.FTreeNodeRemovedNotification;
import org.freehep.jas.plugin.tree.FTreePath;
import org.freehep.jas.plugin.tree.FTreeProvider;
import org.freehep.jas.services.PlotFactory;
import org.freehep.util.FreeHEPLookup;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.messaging.StatusMessageListener;

/**
 * Listen for alarms on the status bus, and if/when found popup an alarm dialog
 *
 * @author tonyj
 */
class PlotsListener implements StatusMessageListener {

    private final FreeHEPLookup lookup;
    private final Studio studio;
    private final PlotFactory plotFactory;
    private final FTreeProvider treeProvider;
    private final FTree tree;
    private final Tree masterTree;

    public PlotsListener(Studio studio) {
        this.studio = studio;
        lookup = studio.getLookup();
        plotFactory = (PlotFactory) lookup.lookup(PlotFactory.class);
        treeProvider = (FTreeProvider) lookup.lookup(FTreeProvider.class);
        tree = treeProvider.tree();
        masterTree = ((AIDAPlugin) lookup.lookup(AIDAPlugin.class)).aidaMasterTree();
    }

    @Override
    public void onStatusMessage(StatusMessage msg) {
        StatusSubsystemData plotsMsg = (StatusSubsystemData) msg;
        String source = msg.getOriginAgentInfo().getName();

        List<KeyValueData> plots = plotsMsg.getEncodedData().getListOfKeyValueData(KeyValueData.KeyValueDataType.KeyValuePlotData);
        if (tree != null) {

            for (KeyValueData d : plots) {
                String plot = (String) d.getValue();
                String key = d.getKey();
                String plotPath = source;
                if (!key.isEmpty()) {
                    plotPath += "/" + key;
                    plotPath = plotPath.replace("//", "/");
                }
                String dirPath = plotPath.substring(0, plotPath.lastIndexOf("/"));
                String plotName = plotPath.substring(plotPath.lastIndexOf("/")+1);
                try {
                    masterTree.find(dirPath);
                } catch (IllegalArgumentException e) {
                    masterTree.mkdirs(dirPath);
                }
                
                StringTokenizer st = new StringTokenizer(dirPath,"/");
                String[] treePath = new String[st.countTokens()+1];
                int count = 0;
                while ( st.hasMoreTokens() ) {
                    treePath[count++] = st.nextToken();
                }
                treePath[count] = plotName;

                FTreePath path = new FTreePath(treePath);
                FTreeNode node = tree.findNode(path);
                try {
                    IManagedObject obj = XMLUtils.createManagedObject(plot);
                    boolean removeNode = node != null;
                    try {
                        SwingUtilities.invokeAndWait(new Runnable() {
                            @Override
                            public void run() {
                                if (removeNode) {
                                    tree.treeChanged(new FTreeNodeRemovedNotification(studio, path));
                                }
                                tree.treeChanged(new FTreeNodeAddedNotification(studio, path, obj));
                            }

                        });

                    } catch (InterruptedException ie) {
                        throw new RuntimeException(ie);
                    } catch (InvocationTargetException ex) {
                        throw new RuntimeException(ex);
                    }
                } catch (IOException ioe) {
                    throw new RuntimeException("Could not create IManagedObject", ioe);
                }
            }
        }
    }

}
