package org.lsst.ccs.gconsole.plugins.elog;

import java.io.IOException;
import java.net.URL;
import org.freehep.application.studio.Plugin;
import org.freehep.application.studio.Studio;
import org.freehep.util.commanddispatcher.CommandProcessor;
import org.freehep.xml.menus.XMLMenuBuilder;
import org.xml.sax.SAXException;

/**
 * This plugin deals with creating postings to the LSST CCS ELog.
 * @author tonyj
 */
public class LsstELogPlugin extends Plugin {

    private Studio studio;

    
    @Override
    protected void init() throws SAXException, IOException {

        studio = getApplication();
        studio.getCommandTargetManager().add(new ELogCommands());

        XMLMenuBuilder builder = studio.getXMLMenuBuilder();
        URL xml = getClass().getResource("LsstELogPlugin.menus");
        builder.build(xml);
    }

    private void createELogDialog() {        
        studio.getPageManager().openPage(new LsstElogSubmissionDialog(), "LSST CCS Elog", null);
    }

    public class ELogCommands extends CommandProcessor {

        public void onLsstELog() {
            createELogDialog();
        }

    }
}
