
package org.lsst.ccs.gconsole.plugins.alert;

import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.RaisedAlertHistory;
import org.lsst.ccs.bus.data.RaisedAlertSummary;
import org.lsst.ccs.bus.states.AlertState;

/**
 * Definition of alert handling service.
 * Instances of classes implementing this interface can be registered with the
 * graphical console lookup.
 *
 * @author onoprien
 */
public interface AlertService {
    
    void submitAlert(String source, Alert alert, AlertState level);
    
    void addListener(AlertListener listener);
    
    void removeListener(AlertListener listener);
    
    RaisedAlertSummary getSummary(String source);
    
    default RaisedAlertHistory getHistory(String source, String alertID) {
        RaisedAlertSummary summary = getSummary(source);
        return summary == null ? null : summary.getRaisedAlert(alertID);
    }
    
}
