package org.lsst.ccs.gconsole.jas3;

import org.freehep.application.Application;
import org.freehep.application.studio.Plugin;
import org.freehep.application.studio.Studio;
import org.lsst.ccs.gconsole.Console;
import org.lsst.ccs.gconsole.ConsolePlugin;
import org.lsst.ccs.gconsole.ConsolePluginProvider;

/**
 * {@code ConsolePluginProvider} implementation based on {@code org.freehep.application.studio.Plugin}.
 *
 * @author onoprien
 */
public class PluginProvider extends Plugin implements ConsolePluginProvider {

// -- Fields : -----------------------------------------------------------------
    
    private final ConsolePlugin plugin;
    private final Jas3Console gConsole;

// -- Life cycle : -------------------------------------------------------------
    
    public PluginProvider(ConsolePlugin plugin) {
        gConsole = (Jas3Console) ((Studio)(Application.getApplication())).getLookup().lookup(Console.class);
        this.plugin = plugin;
    }
    
    @Override
    synchronized protected void init() throws Throwable {
        plugin.init();
    }

    @Override
    synchronized protected void postInit() {
        plugin.postInit();
    }

    @Override
    synchronized protected void applicationVisible() {
        plugin.applicationVisible();
    }

    @Override
    synchronized protected void shutdown() {
        plugin.shutdown();
    }


// -- Getters : ----------------------------------------------------------------
    
    @Override
    public Console getConsole() {
      return gConsole;
    }

}
