package org.lsst.ccs.gconsole.jas3;

import java.awt.Component;
import java.awt.Window;
import javax.swing.SwingUtilities;
import org.atteo.classindex.ClassIndex;
import org.freehep.application.Application;
import org.freehep.application.studio.Studio;
import org.freehep.util.FreeHEPLookup;
import org.lsst.ccs.gconsole.Console;
import org.lsst.ccs.gconsole.ConsolePluginProvider;

/**
 * Jas3-based Graphical Console implementation.
 * 
 * @author onoprien
 */
public class Jas3Console extends Console {
    
// -- Getters : ----------------------------------------------------------------
    
    @Override
    public FreeHEPLookup getLookup() {
        return getApplication().getLookup();
    }
    
    @Override
    @Deprecated
    public Studio getApplication() {
        return (Studio) Application.getApplication();
    }

    @Override
    public Window getWindow() {
        return SwingUtilities.getWindowAncestor(Application.getApplication());
    }
    
    
// -- Error reporting : --------------------------------------------------------
    
    @Override
    public void error(String message) {
        getApplication().error(message);
    }
    
    @Override
    public void error(String message, Exception x) {
        getApplication().error(message, x);
    }


// -- Testing : ----------------------------------------------------------------
    
    static public void main(String... args) {
        System.out.println("-- Plugins: \n");
        for (Class<? extends ConsolePluginProvider> x : ClassIndex.getSubclasses(ConsolePluginProvider.class)) {
            System.out.println("Class: "+ x.getName());
        }
    }
    
}
