package org.lsst.ccs.gconsole;

import org.atteo.classindex.IndexSubclasses;

/**
 * Base class for implementing {@link Console} plugins.
 *
 * @author onoprien
 */
@IndexSubclasses
abstract public class ConsolePlugin {
    
// -- Fields : -----------------------------------------------------------------
    
    private ConsolePluginProvider provider;


// -- Life cycle : -------------------------------------------------------------
    
    public final void setProvider(ConsolePluginProvider provider) {
        this.provider = provider;
    }

    public void init() throws Throwable {}

    public void postInit() {}

    public void applicationVisible() {}
    
    public void start() {}
    
    public void stop() {}

    public void shutdown() {}


// -- Getters : ----------------------------------------------------------------
    
    public Console getConsole() {
        return provider.getConsole();
    }

}
