package org.lsst.ccs.gconsole;

import java.awt.Window;
import org.freehep.application.studio.Studio;
import org.freehep.util.FreeHEPLookup;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;

/**
 * Base class for implementing Graphical Console subsystem.
 * 
 * @author onoprien
 */
abstract public class Console extends Subsystem {
    
// -- Construction : -----------------------------------------------------------
    
    protected Console() {
        super("CCS-Graphical-Console", AgentInfo.AgentType.CONSOLE);
    }
    
    
// -- Getters : ----------------------------------------------------------------
    
    abstract public FreeHEPLookup getLookup();
    
    @Deprecated
    abstract public Studio getApplication();

    /**
     * Returns the root component for the main Graphical Console window.
     * 
     * @return root component for the main Graphical Console window, or {@code null}
     *         if the root component is not a {@link Window}.
     */
    abstract public Window getWindow();
    
    
// -- Services : ---------------------------------------------------------------
    
    abstract public void error(String message);
    
    abstract public void error(String message, Exception x);
    
}
