/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.framework;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Resource;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.ConfigurationServiceException;
import org.lsst.ccs.framework.PackCst;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.utilities.structs.ViewValue;

public interface Configurable {
    public void setEnvironment(Environment var1);

    public Environment getEnvironment();

    default public Subsystem getSubsystem() {
        Optional<Subsystem> opt = this.getEnvironment().getSubsystem();
        if (opt.isPresent()) {
            return opt.get();
        }
        return null;
    }

    default public void init() {
        this.injectResources();
    }

    default public void start() {
    }

    default public void postStart() throws HardwareException {
    }

    default public void shutdownNow() {
    }

    default public String getName() {
        Environment env = this.getEnvironment();
        if (env != null) {
            return this.getEnvironment().getNameOfComponent();
        }
        return null;
    }

    default public void alias(String alias) {
        this.getEnvironment().alias(alias);
    }

    default public Object getComponentByName(String name) {
        return this.getEnvironment().getComponentByName(name);
    }

    default public <T> LinkedHashMap<String, T> getChildren(Class<T> clazz) {
        return this.getEnvironment().getChildren(clazz);
    }

    default public List<Configurable> listChildren() {
        return this.getEnvironment().listChildren();
    }

    default public Object getParentObject() {
        return this.getEnvironment().getParent().getValue();
    }

    default public Map.Entry<String, Object> getParent() {
        return this.getEnvironment().getParent();
    }

    default public String getFullPath() {
        Configurable parent = (Configurable)this.getParentObject();
        if (parent == null) {
            return this.getName();
        }
        return parent.getFullPath() + "/" + this.getName();
    }

    default public void injectResources() {
        Class<?> clazz = this.getClass();
        while (clazz.getCanonicalName().startsWith("org.lsst")) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                Resource resource = field.getAnnotation(Resource.class);
                if (resource == null) continue;
                String name = resource.name();
                if (name == null || "".equals(name)) {
                    name = field.getName();
                }
                Object toInject = this.getEnvironment().getComponentByName(name);
                if (name == null) {
                    PackCst.CURLOG.warn((Object)(this.getName() + " No possible injection for " + name));
                    continue;
                }
                try {
                    field.setAccessible(true);
                    field.set(this, toInject);
                    PackCst.CURLOG.info((Object)(toInject + " object injected in " + name + "field  "));
                }
                catch (IllegalAccessException e) {
                    PackCst.CURLOG.warn((Object)(this.getName() + " No possible injection for " + name), (Throwable)e);
                }
            }
            clazz = clazz.getSuperclass();
        }
    }

    @Command(description="engineering mode change of parameter value", type=Command.CommandType.CONFIGURATION)
    default public void change(@Argument(name="parameterName", description="Configuration parameter name") String parameterName, @Argument(name="value", description="Configuration parameter value") Object value) throws Exception {
        this.getEnvironment().change(parameterName, value);
    }

    @Command(description="submit a potential change for a parameter", type=Command.CommandType.CONFIGURATION)
    default public void submitChange(@Argument(name="parameterName", description="Configuration parameter name") String parameterName, @Argument(name="value", description="Configuration parameter value") Object value) {
        this.getEnvironment().submitChange(parameterName, value);
    }

    @Command(description="submit potential changes for parameters", type=Command.CommandType.CONFIGURATION)
    default public void submitChanges(Map<String, Object> values) {
        try {
            for (Map.Entry<String, Object> parameter : values.entrySet()) {
                this.submitChange(parameter.getKey(), parameter.getValue());
            }
        }
        catch (Exception ex) {
            this.getEnvironment().dropBulkChange();
            throw ex;
        }
    }

    default public void validateBulkChange(Map<String, Object> parametersView) {
    }

    default public Map<String, Object> setBulkParameter(Map<String, Object> parametersView) {
        return parametersView;
    }

    default public ViewValue getCheckedValueFromConfiguration(String parameterName, Object value) throws Exception {
        ViewValue data = this.getEnvironment().getCheckedValueFromConfiguration(parameterName, value);
        return data;
    }

    default public void notifyChangeWithoutPreliminaryChecks(String parameterName, Object value) throws Exception {
        this.getEnvironment().notifyChangeWithoutPreliminaryChecks(parameterName, value);
    }

    default public void notifyChange(String parameterName, String value) throws Exception {
        this.getEnvironment().notifyChange(parameterName, value);
    }

    default public void proceduralWalk(Consumer<Configurable> pre, Consumer<Configurable> post) {
        if (pre != null) {
            pre.accept(this);
        }
        for (Configurable child : this.listChildren()) {
            child.proceduralWalk(pre, post);
        }
        if (post != null) {
            post.accept(this);
        }
    }

    default public TreeWalkerDiag treeWalk(Function<Configurable, TreeWalkerDiag> func, Consumer<Configurable> post) {
        TreeWalkerDiag diag = TreeWalkerDiag.GO;
        if (func != null) {
            diag = func.apply(this);
        }
        switch (diag) {
            case STOP: {
                return diag;
            }
            case HANDLING_CHILDREN: {
                return diag;
            }
        }
        for (Configurable child : this.listChildren()) {
            TreeWalkerDiag childRes = child.treeWalk(func, post);
            if (!childRes.equals((Object)TreeWalkerDiag.STOP)) continue;
            return childRes;
        }
        if (post != null) {
            post.accept(this);
        }
        return diag;
    }

    public static interface Environment {
        public void change(String var1, Object var2) throws Exception;

        public void submitChange(String var1, Object var2);

        @Deprecated
        public void register(String var1) throws ConfigurationServiceException;

        @Deprecated
        public void saveConfiguration() throws ConfigurationServiceException;

        @Deprecated
        public void saveConfiguration(String var1) throws ConfigurationServiceException;

        public void saveAllChanges() throws ConfigurationServiceException;

        public void saveChangesForCategories(String ... var1) throws ConfigurationServiceException;

        public void saveChangesForCategoriesAs(String ... var1) throws ConfigurationServiceException;

        public void dropAllChanges() throws Exception;

        public void dropChangesForCategories(String ... var1) throws Exception;

        public ViewValue getCheckedValueFromConfiguration(String var1, Object var2) throws Exception;

        public void notifyChangeWithoutPreliminaryChecks(String var1, Object var2) throws Exception;

        public void notifyChange(String var1, String var2) throws Exception;

        public Object getComponentByName(String var1);

        public void alias(String var1);

        public <T> LinkedHashMap<String, T> getChildren(Class<T> var1);

        public List<Configurable> listChildren();

        public Map.Entry<String, Object> getParent();

        public String getNameOfComponent();

        public Object getRelevantObject();

        @Deprecated
        public Map<String, Method> getConfigMethodsOfComponent();

        public Method getConfigMethodOfComponent(String var1);

        public Optional<Subsystem> getSubsystem();

        public void dropBulkChange();
    }
}

