/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.lsst.ccs.bus.messages.CommandAck;
import org.lsst.ccs.bus.messages.CommandNack;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.CommandResult;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.BusMessageFilter;
import org.lsst.ccs.messaging.CommandOriginator;
import org.lsst.ccs.messaging.CommandRejectedException;
import org.lsst.ccs.messaging.StatusMessageListener;

public class ConcurrentMessagingUtils {
    private final AgentMessagingLayer agentMessagingLayer;
    private static final Object NULL = new Object();

    public ConcurrentMessagingUtils(AgentMessagingLayer agentMessagingLayer) {
        this.agentMessagingLayer = agentMessagingLayer;
    }

    public Object sendSynchronousCommand(CommandRequest command, long millisTimeout) throws Exception {
        return this.invokeIt(false, command, millisTimeout);
    }

    public Future<Object> sendAsynchronousCommand(CommandRequest command) {
        LinkedCommandOriginator commandOriginator = new LinkedCommandOriginator(false, this.agentMessagingLayer);
        LinkedFuture<Object> linkedFuture = new LinkedFuture<Object>(commandOriginator, false);
        this.agentMessagingLayer.sendCommandRequest(command, commandOriginator);
        return linkedFuture;
    }

    public Object getAckForCommand(CommandRequest command, long millisTimeout) throws Exception {
        return this.invokeIt(true, command, millisTimeout);
    }

    private Object invokeIt(boolean ackOnly, CommandRequest command, long millisTimeout) throws Exception {
        LinkedCommandOriginator commandOriginator = new LinkedCommandOriginator(ackOnly, this.agentMessagingLayer);
        LinkedFuture<Object> linkedFuture = new LinkedFuture<Object>(commandOriginator, false);
        this.agentMessagingLayer.sendCommandRequest(command, commandOriginator);
        Object res = null;
        res = linkedFuture.get(millisTimeout, TimeUnit.MILLISECONDS);
        if (res instanceof Exception) {
            throw (Exception)res;
        }
        return res;
    }

    public Future<StatusMessage> startListeningForStatusBusMessage(BusMessageFilter filter, long timeout) {
        LinkedStatusBusListener innerListener = new LinkedStatusBusListener(filter, timeout, this.agentMessagingLayer);
        LinkedFuture<StatusMessage> future = new LinkedFuture<StatusMessage>(innerListener, true);
        this.agentMessagingLayer.addStatusMessageListener(innerListener, filter);
        return future;
    }

    public Future<StatusMessage> startListeningForStatusBusMessage(BusMessageFilter filter) {
        return this.startListeningForStatusBusMessage(filter, -1L);
    }

    class LinkedFuture<T>
    implements Future<T> {
        private final LinkedTransferQueue<Object> queue = new LinkedTransferQueue();
        private final LinkedTask<T> task;
        private boolean isCancelled = false;
        private final boolean throwException;

        LinkedFuture(LinkedTask<T> task, boolean throwException) {
            this.task = task;
            this.throwException = throwException;
            this.init();
        }

        private void init() {
            this.task.setLinkedFuture(this);
        }

        @Override
        public boolean isCancelled() {
            return this.isCancelled;
        }

        @Override
        public boolean isDone() {
            return !this.queue.isEmpty();
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (!this.isCancelled) {
                this.task.cancel();
                this.isCancelled = true;
            }
            return true;
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            return this.processReply(this.queue.take());
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            Object reply = this.queue.poll(timeout, unit);
            if (reply == null) {
                throw new TimeoutException("Could not get reply within the specified timeout of " + timeout + " " + unit.toString());
            }
            return this.processReply(reply);
        }

        private T processReply(Object reply) throws InterruptedException, ExecutionException {
            if (reply instanceof Exception && this.throwException) {
                throw new ExecutionException("Execution Exception", (Exception)reply);
            }
            return (T)(reply != NULL ? reply : null);
        }

        void addToQueue(Object obj) {
            if (obj == null) {
                obj = NULL;
            }
            this.queue.offer(obj);
            this.task.stop();
        }
    }

    abstract class LinkedTask<T> {
        LinkedFuture<T> future = null;

        LinkedTask() {
        }

        public abstract void cancel();

        public abstract void start();

        public abstract void stop();

        void setLinkedFuture(LinkedFuture<T> future) {
            this.future = future;
            this.start();
        }

        LinkedFuture<T> getLinkedFuture() {
            return this.future;
        }
    }

    private class LinkedCommandOriginator
    extends LinkedTask<Object>
    implements CommandOriginator {
        private final boolean getAckOnly;

        LinkedCommandOriginator(boolean ackOnly, AgentMessagingLayer agentMessagingLayer) {
            this.getAckOnly = ackOnly;
        }

        @Override
        public void cancel() {
        }

        @Override
        public void start() {
        }

        @Override
        public void stop() {
        }

        @Override
        public void processNack(CommandNack nack) {
            CommandRejectedException rejection = new CommandRejectedException(nack);
            this.getLinkedFuture().addToQueue(rejection);
        }

        @Override
        public void processResult(CommandResult result) {
            Object resultContent;
            if (this.getAckOnly) {
                return;
            }
            try {
                resultContent = result.getResult();
            }
            catch (Exception e) {
                resultContent = result.getEncodedData();
            }
            this.getLinkedFuture().addToQueue(resultContent);
        }

        @Override
        public void processAck(CommandAck ack) {
            if (this.getAckOnly) {
                this.getLinkedFuture().addToQueue(ack);
            }
        }
    }

    class LinkedStatusBusListener
    extends LinkedTask<StatusMessage>
    implements StatusMessageListener {
        private final BusMessageFilter filter;
        private final Timer timeoutTimer = new Timer("LinkedStatusBusListener");
        private boolean cleanedUp = false;
        private final AgentMessagingLayer agentMessagingLayer;
        private final long timeout;

        LinkedStatusBusListener(BusMessageFilter filter, long timeout, AgentMessagingLayer agentMessagingLayer) {
            this.filter = filter;
            this.agentMessagingLayer = agentMessagingLayer;
            this.timeout = timeout;
        }

        @Override
        public void start() {
            if (this.timeout > 0L) {
                this.timeoutTimer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        this.cancel();
                        TimeoutException ex = new TimeoutException("Timeout listening for filtered events " + LinkedStatusBusListener.this.filter.toString());
                        LinkedStatusBusListener.this.getLinkedFuture().addToQueue(ex);
                    }
                }, this.timeout);
            }
        }

        @Override
        public void stop() {
            this.cancel();
        }

        @Override
        public void cancel() {
            if (!this.cleanedUp) {
                this.agentMessagingLayer.removeStatusMessageListener(this);
                this.cleanedUp = true;
            }
        }

        @Override
        public void onStatusMessage(StatusMessage bm) {
            if (!this.getLinkedFuture().isDone()) {
                this.timeoutTimer.cancel();
                this.getLinkedFuture().addToQueue(bm);
            }
        }
    }
}

