/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import org.lsst.ccs.config.AParameterConfiguration;
import org.lsst.ccs.config.GhostParameterDescription;
import org.lsst.ccs.config.ParameterConfiguration;
import org.lsst.ccs.config.ParameterDescription;
import org.lsst.ccs.config.PastValueEvent;
import org.lsst.ccs.config.ValueEvent;

@Entity
class PastParameterConfiguration
extends ParameterConfiguration {
    private static final long serialVersionUID = 1648990234116895047L;
    @Id
    private long id;
    @ManyToOne
    private GhostParameterDescription parameterDescription;
    @OneToMany(cascade={CascadeType.PERSIST}, fetch=FetchType.EAGER)
    private List<PastValueEvent> valueEvents;

    PastParameterConfiguration() {
    }

    PastParameterConfiguration(GhostParameterDescription ghostDescription, AParameterConfiguration oldConfig) {
        super(oldConfig.getConfiguredValue());
        if (oldConfig.getId() == 0L) {
            throw new IllegalArgumentException("trying to create historical data with a non-registered object");
        }
        if (ghostDescription.getId() != oldConfig.getDescription().getId()) {
            throw new IllegalArgumentException("description and its ghost with different ids");
        }
        this.id = oldConfig.getId();
        this.parameterDescription = ghostDescription;
        List<? extends ValueEvent> listEvents = oldConfig.getValueEvents();
        if (listEvents != null) {
            int size = listEvents.size();
            ArrayList<PastValueEvent> newList = new ArrayList<PastValueEvent>(size);
            for (ValueEvent valueEvent : listEvents) {
                newList.add(new PastValueEvent(valueEvent));
            }
            this.setValueEvents(newList);
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    protected void setId(long id) {
        this.id = id;
    }

    @Override
    public ParameterDescription getDescription() {
        return this.parameterDescription;
    }

    @Override
    public List<? extends ValueEvent> getValueEvents() {
        return this.valueEvents;
    }

    void setValueEvents(List<PastValueEvent> valueEventList) {
        if (valueEventList != null) {
            this.valueEvents = Collections.unmodifiableList(valueEventList);
        }
    }

    GhostParameterDescription getParameterDescription() {
        return this.parameterDescription;
    }

    void setParameterDescription(GhostParameterDescription parameterDescription) {
        this.parameterDescription = parameterDescription;
    }
}

