/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import org.lsst.ccs.config.AConfigProfile;
import org.lsst.ccs.config.AParameterConfiguration;
import org.lsst.ccs.config.AParameterDescription;
import org.lsst.ccs.config.ASubsystemDescription;
import org.lsst.ccs.config.ConfigProfile;
import org.lsst.ccs.config.DBInterface;
import org.lsst.ccs.config.DeprecationListener;
import org.lsst.ccs.config.GhostSubsystemDescription;
import org.lsst.ccs.config.PackCst;
import org.lsst.ccs.config.ParameterConfiguration;
import org.lsst.ccs.config.PastConfigProfile;
import org.lsst.ccs.config.PersistenceLayerException;
import org.lsst.ccs.config.RunHistory;
import org.lsst.ccs.config.SubsystemDescription;
import org.lsst.ccs.utilities.exc.BundledException;
import org.lsst.ccs.utilities.exc.ThrowableList;

public class ConfigurationFacade {
    private DBInterface dao;
    private DeprecationListener deprecationListener;
    private static final Integer ZERO = 0;
    ThreadLocal<Integer> stackState = new ThreadLocal<Integer>(){

        @Override
        public Integer initialValue() {
            return ZERO;
        }
    };
    ReentrantLock lock = new ReentrantLock(true);

    public ConfigurationFacade(DBInterface dao) {
        this.dao = dao;
    }

    public void setDeprecationListener(DeprecationListener deprecationListener) {
        this.deprecationListener = deprecationListener;
    }

    synchronized void push() {
        Integer level = this.stackState.get();
        if (level == ZERO) {
            this.lock.lock();
            this.dao.begin();
        }
        this.stackState.set(level + 1);
    }

    synchronized void pop() {
        Integer level = this.stackState.get();
        if (level == ZERO) {
            throw new IllegalStateException("dao transaction stack empty");
        }
        Integer n = level;
        Integer n2 = level = Integer.valueOf(level - 1);
        this.stackState.set(level);
        if (level == ZERO) {
            this.dao.end();
            this.lock.unlock();
        }
    }

    synchronized PersistenceLayerException failNThrow(Exception exc) {
        PackCst.CURLOG.log(Level.SEVERE, "", (Throwable)exc);
        Integer level = this.stackState.get();
        if (level == ZERO) {
            throw new IllegalStateException("dao transaction stack empty");
        }
        Integer n = level;
        Integer n2 = level = Integer.valueOf(level - 1);
        this.stackState.set(level);
        if (level == ZERO) {
            if (exc instanceof PersistenceLayerException) {
                this.dao.fail(exc.getCause());
            } else {
                this.dao.fail(exc);
            }
            this.lock.unlock();
        }
        if (exc instanceof PersistenceLayerException) {
            return (PersistenceLayerException)exc;
        }
        return new PersistenceLayerException(exc);
    }

    public SubsystemDescription registerSubsystemDescription(SubsystemDescription newDescription, Profiles results) throws PersistenceLayerException {
        if (!(newDescription instanceof ASubsystemDescription)) {
            throw new IllegalArgumentException("not a new description");
        }
        Objects.requireNonNull(results);
        return this.registerSubsystemDescription((ASubsystemDescription)newDescription, results);
    }

    @Deprecated
    public SubsystemDescription registerSubsystemDescription(SubsystemDescription newDescription) throws PersistenceLayerException {
        if (!(newDescription instanceof ASubsystemDescription)) {
            throw new IllegalArgumentException("not a new description");
        }
        return this.registerSubsystemDescription((ASubsystemDescription)newDescription, new Profiles());
    }

    SubsystemDescription registerSubsystemDescription(ASubsystemDescription newDescription, Profiles results) throws PersistenceLayerException {
        String subsystemName = newDescription.getSubsystemName();
        String tag = newDescription.getTag();
        SubsystemDescription previous = null;
        this.push();
        try {
            ASubsystemDescription oldOne = this.dao.getActiveSubsystemDescription(subsystemName, tag);
            long previousDescriptionID = 0L;
            if (oldOne != null) {
                if (oldOne.getId() == newDescription.getId()) {
                    PackCst.CURLOG.warning((Object)"trying to save an existing subsystem description : doing nothing");
                    this.pop();
                    return newDescription;
                }
                previous = this.deprecateSubsystemDescription(oldOne, results);
                previousDescriptionID = previous.getId();
                newDescription.setPreviousDescriptionID(previousDescriptionID);
            }
            this.dao.saveSubsystemDescription(newDescription);
            ASubsystemDescription registered = this.dao.getActiveSubsystemDescription(subsystemName, tag);
            GhostSubsystemDescription ghost = new GhostSubsystemDescription(registered);
            this.dao.saveGhostDescriptions(ghost);
            for (String category : newDescription.getCategorySet()) {
                AConfigProfile defaultProfile = new AConfigProfile(newDescription, 10, category, "");
                this.registerConfigProfile(defaultProfile);
                results.addRegistered(defaultProfile);
            }
            this.pop();
            ASubsystemDescription res = newDescription.clone();
            return res;
        }
        catch (Exception exc) {
            throw this.failNThrow(exc);
        }
    }

    SubsystemDescription deprecateSubsystemDescription(ASubsystemDescription currentDescriptionInDB, Profiles results) {
        this.push();
        GhostSubsystemDescription ghost = this.dao.getGhostDescription(currentDescriptionInDB.getId());
        long endDate = System.currentTimeMillis();
        ghost.setEndTimestamp(endDate);
        currentDescriptionInDB.setEndTimestamp(endDate);
        Collection<AConfigProfile> profiles = this.dao.getActiveProfilesForSubsystem(currentDescriptionInDB);
        for (AConfigProfile profile : profiles) {
            ConfigProfile deprecated = this.deprecateConfigProfile(ghost, profile);
            if ("".equals(deprecated.getName())) continue;
            results.addNotRegistered(deprecated);
        }
        if (this.deprecationListener != null) {
            this.deprecationListener.subsystemDeprecating(ghost);
        }
        this.dao.deleteActiveSubsystemDescription(currentDescriptionInDB);
        this.pop();
        return ghost;
    }

    public SubsystemDescription deprecateSubsystemDescription(String subsystemName, String tag, Profiles results) throws PersistenceLayerException {
        if (tag == null) {
            tag = "";
        }
        this.push();
        try {
            SubsystemDescription res = null;
            ASubsystemDescription oldOne = this.dao.getActiveSubsystemDescription(subsystemName, tag);
            if (oldOne != null) {
                res = this.deprecateSubsystemDescription(oldOne, results);
            }
            this.pop();
            return res;
        }
        catch (Exception exc) {
            throw this.failNThrow(exc);
        }
    }

    @Deprecated
    public SubsystemDescription deprecateSubsystemDescription(String subsystemName, String tag) throws PersistenceLayerException {
        this.push();
        try {
            SubsystemDescription res = null;
            ASubsystemDescription oldOne = this.dao.getActiveSubsystemDescription(subsystemName, tag);
            if (oldOne != null) {
                res = this.deprecateSubsystemDescription(oldOne, new Profiles());
            }
            this.pop();
            return res;
        }
        catch (Exception exc) {
            throw this.failNThrow(exc);
        }
    }

    public SubsystemDescription getActiveSubsystemDescription(String name, String tag) throws PersistenceLayerException {
        this.push();
        try {
            ASubsystemDescription res = this.dao.getActiveSubsystemDescription(name, tag);
            this.pop();
            return res;
        }
        catch (Exception exc) {
            throw this.failNThrow(exc);
        }
    }

    public ConfigProfile registerConfigProfile(ConfigProfile newProfile) throws PersistenceLayerException {
        if (!(newProfile instanceof AConfigProfile)) {
            throw new IllegalArgumentException("deprecated Profile");
        }
        return this.registerConfigProfile((AConfigProfile)newProfile);
    }

    ConfigProfile registerConfigProfile(AConfigProfile newProfile) throws PersistenceLayerException {
        this.push();
        try {
            long idSubs;
            ASubsystemDescription registered;
            ConfigProfile previous = null;
            long previousConfigID = 0L;
            String subsystemName = newProfile.getSubsystemName();
            String name = newProfile.getName();
            String tag = newProfile.getTag();
            AConfigProfile oldProfile = (AConfigProfile)this.getActiveConfigProfile(subsystemName, name, tag);
            if (oldProfile != null) {
                if (oldProfile.getId() == newProfile.getId()) {
                    PackCst.CURLOG.warning((Object)"trying to save an existing Config profile : doing nothing");
                    this.pop();
                    return newProfile;
                }
                if (!newProfile.getSubsystemName().equals(oldProfile.getSubsystemName())) {
                    throw new IllegalArgumentException("Name clash :  trying to create a configProfile with same name and different subsystem " + name + "/" + tag + " already exists for subsystem " + oldProfile.getSubsystemName());
                }
                GhostSubsystemDescription ghost = this.dao.getGhostDescription(oldProfile.getSubsystemId());
                previous = this.deprecateConfigProfile(ghost, oldProfile);
                previousConfigID = previous.getId();
                newProfile.setPreviousConfigID(previousConfigID);
            }
            if ((registered = this.dao.getActiveSubsystemDescription(idSubs = newProfile.getSubsystemId())) == null) {
                throw new IllegalArgumentException(" No such living subsystem description in database " + newProfile.getSubsystemDescription());
            }
            this.dao.saveConfigProfile(newProfile);
            this.pop();
            return newProfile.clone();
        }
        catch (Exception exc) {
            throw this.failNThrow(exc);
        }
    }

    ConfigProfile deprecateConfigProfile(GhostSubsystemDescription ghost, AConfigProfile currentProfileInDB) {
        this.push();
        PastConfigProfile past = new PastConfigProfile(ghost, currentProfileInDB);
        this.dao.savePastProfile(past);
        if (this.deprecationListener != null) {
            this.deprecationListener.configProfileDeprecating(past);
        }
        this.dao.deleteActiveConfigProfile(currentProfileInDB);
        this.pop();
        return past;
    }

    public ConfigProfile deprecateConfigProfile(String subsystemName, String name, String tag) throws PersistenceLayerException {
        this.push();
        try {
            ConfigProfile res = null;
            AConfigProfile currentProfile = (AConfigProfile)this.getActiveConfigProfile(subsystemName, name, tag);
            if (currentProfile != null) {
                GhostSubsystemDescription ghost = this.dao.getGhostDescription(currentProfile.getSubsystemId());
                res = this.deprecateConfigProfile(ghost, currentProfile);
            }
            this.pop();
            return res;
        }
        catch (Exception exc) {
            throw this.failNThrow(exc);
        }
    }

    public ConfigProfile getActiveConfigProfile(String subsystemName, String name, String tag) throws PersistenceLayerException {
        this.push();
        try {
            AConfigProfile res = this.dao.getActiveConfigProfile(subsystemName, name, tag);
            this.pop();
            return res;
        }
        catch (Exception exc) {
            throw this.failNThrow(exc);
        }
    }

    public ParameterConfiguration modifyParmDuringEngineering(ConfigProfile profile, String path, long timeStamp, String value) throws PersistenceLayerException {
        if (!(profile instanceof AConfigProfile)) {
            throw new IllegalArgumentException(" profile not regsitered in database");
        }
        AParameterConfiguration parmConf = (AParameterConfiguration)profile.temporaryChangeConfigurationValue(path, timeStamp, value, true);
        parmConf = (AParameterConfiguration)this.engineerParmConfig(parmConf);
        return parmConf;
    }

    public ParameterConfiguration engineerParmConfig(ParameterConfiguration parameterConfiguration) throws PersistenceLayerException {
        if (!(parameterConfiguration instanceof AParameterConfiguration)) {
            throw new IllegalArgumentException("not a registered active  parameterConfiguraiton");
        }
        AParameterConfiguration config = (AParameterConfiguration)parameterConfiguration;
        if (config.getId() == 0L) {
            throw new IllegalArgumentException("not a registered parameterConfiguraiton");
        }
        this.push();
        try {
            this.dao.modifyParmConfig(config);
            this.pop();
            return config;
        }
        catch (Exception exc) {
            throw this.failNThrow(exc);
        }
    }

    public void registerRun(String subsystemName, String configName, String tag, long startTime) throws PersistenceLayerException {
        this.push();
        try {
            List<?> list = this.dao.simpleHQLRequest("from RunHistory where subsystemName = '" + subsystemName + "' and timeNext = 0");
            if (list.size() != 0) {
                if (list.size() > 1) {
                    PackCst.CURLOG.warning((Object)"multiple runs with no next run!");
                }
                RunHistory previousRun = (RunHistory)list.get(0);
                previousRun.setTimeNext(startTime);
                if (previousRun.getEndTimestampLimit() == PackCst.STILL_VALID) {
                    previousRun.setEndTimestampLimit(startTime - 1L);
                    previousRun.setEndGuessed(true);
                }
            }
            RunHistory run = new RunHistory(subsystemName, configName, tag, startTime);
            this.dao.saveRun(run);
            this.pop();
        }
        catch (Exception exc) {
            throw this.failNThrow(exc);
        }
    }

    public void endRun(String subsystemName, String configName, String tag, long endTime) throws PersistenceLayerException {
        this.push();
        if (configName == null) {
            configName = "";
        }
        if (tag == null) {
            tag = "";
        }
        try {
            List<?> list = this.dao.simpleHQLRequest("from RunHistory where subsystemName = '" + subsystemName + "' and endTimestampLimit = " + PackCst.STILL_VALID);
            if (list.size() == 0) {
                list = this.dao.simpleHQLRequest("from RunHistory where subsystemName = '" + subsystemName + "' and timeNext = 0");
                if (list.size() != 0) {
                    if (list.size() > 1) {
                        PackCst.CURLOG.warning((Object)"multiple runs with no next run!");
                    }
                    RunHistory previousRun = (RunHistory)list.get(0);
                    long previousEnd = previousRun.getEndTimestampLimit();
                    long fakeStart = previousEnd + 1L;
                    previousRun.setTimeNext(fakeStart);
                    RunHistory run = new RunHistory(subsystemName, configName, tag, fakeStart);
                    run.setStartGuessed(true);
                    run.setEndTimestampLimit(endTime);
                    this.dao.saveRun(run);
                }
            } else {
                for (RunHistory run : list) {
                    String runTagName;
                    String runConfigName = run.getConfigurationName();
                    if (runConfigName == null) {
                        runConfigName = "";
                    }
                    if ((runTagName = run.getTag()) == null) {
                        runTagName = "";
                    }
                    if (runConfigName.equals(configName) && runTagName.equals(tag)) {
                        run.setEndTimestampLimit(endTime);
                        continue;
                    }
                    PackCst.CURLOG.log(Level.WARNING, "run with no end date", (Object)run);
                }
            }
            this.pop();
        }
        catch (Exception exc) {
            throw this.failNThrow(exc);
        }
    }

    public ConfigProfile getConfigRunningAt(String subsystemName, long date) throws PersistenceLayerException {
        this.push();
        try {
            List<?> listRun = this.dao.simpleHQLRequest("from RunHistory where subsystemName = '" + subsystemName + "' and startTimeStamp < " + date + " and endTimeStampLimit > " + date + " ");
            int numberRuns = listRun.size();
            if (numberRuns != 0) {
                if (numberRuns > 1) {
                    PackCst.CURLOG.log(Level.WARNING, "multiple runs in same time span", listRun);
                    Collections.sort(listRun, new Comparator(){

                        public int compare(Object o, Object o1) {
                            Long longA = ((RunHistory)o).getStartTimestamp();
                            Long longB = ((RunHistory)o1).getStartTimestamp();
                            return longA.compareTo(longB);
                        }
                    });
                }
                RunHistory lastRun = (RunHistory)listRun.get(numberRuns - 1);
                ConfigProfile res = this.getConfigValidAt(subsystemName, lastRun.getConfigurationName(), lastRun.getTag(), date);
                this.pop();
                return res;
            }
            this.pop();
            return null;
        }
        catch (Exception exc) {
            throw this.failNThrow(exc);
        }
    }

    public ConfigProfile getConfigValidAt(String subsystemName, String configName, String configTag, long date) throws PersistenceLayerException {
        Objects.requireNonNull(subsystemName);
        Objects.requireNonNull(configName);
        Objects.requireNonNull(configTag);
        this.push();
        try {
            List<?> list = this.dao.simpleHQLRequest("from AConfigProfile where subsystemName  = '" + subsystemName + "' and name ='" + configName + "' and tag ='" + configTag + "' and startTimestamp <= " + date + " ");
            if (list.size() != 0) {
                this.pop();
                return (ConfigProfile)list.get(0);
            }
            list = this.dao.simpleHQLRequest("from PastConfigProfile where subsystemName = '" + subsystemName + "' and name ='" + configName + "' and tag ='" + configTag + "' and startTimestamp <= " + date + " and endTimestamp >= " + date + " ");
            if (list.size() != 0) {
                this.pop();
                return (ConfigProfile)list.get(0);
            }
            this.pop();
            return null;
        }
        catch (Exception exc) {
            throw this.failNThrow(exc);
        }
    }

    public String getActiveValueAt(String subsystemName, String parameterPath, long date) throws PersistenceLayerException {
        ConfigProfile profile = this.getConfigRunningAt(subsystemName, date);
        if (profile == null) {
            PackCst.CURLOG.warning((Object)("no running profile at " + new Date(date) + "for subsystem " + subsystemName));
            return null;
        }
        return profile.getValueAt(parameterPath, date);
    }

    public String getValueValidAt(String subsystemName, String profileName, String profileTag, String parameterPath, long date) throws PersistenceLayerException {
        ConfigProfile profile = this.getConfigValidAt(subsystemName, profileName, profileTag, date);
        return profile.getValueAt(parameterPath, date);
    }

    public ConfigProfile getPrevious(ConfigProfile current) throws PersistenceLayerException {
        if (current == null) {
            return null;
        }
        long id = current.getPreviousConfigID();
        if (0L == id) {
            return null;
        }
        this.push();
        try {
            ConfigProfile res = null;
            List<?> list = this.dao.simpleHQLRequest("from PastConfigProfile where id = '" + id + "'");
            if (list.size() != 0) {
                res = (ConfigProfile)list.get(0);
            }
            this.pop();
            return res;
        }
        catch (Exception exc) {
            throw this.failNThrow(exc);
        }
    }

    public ConfigProfile getNext(ConfigProfile current) throws PersistenceLayerException {
        if (current == null) {
            return null;
        }
        long id = current.getId();
        if (0L == id) {
            return null;
        }
        this.push();
        try {
            ConfigProfile res = null;
            List<?> list = this.dao.simpleHQLRequest("from AConfigProfile where previousConfigID = '" + id + "'");
            if (list.size() != 0) {
                res = (ConfigProfile)list.get(0);
            } else {
                list = this.dao.simpleHQLRequest("from PastConfigProfile where previousConfigID = '" + id + "'");
                if (list.size() != 0) {
                    res = (ConfigProfile)list.get(0);
                }
            }
            this.pop();
            return res;
        }
        catch (Exception exc) {
            throw this.failNThrow(exc);
        }
    }

    public SubsystemDescription getPrevious(SubsystemDescription current) throws PersistenceLayerException {
        if (current == null) {
            return null;
        }
        long id = current.getPreviousDescriptionID();
        if (0L == id) {
            return null;
        }
        this.push();
        try {
            SubsystemDescription res = null;
            List<?> list = this.dao.simpleHQLRequest("from GhostSubsystemDescription where id = '" + id + "'");
            if (list.size() != 0) {
                res = (SubsystemDescription)list.get(0);
            }
            this.pop();
            return res;
        }
        catch (Exception exc) {
            throw this.failNThrow(exc);
        }
    }

    public Profiles repair(SubsystemDescription description, Profiles requestedProfiles) {
        if (!(description instanceof ASubsystemDescription)) {
            throw new IllegalArgumentException("no way to repair on  description not managed by databse");
        }
        ASubsystemDescription currentDescription = (ASubsystemDescription)description;
        Profiles res = new Profiles();
        for (ConfigProfile oldProfile : requestedProfiles.getNotRegistered()) {
            AConfigProfile newProfile = new AConfigProfile(currentDescription, oldProfile.getLevel(), oldProfile.getCategoryName(), oldProfile.getConfigName());
            boolean inError = false;
            for (ParameterConfiguration parameterConfiguration : oldProfile.getModifiedParameters()) {
                String oldValue = parameterConfiguration.getConfiguredValue();
                AParameterDescription parmDesc = (AParameterDescription)currentDescription.fetch(parameterConfiguration);
                if (parmDesc == null) {
                    parameterConfiguration.setReConfigurationFailure(new IllegalArgumentException("no parameter with path: " + parmDesc.getPath()));
                    inError = true;
                    continue;
                }
                try {
                    AParameterConfiguration newParmConfig = new AParameterConfiguration(parmDesc, oldValue, true);
                    newProfile.addParameterConfigurations(newParmConfig);
                }
                catch (Exception exc) {
                    inError = true;
                    parameterConfiguration.setReConfigurationFailure(exc);
                }
            }
            if (inError) {
                res.addNotRegistered(oldProfile);
                continue;
            }
            try {
                this.registerConfigProfile(newProfile);
                res.addRegistered(newProfile);
            }
            catch (Exception exc) {
                res.registrationExceptions = new BundledException((Throwable)exc, (ThrowableList)res.registrationExceptions);
                res.addNotRegistered(newProfile);
            }
        }
        return res;
    }

    public List<?> simpleHQLRequest(String hqlString) throws PersistenceLayerException {
        this.push();
        try {
            List<?> res = this.dao.simpleHQLRequest(hqlString);
            this.pop();
            return res;
        }
        catch (Exception exc) {
            throw this.failNThrow(exc);
        }
    }

    public static class Profiles
    implements Serializable {
        final List<ConfigProfile> registered = new ArrayList<ConfigProfile>();
        final List<ConfigProfile> notRegistered = new ArrayList<ConfigProfile>();
        BundledException registrationExceptions;

        public List<ConfigProfile> getRegistered() {
            return this.registered;
        }

        public List<ConfigProfile> getNotRegistered() {
            return this.notRegistered;
        }

        public BundledException getRegistrationExceptions() {
            return this.registrationExceptions;
        }

        public void addRegistered(ConfigProfile conf) {
            this.registered.add(conf);
        }

        public void addNotRegistered(ConfigProfile conf) {
            this.notRegistered.add(conf);
        }

        public boolean hasUnRegisteredProfiles() {
            return this.notRegistered.size() > 0;
        }

        public Profiles clear() {
            this.registered.clear();
            this.notRegistered.clear();
            this.registrationExceptions = null;
            return this;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("Profiles{");
            sb.append("registered=").append(this.registered);
            sb.append(", notRegistered=").append(this.notRegistered);
            sb.append(", registrationExceptions=").append(this.registrationExceptions);
            sb.append('}');
            return sb.toString();
        }
    }
}

