/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.trending;

import com.sun.jersey.api.client.WebResource;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import org.freehep.application.mdi.PageContext;
import org.freehep.application.mdi.PageManager;
import org.freehep.application.studio.Plugin;
import org.freehep.jas.plugin.tree.FTree;
import org.freehep.jas.plugin.tree.FTreeNode;
import org.freehep.jas.plugin.tree.FTreeNodeAdapter;
import org.freehep.jas.plugin.tree.FTreeNodeAddedNotification;
import org.freehep.jas.plugin.tree.FTreeNodeRemovedNotification;
import org.freehep.jas.plugin.tree.FTreeNotification;
import org.freehep.jas.plugin.tree.FTreePath;
import org.freehep.jas.plugin.tree.FTreeProvider;
import org.freehep.jas.services.PlotPage;
import org.freehep.util.FreeHEPLookup;
import org.freehep.xml.menus.XMLMenuBuilder;
import org.lsst.ccs.gconsole.plugins.rest.LsstRestPlugin;
import org.lsst.ccs.gconsole.plugins.trending.AutoRefresh;
import org.lsst.ccs.gconsole.plugins.trending.DataChannelHandler;
import org.lsst.ccs.gconsole.plugins.trending.DataChannelTreeAdapter;
import org.lsst.ccs.gconsole.plugins.trending.PlotMaker;
import org.lsst.ccs.gconsole.plugins.trending.TrendingPreferences;
import org.lsst.ccs.gconsole.plugins.trending.TrendingService;
import org.lsst.ccs.gconsole.plugins.trending.timeselection.TimeWindowComboBox;
import org.lsst.ccs.localdb.statusdb.server.DataChannel;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.xml.sax.SAXException;

public class LsstTrendingPlugin
extends Plugin {
    private static final Logger logger = Logger.getLogger(LsstRestPlugin.class.getName());
    private TrendingPreferences prefs;
    private TimeWindowComboBox timeRangeSelector;
    private PlotMaker plotMaker;
    private volatile AutoRefresh autoRefresh;

    protected void init() throws SAXException, IOException {
        logger.finest("LsstTrendingPlugin created");
        final FreeHEPLookup lookup = this.getApplication().getLookup();
        this.addDataServerListener(lookup);
        this.timeRangeSelector = this.addTrendingToolbar();
        TrendingService trendingService = new TrendingService(){

            @Override
            public void show(String[] path) {
                FTreeProvider treeProvider = (FTreeProvider)lookup.lookup(FTreeProvider.class);
                if (treeProvider != null) {
                    FTree tree = treeProvider.tree();
                    FTreeNode node = tree.findNode(new FTreePath(path));
                    tree.adapterForClass(DataChannelHandler.class).doubleClick(node);
                }
            }
        };
        lookup.add(trendingService);
        this.prefs = new TrendingPreferences(this);
        lookup.add(this.prefs);
        this.plotMaker = new PlotMaker(this);
    }

    private void addDataServerListener(FreeHEPLookup lookup) {
        Lookup.Template template = new Lookup.Template(WebResource.class, "dataserver", null);
        final Lookup.Result result = lookup.lookup(template);
        this.handleWebResource(result.allInstances());
        LookupListener ll = new LookupListener(){

            public void resultChanged(LookupEvent le) {
                LsstTrendingPlugin.this.handleWebResource(result.allInstances());
            }
        };
        result.addLookupListener(ll);
    }

    private TimeWindowComboBox addTrendingToolbar() throws SAXException, IOException {
        XMLMenuBuilder builder = this.getApplication().getXMLMenuBuilder();
        URL xml = ((Object)((Object)this)).getClass().getResource("Trending.menus");
        builder.build(xml);
        JToolBar toolbar = builder.getToolBar("trending");
        TimeWindowComboBox box = new TimeWindowComboBox(this.getApplication());
        box.setEnabled(box.getItemCount() > 0);
        JLabel boxLabel = new JLabel("Trending Period: ");
        toolbar.add((Component)boxLabel, 0);
        toolbar.add((Component)box, 1);
        JMenuBar bar = new JMenuBar();
        bar.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1), BorderFactory.createRaisedBevelBorder()));
        bar.setAlignmentY(0.5f);
        JMenu menu = new JMenu("Apply");
        bar.add(menu);
        JMenuItem item = new JMenuItem("All");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PageManager pm = LsstTrendingPlugin.this.getApplication().getPageManager();
                PageContext selectedPage = pm.getSelectedPage();
                List pcList = pm.pages();
                for (Object o : pcList) {
                    try {
                        PlotPage page = (PlotPage)((PageContext)o).getPage();
                        if (page == null) continue;
                        LsstTrendingPlugin.this.plotMaker.refresh(page, LsstTrendingPlugin.this.timeRangeSelector.getSelectedTimeWindow());
                    }
                    catch (ClassCastException | NullPointerException runtimeException) {}
                }
                selectedPage.requestShow();
            }
        });
        menu.add(item);
        item = new JMenuItem("Page");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    PlotPage page = (PlotPage)LsstTrendingPlugin.this.getApplication().getPageManager().getSelectedPage().getPage();
                    if (page != null) {
                        LsstTrendingPlugin.this.plotMaker.refresh(page, LsstTrendingPlugin.this.timeRangeSelector.getSelectedTimeWindow());
                    }
                }
                catch (ClassCastException | NullPointerException runtimeException) {
                    // empty catch block
                }
            }
        });
        menu.add(item);
        item = new JMenuItem("Region");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    PlotPage page = (PlotPage)LsstTrendingPlugin.this.getApplication().getPageManager().getSelectedPage().getPage();
                    LsstTrendingPlugin.this.plotMaker.refresh(page.currentRegion(), LsstTrendingPlugin.this.timeRangeSelector.getSelectedTimeWindow(), new PlotMaker.Options[0]);
                }
                catch (ClassCastException | NullPointerException runtimeException) {
                    // empty catch block
                }
            }
        });
        menu.add(item);
        toolbar.add((Component)bar, 2);
        bar = new JMenuBar();
        bar.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1), BorderFactory.createRaisedBevelBorder()));
        bar.setAlignmentY(0.5f);
        menu = new JMenu("Refresh");
        bar.add(menu);
        item = new JMenuItem("All");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PageManager pm = LsstTrendingPlugin.this.getApplication().getPageManager();
                PageContext selectedPage = pm.getSelectedPage();
                List pcList = pm.pages();
                for (Object o : pcList) {
                    try {
                        PlotPage page = (PlotPage)((PageContext)o).getPage();
                        if (page == null) continue;
                        LsstTrendingPlugin.this.plotMaker.refresh(page, null);
                    }
                    catch (ClassCastException | NullPointerException runtimeException) {}
                }
                selectedPage.requestShow();
            }
        });
        menu.add(item);
        item = new JMenuItem("Page");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    PlotPage page = (PlotPage)LsstTrendingPlugin.this.getApplication().getPageManager().getSelectedPage().getPage();
                    if (page != null) {
                        LsstTrendingPlugin.this.plotMaker.refresh(page, null);
                    }
                }
                catch (ClassCastException | NullPointerException runtimeException) {
                    // empty catch block
                }
            }
        });
        menu.add(item);
        item = new JMenuItem("Region");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    PlotPage page = (PlotPage)LsstTrendingPlugin.this.getApplication().getPageManager().getSelectedPage().getPage();
                    LsstTrendingPlugin.this.plotMaker.refresh(page.currentRegion(), null, new PlotMaker.Options[0]);
                }
                catch (ClassCastException | NullPointerException runtimeException) {
                    // empty catch block
                }
            }
        });
        menu.add(item);
        menu.addSeparator();
        JCheckBoxMenuItem cbItem = new JCheckBoxMenuItem("Auto");
        cbItem.setSelected(false);
        cbItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    LsstTrendingPlugin.this.autoRefresh = new AutoRefresh(LsstTrendingPlugin.this);
                    LsstTrendingPlugin.this.autoRefresh.start();
                } else if (e.getStateChange() == 2 && LsstTrendingPlugin.this.autoRefresh != null) {
                    LsstTrendingPlugin.this.autoRefresh.stop();
                    LsstTrendingPlugin.this.autoRefresh = null;
                }
            }
        });
        menu.add(cbItem);
        toolbar.add((Component)bar, 3);
        this.getApplication().addToolBar(toolbar, toolbar.getName());
        return box;
    }

    private void handleWebResource(Collection<WebResource> allInstances) {
        Iterator<WebResource> iterator = allInstances.iterator();
        if (iterator.hasNext()) {
            WebResource service = iterator.next();
            this.handleDataServer(service);
            return;
        }
        this.handleDataServer(null);
    }

    private void handleDataServer(WebResource service) {
        block4: {
            FreeHEPLookup lookup = this.getApplication().getLookup();
            FTreeProvider treeProvider = (FTreeProvider)lookup.lookup(FTreeProvider.class);
            if (treeProvider == null) break block4;
            FTree tree = treeProvider.tree();
            if (service == null) {
                logger.log(Level.INFO, "WebResource removed");
                FTreeNode root = tree.root();
                for (FTreeNode node : root.childNodes()) {
                    tree.treeChanged((FTreeNotification)new FTreeNodeRemovedNotification((Object)this.getApplication(), node.path()));
                }
            } else {
                logger.log(Level.INFO, "WebResource registered {0}", service);
                DataChannel.DataChannelList channelList = (DataChannel.DataChannelList)lookup.lookup(DataChannel.DataChannelList.class);
                DataChannelTreeAdapter treeAdapter = new DataChannelTreeAdapter(this, service);
                treeProvider.treeNodeAdapterRegistry().registerNodeAdapter((FTreeNodeAdapter)treeAdapter, DataChannelHandler.class);
                for (DataChannel chan : channelList.list) {
                    tree.treeChanged((FTreeNotification)new FTreeNodeAddedNotification((Object)this.getApplication(), chan.getPathAsString(), (Object)new DataChannelHandler(chan, treeAdapter)));
                }
            }
        }
    }

    public TrendingPreferences getPreferences() {
        return this.prefs;
    }

    public PlotMaker getPlotMaker() {
        return this.plotMaker;
    }

    public AutoRefresh getAutoRefresh() {
        return this.autoRefresh;
    }

    public TimeWindowComboBox getTimeWindowSelector() {
        return this.timeRangeSelector;
    }
}

