/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.trending;

import com.sun.jersey.api.client.WebResource;
import hep.aida.IDataPoint;
import hep.aida.IDataPointSet;
import hep.aida.ref.histogram.DataPointSet;
import java.awt.Container;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JComponent;
import org.freehep.application.Application;
import org.freehep.application.studio.Plugin;
import org.freehep.application.studio.PluginInfo;
import org.freehep.application.studio.Studio;
import org.freehep.jas.services.PlotPage;
import org.freehep.jas.services.PlotRegion;
import org.freehep.jas.services.Plotter;
import org.lsst.ccs.gconsole.plugins.rest.LsstRestPlugin;
import org.lsst.ccs.gconsole.plugins.trending.AuxData;
import org.lsst.ccs.gconsole.plugins.trending.AuxDataPointSet;
import org.lsst.ccs.gconsole.plugins.trending.DataChannelTreeAdapter;
import org.lsst.ccs.gconsole.plugins.trending.Plot;
import org.lsst.ccs.gconsole.plugins.trending.PlotData;
import org.lsst.ccs.gconsole.plugins.trending.TrendingPreferences;
import org.lsst.ccs.gconsole.plugins.trending.timeselection.TimeWindow;
import org.lsst.ccs.localdb.statusdb.server.ChannelMetaData;
import org.lsst.ccs.localdb.statusdb.server.Data;
import org.lsst.ccs.localdb.statusdb.server.DataChannel;
import org.lsst.ccs.localdb.statusdb.server.TrendingData;
import org.lsst.ccs.localdb.statusdb.server.TrendingResult;

public class DataChannelHandler {
    private final DataChannel channel;
    private final DataChannelTreeAdapter adapter;
    private ArrayList<WeakReference<Plot>> plots;

    DataChannelHandler(DataChannel dataChannel, DataChannelTreeAdapter treeAdapter) {
        this.channel = dataChannel;
        this.adapter = treeAdapter;
    }

    public String getPath() {
        return this.channel.getPathAsString();
    }

    public DataChannel getDataChannel() {
        return this.channel;
    }

    public synchronized List<Plot> getPlots() {
        if (this.plots == null) {
            return Collections.emptyList();
        }
        ArrayList<Plot> out = new ArrayList<Plot>(this.plots.size());
        ListIterator<WeakReference<Plot>> it = this.plots.listIterator();
        while (it.hasNext()) {
            WeakReference<Plot> ref = it.next();
            Plot pd = (Plot)ref.get();
            if (pd == null || !this.isDataPlotted(pd)) {
                it.remove();
                continue;
            }
            out.add(pd);
        }
        if (out.isEmpty()) {
            this.plots = null;
        }
        return out;
    }

    public Plot findPlot(TimeWindow timeWindow) {
        if (this.plots == null) {
            return null;
        }
        Plot out = null;
        for (Plot pd : this.getPlots()) {
            if (pd.getRegion().currentPlot().getData().stream().filter(e -> !(e instanceof AuxData)).count() != 1L) continue;
            if (pd.getTimeWindow() == timeWindow) {
                return pd;
            }
            if (out != null && pd.getPage().numberOfRegions() >= out.getPage().numberOfRegions()) continue;
            out = pd;
        }
        return out;
    }

    public Plot makePlot(TimeWindow timeWindow) {
        long begin = timeWindow.getLowerEdge();
        long end = timeWindow.getUpperEdge();
        PlotData dps = this.makePlotData(begin, end, 1);
        Plot pd = new Plot(dps, timeWindow, this);
        pd.setTimeRange(begin, end);
        return pd;
    }

    public boolean refresh(Plot plot, long time) {
        TimeWindow timeWindow = plot.getTimeWindow();
        long begin = timeWindow.getLowerEdge(time);
        long end = timeWindow.getUpperEdge(time);
        try {
            PlotData data = this.makePlotData(begin, end, 2);
            plot.refresh(data, begin, end);
        }
        catch (RuntimeException x) {
            return false;
        }
        return true;
    }

    public boolean refresh(Plot plot) {
        return this.refresh(plot, System.currentTimeMillis());
    }

    public synchronized void addPlotData(Plot plot) {
        if (plot == null) {
            return;
        }
        boolean out = true;
        if (this.plots == null) {
            this.plots = new ArrayList(1);
        } else {
            ListIterator<WeakReference<Plot>> it = this.plots.listIterator();
            while (it.hasNext()) {
                WeakReference<Plot> ref = it.next();
                Plot pd = (Plot)ref.get();
                if (pd == null) {
                    it.remove();
                    continue;
                }
                if (pd != plot) continue;
                out = false;
            }
        }
        if (out) {
            this.plots.add(new WeakReference<Plot>(plot));
        }
    }

    public synchronized void removePlotData(Plot plot) {
        if (plot == null || this.plots == null) {
            return;
        }
        ListIterator<WeakReference<Plot>> it = this.plots.listIterator();
        while (it.hasNext()) {
            WeakReference<Plot> ref = it.next();
            Plot pd = (Plot)ref.get();
            if (pd != null && pd != plot) continue;
            it.remove();
        }
        if (this.plots.isEmpty()) {
            this.plots = null;
        }
    }

    private PlotData makePlotData(long begin, long end, int retry) {
        block2: while (true) {
            try {
                PlotData pd = this.makePlotData(begin, end);
                return pd;
            }
            catch (RuntimeException x) {
                System.out.println("Exception thrown while fetching data " + x);
                System.out.println("Time: " + new Date());
                List plugins = ((Studio)Application.getApplication()).getPlugins();
                for (Object o : plugins) {
                    Plugin plugin = ((PluginInfo)o).getPlugin();
                    if (plugin == null || !(plugin instanceof LsstRestPlugin)) continue;
                    ((LsstRestPlugin)plugin).refreshConnector();
                    System.gc();
                    continue block2;
                }
                if (--retry >= 0) continue;
                return null;
            }
            break;
        }
    }

    private PlotData makePlotData(long begin, long end) {
        WebResource resource = this.adapter.getResource().path("data").path(String.valueOf(this.channel.getId()));
        resource = resource.queryParam("t1", String.valueOf(begin)).queryParam("t2", String.valueOf(end));
        TrendingPreferences pref = this.adapter.getPlugin().getPreferences();
        int nBins = pref.nBins();
        if (nBins > 0) {
            if (!pref.useRawData()) {
                resource = resource.queryParam("flavor", "stat");
            }
            resource = resource.queryParam("n", Integer.toString(nBins));
        } else {
            resource = resource.queryParam("flavor", pref.useRawData() ? "raw" : "stat");
        }
        Data data = (Data)resource.accept(new String[]{"text/xml"}).get(Data.class);
        TrendingResult result = data.getTrendingResult();
        DataPointSet dps = new DataPointSet("", "", 2);
        TrendingData[] dataArray = result.getTrendingDataArray();
        if (dataArray != null) {
            boolean drawRms = pref.drawRms();
            for (TrendingData d2 : dataArray) {
                double rms;
                IDataPoint p = dps.addPoint();
                p.coordinate(0).setValue((double)d2.getAxisvalue().getValue() / 1000.0);
                p.coordinate(1).setValue(d2.getValue("value"));
                if (!drawRms || Double.isNaN(rms = d2.getValue("rms"))) continue;
                p.coordinate(1).setErrorMinus(rms);
                p.coordinate(1).setErrorPlus(rms);
            }
        }
        PlotData pd = new PlotData((IDataPointSet)dps);
        List metaList = result.getChannelMetadata();
        HashMap<String, AuxDataPointSet> metaMap = new HashMap<String, AuxDataPointSet>();
        for (ChannelMetaData meta : metaList) {
            try {
                String name = meta.getName();
                AuxDataPointSet ps = (AuxDataPointSet)metaMap.get(name);
                if (ps == null) {
                    ps = new AuxDataPointSet(null, name);
                    metaMap.put(name, ps);
                }
                double value = Double.parseDouble(meta.getValue());
                long start = meta.getTstart();
                if (start < begin) {
                    start = begin;
                }
                IDataPoint p = ps.addPoint();
                p.coordinate(0).setValue((double)start / 1000.0);
                p.coordinate(1).setValue(value);
                long stop = meta.getTstop();
                if (stop > end || stop == -1L) {
                    stop = end;
                }
                p = ps.addPoint();
                p.coordinate(0).setValue((double)stop / 1000.0);
                p.coordinate(1).setValue(value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        metaMap.values().forEach(d -> pd.add((AuxData)d));
        return pd;
    }

    private boolean isDataPlotted(Plot plotData) {
        PlotPage page = plotData.getPage();
        PlotRegion region = plotData.getRegion();
        if (page == null || region == null) {
            return false;
        }
        try {
            Container c = ((JComponent)region).getTopLevelAncestor();
            if (c == null) {
                return false;
            }
        }
        catch (ClassCastException c) {
            // empty catch block
        }
        Plotter p = region.currentPlot();
        if (p == null) {
            return false;
        }
        List dataList = p.getData();
        return dataList != null && dataList.indexOf(plotData) != -1;
    }
}

