/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.rest;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Properties;
import org.freehep.application.PropertyUtilities;
import org.freehep.application.studio.Studio;

class RestPreferences {
    public static final String SERVER_PROPERTY = "org.lsst.rest.server";
    public static final String PORT_PROPERTY = "org.lsst.rest.port";
    public static final String CONNECT_ON_STARTUP_PROPERTY = "org.lsst.rest.connectOnStartup";
    private String server;
    private int port;
    private boolean connectOnStartup;
    private String oldURL;
    private final Properties user;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    RestPreferences(Studio studio) {
        this.user = studio.getUserProperties();
        this.server = this.user.getProperty(SERVER_PROPERTY, "localhost");
        this.port = PropertyUtilities.getInteger((Properties)this.user, (String)PORT_PROPERTY, (int)8080);
        this.connectOnStartup = PropertyUtilities.getBoolean((Properties)this.user, (String)CONNECT_ON_STARTUP_PROPERTY, (boolean)true);
        this.oldURL = this.getRestURL();
    }

    int getRestPort() {
        return this.port;
    }

    String getRestServer() {
        return this.server;
    }

    boolean isConnectOnStartup() {
        return this.connectOnStartup;
    }

    void setRestPort(int port) {
        this.port = port;
        PropertyUtilities.setInteger((Properties)this.user, (String)PORT_PROPERTY, (int)port);
    }

    void setRestServer(String server) {
        this.server = server;
        this.user.setProperty(SERVER_PROPERTY, server);
    }

    void setConnectOnStartup(boolean connect) {
        PropertyUtilities.setBoolean((Properties)this.user, (String)CONNECT_ON_STARTUP_PROPERTY, (boolean)connect);
    }

    String getURLForServerAndPort(String server, int port) {
        return String.format("http://%s:%d/rest/data", server, port);
    }

    final String getRestURL() {
        return this.getURLForServerAndPort(this.getRestServer(), this.getRestPort());
    }

    void firePropertyChanged() {
        if (!this.getRestURL().equals(this.oldURL)) {
            this.pcs.firePropertyChange("value", this.oldURL, this.getRestURL());
            this.oldURL = this.getRestURL();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }
}

