/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.alert;

import java.net.URL;
import java.util.Map;
import javax.swing.JFrame;
import org.freehep.application.studio.Studio;
import org.freehep.util.commanddispatcher.CommandGroup;
import org.freehep.util.commanddispatcher.CommandProcessor;
import org.freehep.xml.menus.XMLMenuBuilder;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.bus.messages.CommandAck;
import org.lsst.ccs.bus.messages.CommandNack;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.CommandResult;
import org.lsst.ccs.bus.messages.StatusClearedAlert;
import org.lsst.ccs.bus.messages.StatusRaisedAlert;
import org.lsst.ccs.gconsole.ConsolePlugin;
import org.lsst.ccs.gconsole.plugins.alert.AlertHandler;
import org.lsst.ccs.gconsole.plugins.alert.AlertViewer;
import org.lsst.ccs.gconsole.plugins.tracer.LsstTracerPlugin;
import org.lsst.ccs.gconsole.plugins.tracer.Tracer;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.CommandOriginator;

public class LsstAlertPlugin
extends ConsolePlugin {
    private AlertHandler alertHandler;
    private AlertViewer viewer;
    private final JFrame emitter = new JFrame("Alert emitter");

    @Override
    public synchronized void init() throws Throwable {
        Studio studio = this.getConsole().getApplication();
        studio.getCommandTargetManager().add((CommandGroup)new CommandProcessor(){

            public void onLsstAlertViewer() {
                LsstAlertPlugin.this.onNewAlertViewer();
            }

            public void onLsstAlertTracer() {
                LsstAlertPlugin.this.onNewAlertTracer();
            }
        });
        XMLMenuBuilder builder = studio.getXMLMenuBuilder();
        URL xml = this.getClass().getResource("LsstAlertPlugin.menus");
        builder.build(xml);
    }

    @Override
    public synchronized void postInit() {
        this.alertHandler = new AlertHandler(this);
        this.getConsole().getLookup().add(this.alertHandler);
    }

    @Override
    public synchronized void applicationVisible() {
    }

    @Override
    public synchronized void shutdown() {
        if (this.alertHandler != null) {
            this.getConsole().getLookup().remove(this.alertHandler);
            this.alertHandler = null;
        }
    }

    public void onNewAlertViewer() {
        if (this.viewer == null) {
            this.viewer = new AlertViewer(this);
            this.alertHandler.addListener(this.viewer);
        } else {
            this.viewer.ensureVisible();
        }
    }

    public void stopAlertViewer() {
        this.alertHandler.removeListener(this.viewer);
        this.viewer = null;
    }

    public void onNewAlertTracer() {
        LsstTracerPlugin tracerPlugin = (LsstTracerPlugin)((Object)this.getConsole().getLookup().lookup(LsstTracerPlugin.class));
        Tracer tracer = tracerPlugin.createTracer("Alerts", "BuiltIn/Alerts");
        tracer.setFilter(filteredMessage -> {
            BusMessage bm = filteredMessage.getBusMessage();
            if (bm instanceof StatusRaisedAlert) {
                StatusRaisedAlert am = (StatusRaisedAlert)bm;
                Alert alert = am.getRaisedAlert();
                String id = alert.getAlertId();
                StringBuilder sb = new StringBuilder();
                sb.append(AlertViewer.formatTimeStamp(am.getTimeStamp())).append(" : ");
                sb.append(am.getRaisedAlertSummary().getRaisedAlert(id).getLatestAlertState());
                sb.append(" from ").append(am.getOriginAgentInfo().getName()).append(".\n");
                sb.append("ID: ").append(id).append(".  Description:\n");
                sb.append(alert.getDescription()).append("\n");
                filteredMessage.setMessage(sb.toString());
                return filteredMessage;
            }
            if (bm instanceof StatusClearedAlert) {
                StatusClearedAlert am = (StatusClearedAlert)bm;
                StringBuilder sb = new StringBuilder();
                sb.append(AlertViewer.formatTimeStamp(am.getTimeStamp())).append(" : ");
                sb.append(am.getOriginAgentInfo().getName()).append(" cleared alerts ");
                for (String id : am.getClearAlertIds()) {
                    sb.append(id).append(", ");
                }
                sb.delete(sb.length() - 2, sb.length()).append(".\n");
                filteredMessage.setMessage(sb.toString());
                return filteredMessage;
            }
            return null;
        });
    }

    public void clearAlarms(Map<String, String[]> alarms) {
        AgentMessagingLayer messenger = this.getConsole().getMessagingAccess();
        CommandOriginator originator = new CommandOriginator(){

            public void processAck(CommandAck ack) {
            }

            public void processResult(CommandResult result) {
            }

            public void processNack(CommandNack nack) {
            }
        };
        alarms.forEach((source, ids) -> {
            CommandRequest request = ids == null ? new CommandRequest(source, "clearAllAlerts") : new CommandRequest(source, "clearAlerts", new Object[]{ids});
            messenger.sendCommandRequest(request, originator);
        });
    }
}

