/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.alert;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.RaisedAlertHistory;
import org.lsst.ccs.bus.data.RaisedAlertSummary;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.gconsole.plugins.alert.AlertEvent;
import org.lsst.ccs.gconsole.plugins.alert.AlertListener;
import org.lsst.ccs.gconsole.plugins.alert.LsstAlertPlugin;

public class AlertViewer
implements AlertListener {
    private final LsstAlertPlugin plugin;
    private Box view;
    private JFrame frame;
    private Border viewBorder;
    private AlertTree tree;
    private JEditorPane infoPanel;
    private Action clearAction;
    private Action muteAction;
    private Action ignoreAction;
    private Action historyAction;
    private static final int HSPACE = 10;
    private static final int VSPACE = 5;
    private static final EnumMap<AlertState, String> ALCOLOR = new EnumMap(AlertState.class);

    public AlertViewer(LsstAlertPlugin plugin) {
        ALCOLOR.put(AlertState.NOMINAL, "#00AA00");
        ALCOLOR.put(AlertState.WARNING, "#0000AA");
        ALCOLOR.put(AlertState.ALARM, "#AA0000");
        this.plugin = plugin;
    }

    private void start() {
        this.clearAction = new AbstractAction("Clear"){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlertNode node = AlertViewer.this.tree.getSelectedNode();
                if (node == null) {
                    return;
                }
                final HashMap alerts = AlertViewer.this.getAlertMap(node);
                new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() throws Exception {
                        AlertViewer.this.plugin.clearAlarms(alerts);
                        return null;
                    }
                }.execute();
            }
        };
        this.muteAction = new AbstractAction("Mute"){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlertNode node = AlertViewer.this.tree.getSelectedNode();
                if (node != null) {
                    node.setMute(!node.isMute());
                }
            }
        };
        this.ignoreAction = new AbstractAction("Ignore"){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlertNode node = AlertViewer.this.tree.getSelectedNode();
                if (node != null) {
                    node.setIgnore(!node.isIgnore());
                }
            }
        };
        this.historyAction = new AbstractAction("History"){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("History action");
            }
        };
        Box buttonPanel = Box.createHorizontalBox();
        buttonPanel.add(Box.createRigidArea(new Dimension(10, 5)));
        buttonPanel.add(new JButton(this.clearAction));
        buttonPanel.add(Box.createRigidArea(new Dimension(30, 5)));
        buttonPanel.add(new JButton(this.muteAction));
        buttonPanel.add(Box.createRigidArea(new Dimension(10, 5)));
        buttonPanel.add(new JButton(this.ignoreAction));
        buttonPanel.add(Box.createRigidArea(new Dimension(30, 5)));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(new JButton(this.historyAction));
        buttonPanel.add(Box.createRigidArea(new Dimension(10, 5)));
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.tree = new AlertTree();
        this.tree.addTreeSelectionListener(e -> {
            AlertNode node = this.tree.getSelectedNode();
            if (node == null) {
                this.clearAction.setEnabled(false);
                this.muteAction.setEnabled(false);
                this.ignoreAction.setEnabled(false);
                this.historyAction.setEnabled(false);
                this.infoPanel.setText("");
            } else {
                this.clearAction.setEnabled(true);
                this.muteAction.setEnabled(node.getWatchState() != WatchState.IGNORE);
                this.infoPanel.setText(node.getInfo());
                if (node.isRoot()) {
                    this.ignoreAction.setEnabled(true);
                    this.historyAction.setEnabled(false);
                } else {
                    this.ignoreAction.setEnabled(node.getParent().getWatchState() != WatchState.IGNORE);
                    this.historyAction.setEnabled(node.getLeafCount() == 1);
                }
            }
        });
        this.tree.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.infoPanel = new JEditorPane();
        this.infoPanel.setEditable(false);
        this.infoPanel.setContentType("text/html");
        this.infoPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.infoPanel.setText("");
        JPanel rightPanel = new JPanel(new BorderLayout());
        rightPanel.add((Component)new JScrollPane(this.infoPanel), "Center");
        rightPanel.add((Component)buttonPanel, "South");
        this.view = Box.createVerticalBox();
        this.viewBorder = BorderFactory.createEmptyBorder(5, 10, 5, 10);
        JSplitPane splitPane = new JSplitPane(1, new JScrollPane(this.tree), rightPanel);
        this.view.add(splitPane);
        this.view.setPreferredSize(new Dimension(700, 700));
    }

    private void stop() {
        if (this.frame != null) {
            this.frame.dispose();
            this.frame = null;
        }
        this.clearAction = null;
        this.muteAction = null;
        this.ignoreAction = null;
        this.historyAction = null;
        this.tree = null;
        this.infoPanel = null;
        this.view = null;
    }

    @Override
    public void onAlert(AlertEvent event) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.update(event);
        } else {
            try {
                SwingUtilities.invokeAndWait(() -> this.update(event));
            }
            catch (InterruptedException | InvocationTargetException exception) {
                // empty catch block
            }
        }
    }

    public void update(AlertEvent event) {
        String id;
        IDNode idNode;
        if (this.view == null) {
            this.start();
        }
        String source = event.getSource();
        RaisedAlertSummary summary = event.getSummary();
        Set currentAlerts = summary.getAllRaisedAlertHistories();
        AlertNode sourceNode = this.getSourceNode(source);
        if (sourceNode == null) {
            sourceNode = new AlertNode(source);
            for (Object h2 : currentAlerts) {
                this.updateAlert(sourceNode, (RaisedAlertHistory)h2);
            }
            this.tree.getRoot().add(sourceNode);
        } else {
            HashMap id2history = new HashMap(currentAlerts.size() * 2);
            currentAlerts.forEach(h -> id2history.put(h.getLatestAlert().getAlertId(), h));
            for (IDNode idNode2 : sourceNode.getLeaves()) {
                String id2 = idNode2.getID();
                RaisedAlertHistory history = (RaisedAlertHistory)id2history.remove(id2);
                if (history == null) {
                    this.removeAlert(idNode2);
                    continue;
                }
                if (AlertViewer.getLatestAlertTimestamp(history).compareTo(idNode2.getTimeStamp()) <= 0) continue;
                this.updateAlert(sourceNode, history);
            }
            for (RaisedAlertHistory h3 : id2history.values()) {
                this.updateAlert(sourceNode, h3);
            }
        }
        this.tree.getModel().reload();
        Alert alert = event.getAlert();
        TreePath path = alert == null ? new TreePath(new Object[]{this.tree.getRoot(), sourceNode}) : ((idNode = this.tree.findID(id = alert.getAlertId())) == null ? new TreePath(new Object[]{this.tree.getRoot(), sourceNode}) : new TreePath(idNode.getPath()));
        this.tree.setSelectionPath(path);
        this.tree.expandPath(path);
        this.ensureVisible();
    }

    public void ensureVisible() {
        if (this.frame == null) {
            this.frame = new JFrame("Alert Viewer");
            this.frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    AlertViewer.this.stop();
                }
            });
            this.frame.add(this.view);
            this.frame.pack();
        }
        this.frame.setVisible(true);
    }

    private AlertNode getSourceNode(String source) {
        AlertNode root = this.tree.getRoot();
        for (int i = 0; i < root.getChildCount(); ++i) {
            AlertNode node = root.getChildAt(i);
            if (!node.getUserObject().equals(source)) continue;
            return node;
        }
        return null;
    }

    private HashMap<String, String[]> getAlertMap(AlertNode node) {
        HashMap<String, String[]> alerts = new HashMap<String, String[]>();
        if (node instanceof IDNode) {
            IDNode idNode = (IDNode)node;
            alerts.put(node.getSource(), new String[]{idNode.getID()});
        } else if (node.isRoot()) {
            Enumeration<TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                AlertNode sourceNode = (AlertNode)e.nextElement();
                alerts.put(sourceNode.getSource(), null);
            }
        } else if (node.getLevel() == 1) {
            alerts.put(node.getSource(), null);
        } else {
            String source = node.getSource();
            ArrayList<String> ids = new ArrayList<String>();
            Enumeration<TreeNode> e = node.depthFirstEnumeration();
            while (e.hasMoreElements()) {
                TreeNode o = e.nextElement();
                if (!(o instanceof IDNode)) continue;
                IDNode idNode = (IDNode)o;
                ids.add(idNode.getID());
            }
            alerts.put(source, ids.toArray(new String[0]));
        }
        return alerts;
    }

    public static String formatTimeStamp(long millis) {
        Instant instant = Instant.ofEpochMilli(millis);
        return AlertViewer.formatTimeStamp(instant);
    }

    public static String formatTimeStamp(Instant instant) {
        DateTimeFormatter formatter = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT).withZone(ZoneId.systemDefault());
        return formatter.format(instant);
    }

    private static String toColoredString(String text, AlertState level) {
        if (text == null) {
            text = level.toString();
        }
        String color = ALCOLOR.get(level);
        return "<font color=" + color + ">" + text + "</font>";
    }

    private void updateAlert(AlertNode sourceNode, RaisedAlertHistory history) {
        String id = history.getLatestAlert().getAlertId();
        String[] ss = id.split("/");
        ArrayList<String> tokens = new ArrayList<String>(ss.length);
        for (String s : ss) {
            if ((s = s.trim()).isEmpty()) continue;
            tokens.add(s);
        }
        if (tokens.isEmpty()) {
            return;
        }
        for (int i = 0; i < tokens.size() - 1; ++i) {
            String s = (String)tokens.get(i);
            AlertNode tokenNode = null;
            Enumeration<TreeNode> e = sourceNode.children();
            while (e.hasMoreElements()) {
                AlertNode node = (AlertNode)e.nextElement();
                if (node.isLeaf() || !node.getUserObject().equals(s)) continue;
                tokenNode = node;
                break;
            }
            if (tokenNode == null) {
                tokenNode = new AlertNode(s);
                sourceNode.add(tokenNode);
            }
            sourceNode = tokenNode;
        }
        IDNode idNode = null;
        Enumeration<TreeNode> e = sourceNode.children();
        while (e.hasMoreElements()) {
            IDNode node;
            TreeNode o = e.nextElement();
            if (!(o instanceof IDNode) || !(node = (IDNode)o).getID().equals(id)) continue;
            idNode = node;
            break;
        }
        if (idNode == null) {
            idNode = new IDNode(history);
            sourceNode.add(idNode);
        } else {
            idNode.setHistory(history);
        }
    }

    private void removeAlert(IDNode idNode) {
        AlertNode node = idNode;
        AlertNode parent;
        while ((parent = node.getParent()) != null) {
            if (parent.isRoot() || parent.getChildCount() > 1) {
                node.removeFromParent();
                return;
            }
            node = parent;
        }
        return;
    }

    private static Instant getLatestAlertTimestamp(RaisedAlertHistory history) {
        return Instant.ofEpochMilli(history.getLatestAlertTimestamp());
    }

    private class AlertTreeRenderer
    extends DefaultTreeCellRenderer {
        private AlertTreeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            return super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        }
    }

    static final class IDNode
    extends AlertNode {
        private RaisedAlertHistory history;

        IDNode(RaisedAlertHistory history) {
            super(history.getLatestAlert().getAlertId());
            this.setHistory(history);
        }

        void setHistory(RaisedAlertHistory history) {
            this.history = history;
        }

        RaisedAlertHistory getHistory() {
            return this.history;
        }

        String getID() {
            return this.getUserObject();
        }

        @Override
        public String toString() {
            return "<html>" + AlertViewer.toColoredString(this.getLastIdComponent(), this.getAlertLevel()) + "</html>";
        }

        String getLastIdComponent() {
            String[] ss = this.getID().split("/");
            int i = ss.length;
            while (i > 0) {
                String s;
                if ((s = ss[--i].trim()).isEmpty()) continue;
                return s;
            }
            return this.getID();
        }

        @Override
        String getInfo() {
            Alert alert = this.history.getLatestAlert();
            StringBuilder sb = new StringBuilder();
            sb.append("<html>Source: <b>").append(this.getSource()).append("</b><br>");
            sb.append("Alert ID: <b>").append(alert.getAlertId()).append("</b><br>");
            sb.append("Level at <b>").append(AlertViewer.formatTimeStamp(this.history.getLatestAlertTimestamp())).append("</b> : <b>").append(AlertViewer.toColoredString(null, this.history.getLatestAlertState())).append("<b><br>");
            sb.append("Highest level: ").append(AlertViewer.toColoredString(null, this.history.getHighestAlertState()));
            sb.append("<p><b>Description:</b><p>").append(alert.getDescription()).append("</html>");
            return sb.toString();
        }

        @Override
        Instant getTimeStamp() {
            return AlertViewer.getLatestAlertTimestamp(this.history);
        }

        @Override
        AlertState getAlertLevel() {
            return this.history.getHighestAlertState();
        }
    }

    static class AlertNode
    extends DefaultMutableTreeNode
    implements Comparable<AlertNode> {
        private boolean mute;
        private boolean ignore;

        AlertNode(String userObject) {
            super(userObject);
        }

        @Override
        public String getUserObject() {
            return (String)super.getUserObject();
        }

        @Override
        public int compareTo(AlertNode other) {
            return this.getUserObject().compareTo(other.getUserObject());
        }

        @Override
        public void add(MutableTreeNode newChildNode) {
            AlertNode newChild = (AlertNode)newChildNode;
            Enumeration<TreeNode> e = this.children();
            int i = 0;
            boolean replace = false;
            while (e.hasMoreElements()) {
                AlertNode child = (AlertNode)e.nextElement();
                int c = newChild.compareTo(child);
                if (c > 0) {
                    ++i;
                    continue;
                }
                if (c != 0) break;
                replace = true;
                break;
            }
            if (replace) {
                this.remove(i);
            }
            this.insert(newChild, i);
        }

        @Override
        public AlertNode getParent() {
            return (AlertNode)super.getParent();
        }

        @Override
        public AlertNode getChildAt(int index) {
            return (AlertNode)super.getChildAt(index);
        }

        public void forEachChild(Consumer<? super AlertNode> action) {
            if (this.children == null) {
                return;
            }
            this.children.forEach(action);
        }

        public ArrayList<IDNode> getLeaves() {
            ArrayList<IDNode> out = new ArrayList<IDNode>(this.getLeafCount());
            Enumeration<TreeNode> e = this.depthFirstEnumeration();
            while (e.hasMoreElements()) {
                TreeNode node = e.nextElement();
                if (!(node instanceof IDNode)) continue;
                out.add((IDNode)node);
            }
            return out;
        }

        String getInfo() {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>Source: <b>").append(this.getSource()).append("</b><br>");
            sb.append("Alerts selected: <b>").append(this.getLeafCount()).append("</b><br>");
            sb.append("Highest alert level: <b>").append(AlertViewer.toColoredString(null, this.getAlertLevel())).append("</b><br>");
            sb.append("Last changed at <b>").append(AlertViewer.formatTimeStamp(this.getTimeStamp())).append("</b></html>");
            return sb.toString();
        }

        String getSource() {
            int level = this.getLevel();
            if (level > 1) {
                return this.getParent().getSource();
            }
            return this.getUserObject();
        }

        Instant getTimeStamp() {
            Instant out = Instant.EPOCH;
            for (Object child : this.children) {
                Instant time = ((AlertNode)child).getTimeStamp();
                if (time.compareTo(out) <= 0) continue;
                out = time;
            }
            return out;
        }

        AlertState getAlertLevel() {
            AlertState childState;
            AlertState alertState = AlertState.NOMINAL;
            Enumeration<TreeNode> e = this.children();
            while (e.hasMoreElements() && ((childState = ((AlertNode)e.nextElement()).getAlertLevel()).compareTo((Enum)alertState) <= 0 || !(alertState = childState).equals((Object)AlertState.ALARM))) {
            }
            return alertState;
        }

        WatchState getWatchState() {
            WatchState thisState;
            WatchState watchState = this.isIgnore() ? WatchState.IGNORE : (thisState = this.isMute() ? WatchState.MUTE : WatchState.ACTIVE);
            if (thisState == WatchState.IGNORE) {
                return WatchState.IGNORE;
            }
            WatchState parentState = this.getParent().getWatchState();
            return thisState.compareTo(parentState) == -1 ? parentState : thisState;
        }

        boolean isMute() {
            return this.mute;
        }

        void setMute(boolean isMute) {
            this.mute = isMute;
        }

        boolean isIgnore() {
            return this.ignore;
        }

        void setIgnore(boolean isIgnored) {
            this.ignore = isIgnored;
        }

        @Override
        public String toString() {
            return "<html>" + AlertViewer.toColoredString(super.toString(), this.getAlertLevel()) + "</html>";
        }
    }

    private class AlertTreeModel
    extends DefaultTreeModel {
        AlertTreeModel() {
            super(new AlertNode("CCS Alerts"){

                @Override
                WatchState getWatchState() {
                    return this.isIgnore() ? WatchState.IGNORE : (this.isMute() ? WatchState.MUTE : WatchState.ACTIVE);
                }

                @Override
                String getInfo() {
                    StringBuilder sb = new StringBuilder();
                    sb.append("<html>CCS Control System</b><p>");
                    sb.append("Subsystems with active alerts: <b>").append(this.getChildCount()).append("</b><br>");
                    sb.append("Overall alert level: <b>").append(this.getAlertLevel()).append("</b><br>");
                    sb.append("Last changed at <b>").append(AlertViewer.formatTimeStamp(this.getTimeStamp())).append("</b></html>");
                    return sb.toString();
                }

                @Override
                String getSource() {
                    throw new UnsupportedOperationException("Trying to look up source subsystem for the root node.");
                }
            });
        }

        @Override
        public AlertNode getRoot() {
            return (AlertNode)super.getRoot();
        }
    }

    private class AlertTree
    extends JTree {
        AlertTree() {
            super(new AlertTreeModel());
            this.getSelectionModel().setSelectionMode(1);
            this.setCellRenderer(new AlertTreeRenderer());
        }

        public AlertNode getSelectedNode() {
            return (AlertNode)this.getLastSelectedPathComponent();
        }

        @Override
        public AlertTreeModel getModel() {
            return (AlertTreeModel)super.getModel();
        }

        public AlertNode getRoot() {
            return this.getModel().getRoot();
        }

        public IDNode findID(String id) {
            Enumeration<TreeNode> e = this.getRoot().depthFirstEnumeration();
            while (e.hasMoreElements()) {
                TreeNode node = e.nextElement();
                if (!(node instanceof IDNode) || !((IDNode)node).getID().equals(id)) continue;
                return (IDNode)node;
            }
            return null;
        }
    }

    private static enum WatchState {
        ACTIVE,
        MUTE,
        IGNORE;

    }
}

