/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.RaisedAlertInstance;
import org.lsst.ccs.bus.states.AlertState;

public final class RaisedAlertHistory
implements Serializable {
    private static final long serialVersionUID = 883621057372902934L;
    private Alert latestAlert;
    private final List<RaisedAlertInstance> instances;
    private AlertState highestSeverity = AlertState.NOMINAL;

    public RaisedAlertHistory() {
        this.instances = new ArrayList<RaisedAlertInstance>();
    }

    public RaisedAlertHistory(RaisedAlertHistory other) {
        this.latestAlert = other.latestAlert;
        this.instances = new ArrayList<RaisedAlertInstance>(other.instances);
        this.highestSeverity = other.highestSeverity;
    }

    public Alert getLatestAlert() {
        return this.latestAlert;
    }

    private void updateLatestAlert(Alert alert) {
        this.latestAlert = new Alert(alert.getAlertId(), alert.getDescription());
    }

    public void addAlertInstance(AlertState severity, Alert alert, long timestamp) {
        if (severity.compareTo(this.highestSeverity) > 0) {
            this.highestSeverity = severity;
        }
        this.instances.add(new RaisedAlertInstance(severity, timestamp));
        this.updateLatestAlert(alert);
    }

    public void addAlertInstance(AlertState severity, Alert alert) {
        this.addAlertInstance(severity, alert, System.currentTimeMillis());
    }

    public int getNumberOfInstances() {
        return this.instances.size();
    }

    public AlertState getLatestAlertState() {
        switch (this.getNumberOfInstances()) {
            case 0: {
                return AlertState.NOMINAL;
            }
        }
        return this.instances.get(this.getNumberOfInstances() - 1).getAlertState();
    }

    public long getLatestAlertTimestamp() {
        switch (this.getNumberOfInstances()) {
            case 0: {
                return -1L;
            }
        }
        return this.instances.get(this.getNumberOfInstances() - 1).getTimestamp();
    }

    public AlertState getHighestAlertState() {
        return this.highestSeverity;
    }

    public List<RaisedAlertInstance> getRaisedAlertInstancesList() {
        return Collections.unmodifiableList(this.instances);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Raised Alarms for id ").append(this.getLatestAlert().getAlertId()).append("\n");
        sb.append("Overall Severity: ").append(this.getHighestAlertState());
        return sb.toString();
    }
}

