/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.plugin.preferences;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.freehep.application.studio.Studio;
import org.freehep.jas.plugin.preferences.PreferencesTree;
import org.freehep.jas.services.PreferencesTopic;

class PreferencesDialog
extends JOptionPane
implements TreeSelectionListener {
    private JLabel prefLabel;
    private PreferencesTree tree;
    private JScrollPane scrollPane;
    private Studio app;
    private PreferencesTopic current;
    private String[] myOptions = new String[]{"Ok", "Apply", "Cancel"};

    public PreferencesDialog(Studio app) {
        this.app = app;
        this.tree = new PreferencesTree(app.getLookup());
        this.tree.addTreeSelectionListener(this);
        JPanel box = new JPanel(new BorderLayout());
        box.add((Component)new JScrollPane(this.tree), "West");
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        this.prefLabel = new JLabel("Preferences: ");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)this.prefLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)new JSeparator(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.scrollPane = new JScrollPane(new JTextPane());
        jPanel2.add((Component)this.scrollPane, gridBagConstraints);
        box.add((Component)jPanel2, "Center");
        this.setMessage(box);
        this.setMessageType(-1);
        this.setOptionType(1);
        this.setOptions(this.myOptions);
        this.setPreferredSize(new Dimension(500, 350));
    }

    void showDialog() {
        JDialog dlg = this.createDialog(this.app, "Preferences");
        dlg.setVisible(true);
    }

    void selectTopic(String[] topic) {
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        PreferencesTopic topic = this.tree.getSelectedTopic();
        if (topic != this.current) {
            boolean ok;
            if (this.current != null && !(ok = this.current.apply((JComponent)this.scrollPane.getViewport().getView()))) {
                this.tree.setSelectionPath(e.getOldLeadSelectionPath());
                return;
            }
            this.current = topic;
            if (topic != null) {
                JComponent panel = topic.component();
                this.scrollPane.setViewportView(panel);
                StringBuffer label = new StringBuffer();
                String[] path = topic.path();
                for (int i = 0; i < path.length; ++i) {
                    label.append(path[i]);
                    label.append(' ');
                }
                this.prefLabel.setText("Preferences: " + label);
            } else {
                this.scrollPane.setViewportView(null);
                this.prefLabel.setText("Preferences: " + this.tree.getSelectionPath().getLastPathComponent().toString());
            }
        }
    }

    @Override
    public void setValue(Object newValue) {
        boolean ok = newValue == this.myOptions[0];
        boolean apply = newValue == this.myOptions[1];
        boolean close = true;
        if (ok || apply) {
            close = this.apply();
        }
        if (close &= !apply) {
            super.setValue(newValue);
        }
    }

    private boolean apply() {
        if (this.current != null) {
            return this.current.apply((JComponent)this.scrollPane.getViewport().getView());
        }
        return true;
    }
}

