/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.tracer;

import java.awt.Component;
import java.awt.Point;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.freehep.application.mdi.PageEvent;
import org.freehep.application.mdi.PageListener;
import org.freehep.swing.popup.HasPopupItems;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.gconsole.plugins.tracer.FilterChooser;
import org.lsst.ccs.gconsole.plugins.tracer.FilterEditor;
import org.lsst.ccs.gconsole.plugins.tracer.FilterRegistry;
import org.lsst.ccs.gconsole.plugins.tracer.FilteredMessage;
import org.lsst.ccs.gconsole.plugins.tracer.LsstTracerPlugin;
import org.lsst.ccs.gconsole.plugins.tracer.MessageFilter;
import org.lsst.ccs.gconsole.plugins.tracer.TracerMessage;
import org.lsst.ccs.gconsole.plugins.tracer.TracerWriter;
import org.lsst.ccs.gconsole.plugins.tracer.UserFilter;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.StatusMessageListener;

public class Tracer
implements PageListener,
StatusMessageListener,
HasPopupItems {
    private final LsstTracerPlugin plugin;
    private final AgentMessagingLayer messagingAccess;
    private TracerWriter out;
    private volatile MessageFilter filter;

    Tracer(LsstTracerPlugin plugin) {
        this(plugin, null);
    }

    Tracer(LsstTracerPlugin plugin, MessageFilter filter) {
        this.plugin = plugin;
        this.messagingAccess = plugin.getMessagingAccess();
        this.filter = filter;
    }

    public void setFilter(MessageFilter filter) {
        this.filter = filter;
        if (this.out != null) {
            this.out.reset();
        }
    }

    public void onStatusMessage(StatusMessage statusMessage) {
        if (this.filter == null) {
            this.out.println(statusMessage);
        } else {
            FilteredMessage filteredMessage = new TracerMessage((BusMessage)statusMessage);
            if ((filteredMessage = this.filter.test(filteredMessage)) != null) {
                this.out.println(filteredMessage);
            }
        }
    }

    public void pageChanged(PageEvent pe) {
        if (pe.getID() == 4001) {
            this.messagingAccess.removeStatusMessageListener((StatusMessageListener)this);
        }
    }

    void start(TracerWriter out) {
        this.out = out;
        this.messagingAccess.addStatusMessageListener((StatusMessageListener)this);
    }

    public JPopupMenu modifyPopupMenu(JPopupMenu menu, Component source, Point p) {
        JMenu filterMenu = new JMenu("Filter...");
        JMenuItem item = new JMenuItem("New...");
        item.setToolTipText("Define new filter");
        item.addActionListener(e -> {
            UserFilter f = FilterEditor.showDialog(source, null, this.plugin);
            if (f != null) {
                this.setFilter(f);
            }
        });
        filterMenu.add(item);
        item = new JMenuItem("Load...");
        item.setToolTipText("Load named filter.");
        item.addActionListener(e -> {
            FilterRegistry registry = this.plugin.getFilterRegistry();
            String name = FilterChooser.showDialog(source, registry);
            if (name != null) {
                try {
                    MessageFilter f = registry.getFilter(name);
                    if (f == null) {
                        this.plugin.getApplication().error("Unknown message filter: " + name);
                    } else {
                        this.setFilter(f);
                    }
                }
                catch (IllegalArgumentException x) {
                    this.plugin.getApplication().error("Error initializing message filter " + name, (Throwable)x);
                }
            }
        });
        filterMenu.add(item);
        item = new JMenuItem("Edit...");
        item.setToolTipText("Edit filter");
        item.addActionListener(e -> {
            UserFilter f = FilterEditor.showDialog(source, this.filter, this.plugin);
            if (f != null) {
                this.setFilter(f);
            }
        });
        filterMenu.add(item);
        item = new JMenuItem("Remove");
        item.setToolTipText("Remove filter");
        item.setEnabled(this.filter != null);
        item.addActionListener(e -> this.setFilter(null));
        filterMenu.add(item);
        menu.insert(filterMenu, 0);
        return menu;
    }
}

