/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.tracer;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.gconsole.plugins.tracer.FilteredMessage;
import org.lsst.ccs.gconsole.plugins.tracer.MessageFilter;

class StandardFormatter
implements MessageFilter {
    private final SimpleDateFormat dtFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    StandardFormatter() {
    }

    @Override
    public String getDescription() {
        return "Accepts all messages. Formats output as [Time stamp] from [Origin] : [Key]";
    }

    @Override
    public String getName() {
        return "Format/Simple";
    }

    @Override
    public FilteredMessage test(FilteredMessage filteredMessage) {
        BusMessage bm = filteredMessage.getBusMessage();
        Date date = new Date(bm.getTimeStamp());
        StringBuilder sb = new StringBuilder(this.dtFormat.format(date));
        sb.append(" from ").append(bm.getOriginAgentInfo().getName());
        filteredMessage.setMessage(sb.toString());
        return filteredMessage;
    }
}

