/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.tracer;

import jas.util.Application;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.io.IOException;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.lsst.ccs.gconsole.plugins.tracer.FilterEditor;
import org.lsst.ccs.gconsole.plugins.tracer.FilterRegistry;

public class FilterChooser
extends JDialog
implements TreeSelectionListener {
    private final int VSPACE = 5;
    private final int HSPACE = 5;
    FilterRegistry registry;
    private JTree tree;
    private DefaultTreeModel treeModel;
    private JEditorPane descriptionPane;
    private JButton deleteButton;
    private JButton okButton;
    private String chosenName;

    public FilterChooser(Component parent, FilterRegistry registry) {
        super(FilterEditor.getWindow(parent), "Choose Filter", Dialog.ModalityType.APPLICATION_MODAL);
        this.setDefaultCloseOperation(1);
        this.registry = registry;
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        this.createNodes(root);
        this.treeModel = new DefaultTreeModel(root);
        this.tree = new JTree(this.treeModel);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setRootVisible(true);
        this.tree.addTreeSelectionListener(this);
        this.descriptionPane = new JEditorPane();
        this.descriptionPane.setEditable(false);
        this.descriptionPane.setContentType("text/html");
        JScrollPane treeView = new JScrollPane(this.tree);
        JScrollPane descriptionView = new JScrollPane(this.descriptionPane);
        Dimension minimumSize = new Dimension(100, 50);
        treeView.setMinimumSize(minimumSize);
        descriptionView.setMinimumSize(minimumSize);
        JSplitPane splitPane = new JSplitPane(1, treeView, descriptionView);
        splitPane.setDividerLocation(200);
        splitPane.setPreferredSize(new Dimension(500, 300));
        this.add((Component)splitPane, "Center");
        Box controls = Box.createHorizontalBox();
        controls.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)controls, "South");
        this.deleteButton = new JButton("Delete");
        this.deleteButton.setEnabled(false);
        this.deleteButton.addActionListener(e -> {
            String name = this.getSelectedName();
            Object selection = this.tree.getLastSelectedPathComponent();
            if (name == null || selection == null || !(selection instanceof Node)) {
                return;
            }
            Node node = (Node)selection;
            if (!node.canDelete()) {
                return;
            }
            try {
                registry.deleteFilter(name);
                while (node != null) {
                    TreeNode mother = node.getParent();
                    this.treeModel.removeNodeFromParent(node);
                    Node node2 = node = mother.isLeaf() && mother != root ? (Node)mother : null;
                }
            }
            catch (IOException x) {
                Application.getApplication().error("Unable to delete filter " + name, (Throwable)x);
            }
        });
        controls.add(this.deleteButton);
        controls.add(Box.createHorizontalStrut(10));
        controls.add(Box.createHorizontalGlue());
        this.okButton = new JButton("OK");
        this.okButton.setEnabled(false);
        this.okButton.addActionListener(e -> {
            this.chosenName = this.getSelectedName();
            this.setVisible(false);
        });
        controls.add(this.okButton);
        controls.add(Box.createHorizontalStrut(5));
        JButton button = new JButton("Cancel");
        button.addActionListener(e -> this.setVisible(false));
        controls.add(button);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    public String getChosenName() {
        return this.chosenName;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        Node node;
        Object selection = this.tree.getLastSelectedPathComponent();
        Node node2 = node = selection instanceof Node ? (Node)selection : null;
        if (node == null) {
            this.deleteButton.setEnabled(false);
            this.okButton.setEnabled(false);
            this.descriptionPane.setText("");
        } else if (node.isLeaf()) {
            this.deleteButton.setEnabled(node.canDelete());
            this.okButton.setEnabled(true);
            this.descriptionPane.setText(node.description);
        } else {
            this.deleteButton.setEnabled(false);
            this.okButton.setEnabled(false);
            if (node.getLevel() == 1) {
                String s = String.valueOf(node.toString()) + "/";
                if (s.equals("BuiltIn/")) {
                    this.descriptionPane.setText("Built-In Filters.");
                } else if (s.equals("Local/")) {
                    this.descriptionPane.setText("Filters registered with the Graphical Console lookup.");
                } else if (s.equals("User/")) {
                    this.descriptionPane.setText("User-defined filters.");
                } else {
                    this.descriptionPane.setText("");
                }
            } else {
                this.descriptionPane.setText("");
            }
        }
    }

    public static String showDialog(Component parent, FilterRegistry registry) {
        FilterChooser chooser = new FilterChooser(parent, registry);
        chooser.setVisible(true);
        String out = chooser.getChosenName();
        chooser.dispose();
        return out;
    }

    private void createNodes(DefaultMutableTreeNode root) {
        HashMap nodes = new HashMap();
        this.registry.availableFilters().forEach((filter, description) -> {
            String[] tokens = filter.split("/");
            String path = "";
            DefaultMutableTreeNode parent = root;
            String[] stringArray = tokens;
            int n = tokens.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                Node node = (Node)nodes.get(path = String.valueOf(path) + s);
                if (node == null) {
                    node = new Node(s);
                    nodes.put(path, node);
                    parent.add(node);
                }
                parent = node;
                path = String.valueOf(path) + "/";
                ++n2;
            }
            ((Node)parent).description = description;
            ((Node)parent).local = path.startsWith("User/");
        });
    }

    private String getSelectedName() {
        TreePath path = this.tree.getSelectionPath();
        if (path == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Object[] objectArray = path.getPath();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            sb.append(o).append("/");
            ++n2;
        }
        return sb.substring(1, sb.length() - 1);
    }

    private class Node
    extends DefaultMutableTreeNode {
        String description;
        boolean local;

        Node(String name) {
            super(name);
        }

        boolean canDelete() {
            return this.local;
        }
    }
}

