/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.rest;

import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.lsst.ccs.gconsole.plugins.rest.RestPreferences;

class RestServerPreferencesPanel
extends JPanel {
    private final RestPreferences prefs;
    private JCheckBox connectOnStartupCheckBox;
    private JSpinner portSpinner;
    private JTextField serverTextField;
    private JTextField urlTextField;

    RestServerPreferencesPanel(RestPreferences prefs) {
        this.prefs = prefs;
        this.initComponents();
        this.updateURL();
        DocumentListener documentListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                RestServerPreferencesPanel.this.updateURL();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                RestServerPreferencesPanel.this.updateURL();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                RestServerPreferencesPanel.this.updateURL();
            }
        };
        this.serverTextField.getDocument().addDocumentListener(documentListener);
    }

    void apply() {
        this.prefs.setRestPort(((Number)this.portSpinner.getValue()).intValue());
        this.prefs.setRestServer(this.serverTextField.getText());
        this.prefs.setConnectOnStartup(this.connectOnStartupCheckBox.isSelected());
        this.prefs.firePropertyChanged();
    }

    private void updateURL() {
        this.urlTextField.setText(this.prefs.getURLForServerAndPort(this.serverTextField.getText(), ((Number)this.portSpinner.getValue()).intValue()));
    }

    private void initComponents() {
        JLabel jLabel1 = new JLabel();
        this.serverTextField = new JTextField();
        JLabel jLabel2 = new JLabel();
        this.portSpinner = new JSpinner();
        JLabel jLabel3 = new JLabel();
        this.urlTextField = new JTextField();
        this.connectOnStartupCheckBox = new JCheckBox();
        jLabel1.setText("Server:");
        this.serverTextField.setText(this.prefs.getRestServer());
        jLabel2.setText("Port:");
        this.portSpinner.setModel(new SpinnerNumberModel(this.prefs.getRestPort(), 1, 65536, 1));
        this.portSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                RestServerPreferencesPanel.this.portSpinnerStateChanged(evt);
            }
        });
        jLabel3.setText("URL:");
        this.urlTextField.setEnabled(false);
        this.connectOnStartupCheckBox.setSelected(this.prefs.isConnectOnStartup());
        this.connectOnStartupCheckBox.setText("connect on startup");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(jLabel3).addComponent(jLabel1).addComponent(jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.portSpinner, -2, -1, -2).addComponent(this.serverTextField, -1, 241, Short.MAX_VALUE).addComponent(this.urlTextField))).addComponent(this.connectOnStartupCheckBox)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel1).addComponent(this.serverTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel2).addComponent(this.portSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel3).addComponent(this.urlTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.connectOnStartupCheckBox).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void portSpinnerStateChanged(ChangeEvent evt) {
        this.updateURL();
    }
}

