/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.console;

import java.io.IOException;
import java.net.URL;
import jline.console.ConsoleReader;
import org.freehep.application.studio.Plugin;
import org.freehep.application.studio.Studio;
import org.freehep.jas.extensions.jconsole.JConsoleProvider;
import org.freehep.jas.extensions.jconsole.JConsoleService;
import org.freehep.jas.extensions.jconsole.JLineConsole;
import org.freehep.jas.extensions.jconsole.JLineConsoleProvider;
import org.freehep.util.FreeHEPLookup;
import org.freehep.util.commanddispatcher.CommandGroup;
import org.freehep.util.commanddispatcher.CommandProcessor;
import org.freehep.xml.menus.XMLMenuBuilder;
import org.lsst.ccs.gconsole.Console;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.shell.JLineShell;
import org.lsst.ccs.subsystem.shell.ConsoleCommandShell;
import org.xml.sax.SAXException;

public class LsstConsolePlugin
extends Plugin {
    private final String defaultConsoleName = "LSST Console";
    private Console agent;

    protected synchronized void init() throws SAXException, IOException {
        Studio studio = this.getApplication();
        FreeHEPLookup lookup = studio.getLookup();
        lookup.add((Object)this);
        studio.getCommandTargetManager().add((CommandGroup)new ConsoleCommands());
        XMLMenuBuilder builder = studio.getXMLMenuBuilder();
        URL xml = ((Object)((Object)this)).getClass().getResource("LsstConsolePlugin.menus");
        builder.build(xml);
    }

    protected synchronized void postInit() {
        this.agent = (Console)((Object)this.getApplication().getLookup().lookup(Console.class));
        JConsoleService cs = (JConsoleService)this.getApplication().getLookup().lookup(JConsoleService.class);
        if (cs == null) {
            throw new IllegalStateException("JConsole service is not available");
        }
        cs.addConsoleProvider(JLineConsole.class, (JConsoleProvider)new JLineConsoleProvider());
    }

    private synchronized JLineConsole createCommandConsole(String name) {
        Studio studio = this.getApplication();
        try {
            JConsoleService cs = (JConsoleService)this.getApplication().getLookup().lookup(JConsoleService.class);
            if (cs != null) {
                JLineConsole console = (JLineConsole)cs.createConsole(JLineConsole.class, name, null, null);
                final JLineShell shell = ConsoleCommandShell.createJLineShell((AgentMessagingLayer)this.agent.getMessagingAccess(), (ConsoleReader)console.getConsoleReader());
                Thread t = new Thread("ConsoleInput-" + name){

                    @Override
                    public void run() {
                        try {
                            shell.run();
                        }
                        catch (IOException x) {
                            LsstConsolePlugin.this.getApplication().error("Error in command shell", (Throwable)x);
                        }
                    }
                };
                t.start();
                return console;
            }
        }
        catch (Exception x) {
            studio.error("Failed to start Console: " + name, (Throwable)x);
        }
        return null;
    }

    private class ConsoleCommands
    extends CommandProcessor {
        private ConsoleCommands() {
        }

        public void onLsstConsole() {
            LsstConsolePlugin.this.createCommandConsole("LSST Console");
        }
    }
}

