/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.alert;

import java.awt.Component;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.freehep.application.studio.Studio;
import org.freehep.jas.extensions.jconsole.JLineConsole;
import org.lsst.ccs.bus.messages.Alarm;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.messaging.StatusMessageListener;

class AlarmListener
implements StatusMessageListener,
Runnable {
    private final Studio studio;
    private JDialog dialog;
    private JLineConsole console;
    private PrintWriter printWriter;

    public AlarmListener(Studio studio) {
        this.studio = studio;
        try {
            this.console = new JLineConsole("Alarms");
            this.printWriter = new PrintWriter(this.console.getConsoleReader().getOutput(), true);
        }
        catch (IOException iOException) {}
    }

    public void onStatusMessage(StatusMessage s) {
        if (s instanceof Alarm) {
            this.ensureDialogVisible();
            this.printWriter.println(s);
        }
    }

    @Override
    public void run() {
        if (this.dialog == null) {
            this.dialog = this.createDialog();
        }
        if (!this.dialog.isVisible()) {
            this.dialog.setVisible(true);
        }
    }

    private void ensureDialogVisible() {
        SwingUtilities.invokeLater(this);
    }

    private JDialog createDialog() {
        JOptionPane pane = new JOptionPane();
        pane.setMessageType(0);
        pane.setOptions(new Object[]{"Clear Alarm"});
        pane.setMessage(new JScrollPane(this.console.getView()));
        JDialog dlg = pane.createDialog((Component)this.studio, "Alarm");
        dlg.setResizable(true);
        dlg.setModal(false);
        dlg.setAlwaysOnTop(true);
        return dlg;
    }
}

