package org.lsst.ccs.gconsole.plugins.tracer;

import java.io.IOException;
import java.net.URL;
import org.freehep.application.studio.Studio;
import org.freehep.jas.extensions.jconsole.JConsoleService;
import org.freehep.jas.extensions.jconsole.JLineConsole;
import org.freehep.jas.extensions.jconsole.JLineConsoleProvider;
import org.freehep.jas.plugin.console.Console;
import org.freehep.jas.plugin.console.ConsoleService;
import org.freehep.util.FreeHEPLookup;
import org.freehep.util.commanddispatcher.CommandProcessor;
import org.freehep.xml.menus.XMLMenuBuilder;
import org.lsst.ccs.gconsole.jas3.LsstPlugin;
import org.xml.sax.SAXException;

/**
 * This plugin creates and manages Tracers.
 */
public class LsstTracerPlugin extends LsstPlugin {
    
// -- Fields : -----------------------------------------------------------------

    private final String defaultTracerName = "LSST Tracer";
    private final FilterRegistry filterRegistry = new FilterRegistry(this);


// -- Life cycle : -------------------------------------------------------------
    
    @Override
    public void init() throws SAXException, IOException {

        Studio studio = getApplication();
        FreeHEPLookup lookup = studio.getLookup();
        lookup.add(this);

        studio.getCommandTargetManager().add(new TracerCommands());

        XMLMenuBuilder builder = studio.getXMLMenuBuilder();
        URL xml = getClass().getResource("LsstTracerPlugin.menus");
        builder.build(xml);
    }

    @Override
    public void postInit() {
        super.postInit();
        JConsoleService cs = (JConsoleService) getApplication().getLookup().lookup(JConsoleService.class);
        if (cs == null) throw new IllegalStateException("JConsole service is not available");
        cs.addConsoleProvider(JLineConsole.class, new JLineConsoleProvider());
        filterRegistry.init();
    }
    
    
// -- Getters : ----------------------------------------------------------------
    
    public FilterRegistry getFilterRegistry() {
        return filterRegistry;
    }
    
    
// -- Handling tracers : -------------------------------------------------------

    private void createTracerConsole(String name) {
        FreeHEPLookup lookup = getApplication().getLookup();
        ConsoleService cs = (ConsoleService) lookup.lookup(ConsoleService.class);
        if (cs != null) {
            Tracer tracer = new Tracer(this);
            Console console = cs.createConsole(name, null, tracer);
//            SimpleAttributeSet style = new SimpleAttributeSet();
//            ConsoleOutputStream out = console.getOutputStream(style);
//            PrintWriter pw = new PrintWriter(out, true);
            TracerWriter pw = new TracerWriter(console);
            cs.getPageContextForConsole(console).addPageListener(tracer);
            tracer.start(pw);
        }
    }

//    /** Creates JLineConsole based tracer. Not used at the moment. */
//    private JLineConsole createJTracerConsole(String name) {
//        FreeHEPLookup lookup = getApplication().getLookup();
//        JConsoleService cs = (JConsoleService) lookup.lookup(JConsoleService.class);
//        if (cs != null) {
//            Tracer tracer = new Tracer(getMessagingAccess());
//            JLineConsole console = (JLineConsole) cs.createConsole(JLineConsole.class, name, null, tracer);
//            PrintWriter pw = new PrintWriter(console.getConsoleReader().getOutput(), true);
//            cs.getPageContextForConsole(console).addPageListener(tracer);
//            tracer.start(pw); // This returns immediately
//            return console;
//        }
//        return null;
//    }
    
// -- Command processor : ------------------------------------------------------

    public class TracerCommands extends CommandProcessor {

        public void onLsstTracer() {
            createTracerConsole(defaultTracerName);
        }
    }
}
