package org.lsst.ccs.gconsole.plugins.rest;

import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

/**
 * A preferences panel for allowing a user to control which rest server/port to 
 * connect to.
 * @author tonyj
 */
class RestServerPreferencesPanel extends javax.swing.JPanel {
    private final RestPreferences prefs;

    /**
     * Creates new form RestServerPreferencesPanel
     */
    RestServerPreferencesPanel(RestPreferences prefs) {
        this.prefs = prefs;
        initComponents();
        updateURL();
        final DocumentListener documentListener = new DocumentListener() {
            @Override
            public void insertUpdate(DocumentEvent e) {
                updateURL();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                updateURL();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                updateURL();
            }
        };
        serverTextField.getDocument().addDocumentListener(documentListener);  
    }
    /**
     * Write any changes back into the preferences
     */
    void apply() {
        prefs.setRestPort(((Number) portSpinner.getValue()).intValue());
        prefs.setRestServer(serverTextField.getText());
        prefs.setConnectOnStartup(connectOnStartupCheckBox.isSelected());
        prefs.firePropertyChanged();
    }

    private void updateURL() {
        urlTextField.setText(prefs.getURLForServerAndPort(serverTextField.getText(), ((Number) portSpinner.getValue()).intValue()));
    }
    
    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        javax.swing.JLabel jLabel1 = new javax.swing.JLabel();
        serverTextField = new javax.swing.JTextField();
        javax.swing.JLabel jLabel2 = new javax.swing.JLabel();
        portSpinner = new javax.swing.JSpinner();
        javax.swing.JLabel jLabel3 = new javax.swing.JLabel();
        urlTextField = new javax.swing.JTextField();
        connectOnStartupCheckBox = new javax.swing.JCheckBox();

        jLabel1.setText("Server:");

        serverTextField.setText(prefs.getRestServer());

        jLabel2.setText("Port:");

        portSpinner.setModel(new javax.swing.SpinnerNumberModel(prefs.getRestPort(),1,65536,1));
        portSpinner.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                portSpinnerStateChanged(evt);
            }
        });

        jLabel3.setText("URL:");

        urlTextField.setEnabled(false);

        connectOnStartupCheckBox.setSelected(prefs.isConnectOnStartup());
        connectOnStartupCheckBox.setText("connect on startup");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addComponent(jLabel3)
                            .addComponent(jLabel1)
                            .addComponent(jLabel2))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(portSpinner, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(serverTextField, javax.swing.GroupLayout.DEFAULT_SIZE, 241, Short.MAX_VALUE)
                            .addComponent(urlTextField)))
                    .addComponent(connectOnStartupCheckBox))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(serverTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel2)
                    .addComponent(portSpinner, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel3)
                    .addComponent(urlTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(connectOnStartupCheckBox)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void portSpinnerStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_portSpinnerStateChanged
        updateURL();
    }//GEN-LAST:event_portSpinnerStateChanged

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox connectOnStartupCheckBox;
    private javax.swing.JSpinner portSpinner;
    private javax.swing.JTextField serverTextField;
    private javax.swing.JTextField urlTextField;
    // End of variables declaration//GEN-END:variables

}