package org.lsst.ccs.gconsole.plugins.dictionary;

import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import org.freehep.application.mdi.PageEvent;
import org.freehep.application.studio.Studio;
import org.freehep.util.FreeHEPLookup;
import org.freehep.util.commanddispatcher.CommandProcessor;
import org.freehep.xml.menus.XMLMenuBuilder;
import org.lsst.ccs.gconsole.jas3.LsstPlugin;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.utilities.logging.Logger;
import org.xml.sax.SAXException;


/**
 *
 * @author F
 */
public class LsstDictionaryPlugin extends LsstPlugin {

    private String defaultConsoleName = "Dictionary Interface";
    DictionaryBusMaster dictionaryBusMaster;
    private final Logger logger = getLogger();
    private Studio studio;
    private AgentMessagingLayer messagingAccess;

    @Override
    protected void init() throws SAXException, IOException {

        
        studio = getApplication();
        FreeHEPLookup lookup = studio.getLookup();
        lookup.add(this);
        
        studio.getCommandTargetManager().add(new LsstDictionaryPlugin.DictionaryCommands());

        XMLMenuBuilder builder = studio.getXMLMenuBuilder();
        URL xml = getClass().getResource("LsstDictionaryPlugin.menus");
        builder.build(xml);
    }
    
    @Override
    protected void postInit(){
        messagingAccess = getMessagingAccess();
    }
    
    private void createDictionaryDialog(String name) {
        dictionaryBusMaster = new DictionaryBusMaster(messagingAccess);
        dictionaryBusMaster.initGUI();
        studio.getPageManager().openPage(dictionaryBusMaster.getMainPane(), name, null);
        studio.getPageManager().addPageListener(event -> {
            if (event.getID() == PageEvent.PAGECLOSED){ // tab closed
                Component c = event.getPageContext().getPage();
                if (c.equals(dictionaryBusMaster.getMainPane())){
                        dictionaryBusMaster.doShutdown();
                }
            }
        });
    }
    
  public class DictionaryCommands extends CommandProcessor {

        public void onLsstDictionary() {
            createDictionaryDialog(defaultConsoleName);
        }

    }  

}
