package org.lsst.ccs.gconsole.plugins.dictionary;

import java.awt.Color;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.utils.SynchronousCommandAgent;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.utilities.logging.StackTraceFormats;
import org.lsst.ccs.utilities.structs.TreeBranch;

/**
 *
 * @author emarin
 */
public class DictionaryBusMaster {
    
    private DictionaryTreeMainPanel mainPanel;
    private AgentMessagingLayer messagingAccess;
    
    public DictionaryBusMaster(AgentMessagingLayer messaginAccess) {
        this.messagingAccess = messaginAccess;
        
        mainPanel = new DictionaryTreeMainPanel(new CommandListener() {
            
            
            @Override
            public String sendCommand(String cmdName, Object[] cmdArgs, String destination) {
                return executeSyncInvoke(cmdName, cmdArgs, destination);
            }
            
            @Override
            public Object[][] getConnectedAgents() {
                return busMasterGetConnectedAgents();
            }
            
            @Override
            public TreeBranch<DictionaryContext> buildDictionaryTree(String destination) {
                return busMasterBuildDictionaryTree(destination);
            }
            
            @Override
            public boolean isInEngineeringMode(String destination){
                Object res = executeInternalSyncInvoke("isInEngineeringMode", new Object[0], destination);
                if (res instanceof Boolean){
                    return (Boolean)res;
                } else {
                    return false;
                }
            }
        });
        
    }
    
    public DictionaryTreeMainPanel getMainPane(){
        return mainPanel;
    }
    
    public void initGUI() {
        messagingAccess.getAgentPresenceManager().addAgentPresenceListener(mainPanel);
    }
    
    public JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("Menu");
        menuBar.add(menu);
        JMenuItem menuItem = new JMenuItem("Refresh");
        menuItem.setBackground(Color.LIGHT_GRAY);
        menu.add(menuItem);
        return menuBar;
    }
    public Object[][] busMasterGetConnectedAgents() {
        List<AgentInfo> agentList= messagingAccess.getAgentPresenceManager().listConnectedAgents();
        int i = 0;
        Object[][] res = new Object[agentList.size()][1];
        for (AgentInfo a : agentList){
            res[i][0]=a;
                i++;
        }
        return res;
    }
    
    TreeBranch<DictionaryContext> busMasterBuildDictionaryTree(String destination) {
        
        Object systemDictionary = executeInternalSyncInvoke("getDictionaries", new Object[0], destination);
        Map<String, Dictionary> dictionaryMap = (Map<String,Dictionary>)systemDictionary;
        TreeBranch<DictionaryContext> dictionaryTree = null;
        
        if (dictionaryMap != null){
            // First node building
            String aPath = ((String[])dictionaryMap.keySet().toArray(new String[0]))[0];
            
            String root = aPath.split("/")[0];
            Dictionary rootDictionary = dictionaryMap.remove(root);
            
            dictionaryTree = new TreeBranch<DictionaryContext>(new DictionaryContext(root,rootDictionary));
            TreeBranch<DictionaryContext> treeWalker = dictionaryTree;
            // Tree building
            for (Map.Entry<String,Dictionary> entry : dictionaryMap.entrySet()){
                treeWalker = dictionaryTree;
                String[] pathTab = entry.getKey().split("/");
                boolean found;
                for (int i = 1;i < pathTab.length;i++){
                    found = false;
                    if (treeWalker.getChildren() != null){
                        Iterator<TreeBranch<DictionaryContext>> it = treeWalker.getChildIterator();
                        while(it.hasNext() && !found){
                            TreeBranch<DictionaryContext> currIt = it.next();
                            if (currIt.getContent().getName().equals(pathTab[i])){
                                treeWalker = currIt;
                                found = true;
                                if (i == pathTab.length - 1){
                                    // The node exists but its dictionary has not been set
                                    treeWalker.setContent(new DictionaryContext(pathTab[i],entry.getValue()));
                                }
                            }
                        }
                    }
                    if (!found){
                        treeWalker = new TreeBranch(treeWalker, new DictionaryContext(pathTab[i],entry.getValue()));
                    }
                }
            }
        }
        return dictionaryTree;
    }
    
    public Object executeInternalSyncInvoke(String cmdName, Object[]p,String destination){
        CommandRequest cmd = new CommandRequest(destination,cmdName, p);
        try {
            return new SynchronousCommandAgent(messagingAccess).invoke(cmd, 5000);
        } catch (Exception e) {
            return null;
        }
        
    }
    
    public String executeSyncInvoke(String cmdName, Object[] p, String destination) {
        
        CommandRequest cmd = new CommandRequest(destination,cmdName, p);
        try {
            Object res =  new SynchronousCommandAgent(messagingAccess).invoke(cmd, 5000);
            // in fact if this is an exception should mark as error!
            String strRes = null;
            if (res instanceof Exception) {
                strRes = StackTraceFormats.toString((Exception) res, 1);
            } else if (res == null) {
                strRes = "ok : VOID";
            } else {
                strRes = String.valueOf(res);
            }
            return strRes;
        } catch (Exception e) {
            return "<html> <font color=\"#FF0000\"> Exception caught : " + StackTraceFormats.toString(e, 1) + "</font></html>";
        }
    }
    
    /**
     * Called by the shutdown method of Subsystem
     */
    public void doShutdown(){
        messagingAccess.getAgentPresenceManager().removeAgentPresenceListener(mainPanel);
    }
}
