package org.lsst.ccs.gconsole.plugins.dictionary;

import java.awt.Color;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.utilities.structs.TreeBranch;

/**
 *
 * @author emarin
 */
public class CommandListPanel extends JList<DictionaryCommand> implements TreeSelectionListener, ListSelectionListener {
    private SortedListModel cmdListModel;
    private CommandListRenderer renderer;
    
    public CommandListPanel(){
        //super(new SortedListModel());
        cmdListModel= new SortedListModel();
        setModel(cmdListModel);
        
        getSelectionModel().setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        renderer = new CommandListRenderer(false);
        setCellRenderer(renderer);
    }

    /**
     * 
     * @param tse 
     */
    @Override
    public void valueChanged(TreeSelectionEvent tse) {
        TreeBranch<DictionaryContext> rootNode = (TreeBranch<DictionaryContext>)( ((JTree)tse.getSource()).getModel().getRoot());
        TreeBranch<DictionaryContext> node = (TreeBranch<DictionaryContext>)( ((JTree)tse.getSource()).getLastSelectedPathComponent());
        if (node == null) {
            return;
        }
        if(node != rootNode && node != rootNode.getChildAt(0)){
            renderer.setEM(false);
        }

        Dictionary d = node.getContent().getDictionary();
        // clear the list model and the command description pane
        cmdListModel.clear();

        for (DictionaryCommand dc : d) {
            cmdListModel.add(dc);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        cmdListModel.clear();
    }

    public void updateRenderer(boolean isEM){
        renderer.setEM(isEM);
            this.revalidate();
            this.repaint();
    }
    
    private class CommandListRenderer extends DefaultListCellRenderer {
        boolean isEM;
        
        CommandListRenderer(boolean b){
            super();
            isEM = b;
        }
        
        void setEM(boolean b){
            isEM = b;
        }
        
        @Override
        public Component getListCellRendererComponent(JList<?> jlist, Object e, int i, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(jlist, e, i, isSelected, cellHasFocus);
            setText(((DictionaryCommand) e).getCommandName());
            if (!isEM){
                if (((DictionaryCommand)e).getType() == Command.CommandType.CONFIGURATION){
                    setForeground(Color.GRAY);
                }
            }
            return this;
        }
    }
    
    private class SortedListModel extends AbstractListModel {
        SortedSet<DictionaryCommand> model;
        
        SortedListModel(){
            model = new TreeSet<DictionaryCommand>(new Comparator<DictionaryCommand>(){
                @Override
                public int compare(DictionaryCommand o1, DictionaryCommand o2) {
                    return o1.getCommandName().compareTo(o2.getCommandName());
                }
            });
        }
        
        @Override
        public int getSize() {
            return model.size();
        }

        @Override
        public DictionaryCommand getElementAt(int index) {
            return (DictionaryCommand)model.toArray()[index];
        }

        public void add(DictionaryCommand element) {
            if (model.add(element)) {
                fireContentsChanged(this, 0, getSize());
            }
        }
        
        public void addAll(DictionaryCommand elements[]) {
            Collection c = Arrays.asList(elements);
            model.addAll(c);
            fireContentsChanged(this, 0, getSize());
        }
        
        public void clear() {
            clearSelection();
            model.clear();
            fireContentsChanged(this, 0, getSize());
        }
        
        public boolean contains(DictionaryCommand element) {
            return model.contains(element);
        }
        
        public Object firstElement() {
            // Return the appropriate element
            return model.first();
        }

        public Iterator iterator() {
            return model.iterator();
        }

        public Object lastElement() {
            // Return the appropriate element
            return model.last();
        }
        
        public boolean removeElement(DictionaryCommand element) {
            boolean removed = model.remove(element);
            if (removed) {
                fireContentsChanged(this, 0, getSize());
            }
            return removed;   
        }        
        
        
    }
}
