package org.lsst.ccs.gconsole.plugins.console;

import java.io.IOException;
import java.net.URL;
import org.freehep.application.studio.Plugin;
import org.freehep.application.studio.Studio;
import org.freehep.jas.extensions.jconsole.JConsoleService;
import org.freehep.jas.extensions.jconsole.JLineConsole;
import org.freehep.jas.extensions.jconsole.JLineConsoleProvider;
import org.freehep.util.FreeHEPLookup;
import org.freehep.util.commanddispatcher.CommandProcessor;
import org.freehep.xml.menus.XMLMenuBuilder;
import org.lsst.ccs.gconsole.Console;
import org.lsst.ccs.shell.JLineShell;
import org.lsst.ccs.subsystem.shell.ConsoleCommandShell;
import org.xml.sax.SAXException;

/**
 * This plugin creates and manages command consoles.
 */
public class LsstConsolePlugin extends Plugin {
    
// -- Fields : -----------------------------------------------------------------

    private final String defaultConsoleName = "LSST Console";
    private Console agent;


// -- Life cycle : -------------------------------------------------------------
    
    @Override
    synchronized protected void init() throws SAXException, IOException {

        Studio studio = getApplication();
        FreeHEPLookup lookup = studio.getLookup();
        lookup.add(this);

        studio.getCommandTargetManager().add(new ConsoleCommands());

        XMLMenuBuilder builder = studio.getXMLMenuBuilder();
        URL xml = getClass().getResource("LsstConsolePlugin.menus");
        builder.build(xml);
    }

    @Override
    synchronized protected void postInit() {
        agent = (Console) getApplication().getLookup().lookup(Console.class);
        JConsoleService cs = (JConsoleService) getApplication().getLookup().lookup(JConsoleService.class);
        if (cs == null) throw new IllegalStateException("JConsole service is not available");
        cs.addConsoleProvider(JLineConsole.class, new JLineConsoleProvider());
    }
    
    
// -- Handling consoles : ------------------------------------------------------
    
   
    synchronized private JLineConsole createCommandConsole(String name) {
        Studio studio = getApplication();
        try {
            JConsoleService cs = (JConsoleService) getApplication().getLookup().lookup(JConsoleService.class);
            if (cs != null) {
                JLineConsole console = (JLineConsole) cs.createConsole(JLineConsole.class, name, null, null);
                JLineShell shell = ConsoleCommandShell.createJLineShell(agent.getMessagingAccess(), console.getConsoleReader());
                Thread t = new Thread("ConsoleInput-" + name) {
                    @Override
                    public void run() {
                        try {
                            shell.run();
                        } catch (IOException x) {
                            getApplication().error("Error in command shell", x);
                        } finally {
                        }
                    }
                };
                t.start();
                return console;
            }
        } catch (Exception x) {
            studio.error("Failed to start Console: " + name, x);
        }
        return null;
    }
    
    
// -- Command processor : ------------------------------------------------------

    private class ConsoleCommands extends CommandProcessor {
        public void onLsstConsole() {
            createCommandConsole(defaultConsoleName);
        }
    }
}
